/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.graph;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ocheyedan.ply.graph.Graph;
import net.ocheyedan.ply.graph.Vertex;

public final class Graphs {
    private static final Integer NOT_VISTITED = 0;
    private static final Integer VISITING = 1;
    private static final Integer VISITED = 2;

    public static <T> void visit(Graph<T> graph, Visitor<T> visitor) {
        List<Vertex<T>> vertices = graph.getVertices();
        HashMap<Vertex<T>, Integer> vertexStateMap = new HashMap<Vertex<T>, Integer>();
        for (Vertex<T> vertex : vertices) {
            Graphs.visit(vertex, visitor, vertexStateMap);
        }
    }

    private static <T> void visit(Vertex<T> vertex, Visitor<T> visitor, Map<Vertex<T>, Integer> vertexStateMap) {
        if (Graphs.isNotVisited(vertex, vertexStateMap)) {
            vertexStateMap.put(vertex, VISITING);
            visitor.visit(vertex);
            for (Vertex<T> child : vertex.getChildren()) {
                Graphs.visit(child, visitor, vertexStateMap);
            }
            vertexStateMap.put(vertex, VISITED);
        }
    }

    private static <T> boolean isNotVisited(Vertex<T> vertex, Map<Vertex<T>, Integer> vertexStateMap) {
        if (!vertexStateMap.containsKey(vertex)) {
            return true;
        }
        Integer state = vertexStateMap.get(vertex);
        return NOT_VISTITED.equals(state);
    }

    public static interface Visitor<T> {
        public void visit(Vertex<T> var1);
    }
}

