/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.ocheyedan.ply.graph.Graph;
import net.ocheyedan.ply.graph.Vertex;

public class CycleDetector {
    private static final Integer NOT_VISTITED = 0;
    private static final Integer VISITING = 1;
    private static final Integer VISITED = 2;

    public static <T> List<Vertex<T>> hasCycle(Graph<T> graph) {
        List<Vertex<T>> vertices = graph.getVertices();
        HashMap<Vertex<T>, Integer> vertexStateMap = new HashMap<Vertex<T>, Integer>();
        List<Vertex<T>> cycle = null;
        for (Vertex<T> vertex : vertices) {
            if (CycleDetector.isNotVisited(vertex, vertexStateMap) && (cycle = CycleDetector.introducesCycle(vertex, vertexStateMap)) != null) break;
        }
        return cycle;
    }

    public static <T> List<Vertex<T>> introducesCycle(Vertex<T> vertex) {
        HashMap<Vertex<T>, Integer> vertexStateMap = new HashMap<Vertex<T>, Integer>();
        return CycleDetector.introducesCycle(vertex, vertexStateMap);
    }

    public static <T> List<Vertex<T>> introducesCycle(Vertex<T> vertex, Map<Vertex<T>, Integer> vertexStateMap) {
        LinkedList<Vertex<T>> cycleStack = new LinkedList<Vertex<T>>();
        boolean hasCycle = CycleDetector.dfsVisit(vertex, cycleStack, vertexStateMap);
        if (hasCycle) {
            Vertex<T> first = cycleStack.getFirst();
            int pos = cycleStack.lastIndexOf(first);
            List<Vertex<T>> cycle = cycleStack.subList(0, pos + 1);
            Collections.reverse(cycle);
            return cycle;
        }
        return null;
    }

    private static <T> boolean isNotVisited(Vertex<T> vertex, Map<Vertex<T>, Integer> vertexStateMap) {
        if (!vertexStateMap.containsKey(vertex)) {
            return true;
        }
        Integer state = vertexStateMap.get(vertex);
        return NOT_VISTITED.equals(state);
    }

    private static <T> boolean isVisiting(Vertex<T> vertex, Map<Vertex<T>, Integer> vertexStateMap) {
        Integer state = vertexStateMap.get(vertex);
        return VISITING.equals(state);
    }

    private static <T> boolean dfsVisit(Vertex<T> vertex, LinkedList<Vertex<T>> cycle, Map<Vertex<T>, Integer> vertexStateMap) {
        cycle.addFirst(vertex);
        vertexStateMap.put(vertex, VISITING);
        List<Vertex<T>> vertices = vertex.getChildren();
        for (Vertex<T> childVertex : vertices) {
            if (CycleDetector.isNotVisited(childVertex, vertexStateMap)) {
                boolean hasCycle = CycleDetector.dfsVisit(childVertex, cycle, vertexStateMap);
                if (!hasCycle) continue;
                return true;
            }
            if (!CycleDetector.isVisiting(childVertex, vertexStateMap)) continue;
            cycle.addFirst(childVertex);
            return true;
        }
        vertexStateMap.put(vertex, VISITED);
        cycle.removeFirst();
        return false;
    }
}

