/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.dep.visitors;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.dep.visitors.Dependencies;
import net.ocheyedan.ply.dep.visitors.DependencyAnnotationVisitor;
import net.ocheyedan.ply.dep.visitors.DependencyFieldVisitor;
import net.ocheyedan.ply.dep.visitors.DependencyMethodVisitor;
import net.ocheyedan.ply.dep.visitors.DependencySignatureVisitor;
import net.ocheyedan.ply.dep.visitors.DependencyVisitors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureVisitor;

public class DependencyVisitor
extends ClassVisitor {
    private final Dependencies dependencies;
    private final SignatureVisitor signatureVisitor;
    private final AnnotationVisitor annotationVisitor;
    private final FieldVisitor fieldVisitor;
    private final MethodVisitor methodVisitor;

    public DependencyVisitor(String className) {
        super(327680);
        this.dependencies = new Dependencies(className);
        this.signatureVisitor = new DependencySignatureVisitor(this.dependencies);
        this.annotationVisitor = new DependencyAnnotationVisitor(this.dependencies);
        this.fieldVisitor = new DependencyFieldVisitor(this.dependencies, this.annotationVisitor);
        this.methodVisitor = new DependencyMethodVisitor(this.dependencies, this.annotationVisitor, this.signatureVisitor);
    }

    public void visit(InputStream classFile) {
        try {
            new ClassReader(classFile).accept((ClassVisitor)this, 6);
        }
        catch (IOException ioe) {
            Output.print(ioe);
            System.exit(1);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (signature != null) {
            DependencyVisitors.addSignature(signature, this.signatureVisitor);
        } else {
            DependencyVisitors.addName(superName, this.dependencies);
            DependencyVisitors.addNames(interfaces, this.dependencies);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        DependencyVisitors.addDescription(desc, this.dependencies);
        return this.annotationVisitor;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        DependencyVisitors.addDescription(desc, this.dependencies);
        return this.annotationVisitor;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (signature != null) {
            DependencyVisitors.addTypeSignature(signature, this.signatureVisitor);
        } else {
            DependencyVisitors.addDescription(desc, this.dependencies);
        }
        if (value instanceof Type) {
            DependencyVisitors.addType((Type)value, this.dependencies);
        }
        return this.fieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (signature != null) {
            DependencyVisitors.addSignature(signature, this.signatureVisitor);
        } else {
            DependencyVisitors.addMethodDescription(desc, this.dependencies);
        }
        DependencyVisitors.addNames(exceptions, this.dependencies);
        return this.methodVisitor;
    }

    public Set<String> getDependencies() {
        return this.dependencies.getDependencies();
    }
}

