/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.dep.visitors;

import net.ocheyedan.ply.dep.visitors.Dependencies;
import net.ocheyedan.ply.dep.visitors.DependencyVisitors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureVisitor;

class DependencyMethodVisitor
extends MethodVisitor {
    private final Dependencies dependencies;
    private final AnnotationVisitor annotationVisitor;
    private final SignatureVisitor signatureVisitor;

    DependencyMethodVisitor(Dependencies dependencies, AnnotationVisitor annotationVisitor, SignatureVisitor signatureVisitor) {
        super(327680);
        this.dependencies = dependencies;
        this.annotationVisitor = annotationVisitor;
        this.signatureVisitor = signatureVisitor;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return this.annotationVisitor;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        DependencyVisitors.addDescription(desc, this.dependencies);
        return this.annotationVisitor;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        DependencyVisitors.addDescription(desc, this.dependencies);
        return this.annotationVisitor;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        DependencyVisitors.addDescription(desc, this.dependencies);
        return this.annotationVisitor;
    }

    public void visitTypeInsn(int opcode, String type) {
        if (type.charAt(0) == '[') {
            DependencyVisitors.addDescription(type, this.dependencies);
        } else {
            DependencyVisitors.addName(type, this.dependencies);
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        DependencyVisitors.addName(owner, this.dependencies);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        DependencyVisitors.addName(owner, this.dependencies);
    }

    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type) {
            DependencyVisitors.addType((Type)cst, this.dependencies);
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        DependencyVisitors.addDescription(desc, this.dependencies);
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        DependencyVisitors.addDescription(desc, this.dependencies);
        return this.annotationVisitor;
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        DependencyVisitors.addName(type, this.dependencies);
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        DependencyVisitors.addDescription(desc, this.dependencies);
        return this.annotationVisitor;
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (signature != null) {
            DependencyVisitors.addTypeSignature(signature, this.signatureVisitor);
        } else {
            DependencyVisitors.addDescription(desc, this.dependencies);
        }
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
        DependencyVisitors.addDescription(desc, this.dependencies);
        return this.annotationVisitor;
    }
}

