/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.dep;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.dep.Auth;
import net.ocheyedan.ply.props.PropFile;

public class RepositoryAtom {
    public static final Comparator<RepositoryAtom> LOCAL_COMPARATOR = new Comparator<RepositoryAtom>(){

        @Override
        public int compare(RepositoryAtom o1, RepositoryAtom o2) {
            boolean local2;
            boolean local1 = "file".equals(o1.repositoryUri.getScheme());
            if (local1 == (local2 = "file".equals(o2.repositoryUri.getScheme()))) {
                return 0;
            }
            if (local1) {
                return -1;
            }
            return 1;
        }
    };
    public static final String MAVEN_REPO_TYPE_PREFIX = "maven:";
    public static final String PLY_REPO_TYPE_PREFIX = "ply:";
    public final String preResolvedUri;
    public final URI repositoryUri;
    public final Type type;
    private final AtomicReference<Auth> auth;

    public RepositoryAtom(String preResolvedUri, URI repositoryUri, Type type) {
        this.preResolvedUri = preResolvedUri;
        this.repositoryUri = repositoryUri;
        this.type = type;
        this.auth = new AtomicReference();
    }

    public RepositoryAtom(String preResolvedUri, URI repositoryUri) {
        this(preResolvedUri, repositoryUri, null);
    }

    public String getPropertyName() {
        return this.repositoryUri.toString();
    }

    public String getPreResolvedUri() {
        return this.preResolvedUri;
    }

    public String getPropertyValue() {
        return this.type == null ? "" : this.type.name();
    }

    public Type getResolvedType() {
        return this.type == null ? Type.ply : this.type;
    }

    public Auth getAuth() {
        return this.auth.get();
    }

    public boolean isPlyType() {
        return this.getResolvedType() == Type.ply;
    }

    public String getResolvedPropertyValue() {
        return this.getResolvedType().name();
    }

    public void setAuth(Auth auth) {
        this.auth.set(auth);
    }

    public String toString() {
        return this.getResolvedPropertyValue() + ":" + this.getPropertyName();
    }

    public Map<String, String> getAuthHeaders() {
        if (this.auth.get() != null) {
            return this.auth.get().getHeaders();
        }
        return Collections.emptyMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryAtom that = (RepositoryAtom)o;
        if (this.repositoryUri != null ? !this.repositoryUri.equals(that.repositoryUri) : that.repositoryUri != null) {
            return false;
        }
        return this.type == null ? that.type == null : this.type.equals((Object)that.type);
    }

    public int hashCode() {
        int result = this.repositoryUri != null ? this.repositoryUri.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public static String atomFromProp(PropFile.Prop repositoryProp) {
        String value = !repositoryProp.value().isEmpty() ? repositoryProp.value() + ":" : "";
        return value + repositoryProp.name;
    }

    public static RepositoryAtom parse(String atom) {
        URI repositoryUri;
        Type type;
        if (atom == null || atom.isEmpty()) {
            return null;
        }
        if (atom.startsWith(MAVEN_REPO_TYPE_PREFIX)) {
            type = Type.maven;
            atom = atom.substring(MAVEN_REPO_TYPE_PREFIX.length());
        } else if (atom.startsWith(PLY_REPO_TYPE_PREFIX)) {
            type = Type.ply;
            atom = atom.substring(PLY_REPO_TYPE_PREFIX.length());
        } else {
            type = Type.ply;
        }
        String preResolved = atom;
        atom = FileUtil.resolveUnixTilde(atom);
        File localRef = new File(atom);
        try {
            localRef = localRef.getCanonicalFile();
            if (localRef.isDirectory()) {
                String resolved;
                if (!atom.startsWith("/") && (resolved = localRef.getCanonicalPath()).startsWith("file://")) {
                    return new RepositoryAtom(preResolved, localRef.toURI(), type);
                }
                atom = "file://" + localRef.getCanonicalPath();
            }
        }
        catch (IOException resolved) {
            // empty catch block
        }
        try {
            atom = atom.startsWith("file:") ? FileUtil.encodeForURI(atom) : atom;
            repositoryUri = URI.create(atom);
        }
        catch (IllegalArgumentException iae) {
            Output.print(iae);
            return null;
        }
        return new RepositoryAtom(preResolved, repositoryUri, type);
    }

    public static enum Type {
        ply,
        maven;

    }
}

