/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.dep;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.dep.Auth;
import net.ocheyedan.ply.dep.BasicAuth;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.dep.GitHubAuth;
import net.ocheyedan.ply.dep.RepositoryAtom;
import net.ocheyedan.ply.dep.RepositoryRegistry;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Filter;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.PropFileWriter;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

public final class Repos {
    public static String getDirectoryPathForRepo(RepositoryAtom repositoryAtom) {
        try {
            String repoPath = repositoryAtom.getPropertyName();
            repoPath = FileUtil.stripFileUriPrefix(repoPath);
            if (!FileUtil.isLocalPath(repoPath)) {
                return repoPath == null ? null : (repoPath.endsWith("/") ? repoPath.substring(0, repoPath.length() - 1) : repoPath);
            }
            return FileUtil.getCanonicalPath(new File(repoPath));
        }
        catch (RuntimeException runtimeException) {
            return repositoryAtom.getPropertyName();
        }
    }

    public static boolean install(Scope scope, RepositoryAtom localRepo) {
        String artifactName = Props.get("artifact.name", Context.named("project"), scope).value();
        DependencyAtom dependencyAtom = Deps.getProjectDep();
        return Repos.install(scope, localRepo, artifactName, dependencyAtom);
    }

    public static boolean install(Scope scope, RepositoryAtom localRepo, String artifactName, DependencyAtom dependencyAtom) {
        String buildDirPath = Props.get("build.dir", Context.named("project"), scope).value();
        File artifact = FileUtil.fromParts(buildDirPath, artifactName);
        if (!artifact.exists()) {
            return false;
        }
        String plyProjectDirPath = Props.get("project.dir", Context.named("ply"), scope).value();
        File dependenciesFile = FileUtil.fromParts(plyProjectDirPath, "config", String.format("dependencies%s.properties", scope.getFileSuffix()));
        return Repos.installArtifact(scope, artifact, dependenciesFile, dependencyAtom, localRepo);
    }

    public static boolean installArtifact(Scope scope, File artifact, File dependenciesFile, DependencyAtom dependencyAtom, RepositoryAtom localRepo) {
        String localRepoDirPath = Deps.getDependencyDirectoryPathForRepo(dependencyAtom, localRepo);
        String localRepoArtifactPath = Deps.getDependencyArtifactPathForRepo(dependencyAtom, localRepo);
        File localRepoArtifact = new File(localRepoArtifactPath);
        if (!FileUtil.copy(artifact, localRepoArtifact)) {
            return false;
        }
        String artifactsScopeName = Props.get("artifacts.label", Context.named("project"), scope).value();
        Scope artifactsScope = Scope.named(artifactsScopeName);
        if (!Scope.Default.equals(artifactsScope)) {
            String artifactsScopeFile = String.format("%s.artifacts.label", dependencyAtom.getArtifactName());
            File localRepoArtifactsScopePath = FileUtil.fromParts(localRepoDirPath, artifactsScopeFile);
            PropFile artifactsScopePropFile = new PropFile(Context.named(artifactsScopeFile), scope, PropFile.Loc.Local);
            artifactsScopePropFile.add("artifacts.label", artifactsScopeName);
            if (!PropFiles.store(artifactsScopePropFile, localRepoArtifactsScopePath.getPath(), true)) {
                return false;
            }
        }
        PropFile checksum = new PropFile(Context.named("checksum"), artifactsScope, PropFile.Loc.Local);
        File localRepoChecksumFile = FileUtil.fromParts(localRepoDirPath, String.format("checksum%s.properties", artifactsScope.getFileSuffix()));
        String artifactChecksum = FileUtil.getSha1Hash(localRepoArtifact);
        checksum.add("artifact", artifactChecksum);
        if (!Repos.addDependenciesChecksumValues(scope, checksum, dependenciesFile)) {
            return false;
        }
        checksum.add("timestamp", String.format("%d", System.currentTimeMillis()));
        if (!PropFiles.store(checksum, localRepoChecksumFile.getPath(), true)) {
            return false;
        }
        File localRepoDependenciesFile = FileUtil.fromParts(localRepoDirPath, String.format("dependencies%s.properties", artifactsScope.getFileSuffix()));
        if (dependenciesFile != null && dependenciesFile.exists()) {
            PropFile propFile = PropFiles.load(dependenciesFile.getAbsolutePath(), false, true);
            PropFile filtered = new PropFile(Context.named("dependencies"), scope, PropFile.Loc.AdHoc);
            for (PropFile.Prop prop : propFile.props()) {
                PropFile.Prop filteredProp = Filter.filter(prop, String.valueOf(System.identityHashCode(Repos.class)), Props.get(scope));
                filtered.add(filteredProp.name, filteredProp.value());
            }
            return PropFiles.store(filtered, PropFileWriter.Default, localRepoDependenciesFile.getAbsolutePath(), true, true);
        }
        PropFile dependencies = new PropFile(Context.named("dependencies"), artifactsScope, PropFile.Loc.Local);
        return PropFiles.store(dependencies, localRepoDependenciesFile.getPath(), true);
    }

    private static boolean addDependenciesChecksumValues(Scope scope, PropFile checksum, File dependenciesFile) {
        PropFile resolvedDependencies = Deps.getResolvedProperties(true);
        if (resolvedDependencies == null) {
            if (dependenciesFile != null && dependenciesFile.exists()) {
                Output.print("^error^ Could not find the resolved-deps.properties file; dependencies must be resolved to compute checksum.", new Object[0]);
                return false;
            }
            return true;
        }
        for (PropFile.Prop prop : resolvedDependencies.props()) {
            String sha1;
            PropFile checksumPropFile = new PropFile(Context.named("checksum"), PropFile.Loc.Local);
            String checksumFilePath = Repos.createChecksumFile(scope, prop.value());
            if (checksumFilePath == null) {
                return false;
            }
            PropFiles.load(checksumFilePath, checksumPropFile, true);
            if (checksumPropFile.contains("artifact")) {
                sha1 = checksumPropFile.get("artifact").value();
            } else {
                sha1 = FileUtil.getSha1Hash(new File(prop.value()));
                checksumPropFile.add("artifact", sha1);
                PropFiles.store(checksumPropFile, checksumFilePath, true);
            }
            checksum.add(prop.name, sha1);
        }
        return true;
    }

    private static String createChecksumFile(Scope scope, String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(File.separatorChar);
        if (index == -1) {
            return null;
        }
        String artifactsLabelName = Props.get("artifacts.label", Context.named("project"), scope).value();
        Scope artifactsLabel = Scope.named(artifactsLabelName);
        return FileUtil.pathFromParts(path.substring(0, index), String.format("checksum%s.properties", artifactsLabel.getFileSuffix()));
    }

    public static RepositoryRegistry createRepositoryRegistry(File configDirectory, Scope scope, DependencyAtom syntheticDependencyKey, List<DependencyAtom> syntheticDependencies) throws SystemExit {
        PropFile.Prop localRepoProp = Props.get("localRepo", Context.named("depmngr"), scope, configDirectory);
        RepositoryAtom localRepo = RepositoryAtom.parse(localRepoProp.value());
        if (localRepo == null) {
            if (PropFile.Prop.Empty.equals(localRepoProp)) {
                Output.print("^error^ No ^b^localRepo^r^ property defined (^b^ply set localRepo=xxxx in depmngr^r^).", new Object[0]);
            } else {
                Output.print("^error^ Could not resolve directory for ^b^localRepo^r^ property [ is ^b^%s^r^ ].", localRepoProp.value());
            }
            throw new SystemExit(1);
        }
        ArrayList<RepositoryAtom> repositoryAtoms = new ArrayList<RepositoryAtom>();
        PropFileChain repositories = Props.get(Context.named("repositories"), scope, configDirectory);
        if (repositories != null) {
            for (PropFile.Prop repoProp : repositories.props()) {
                String repoUri = repoProp.name;
                if (localRepo.getPropertyName().equals(repoUri)) continue;
                String repoType = repoProp.value();
                String repoAtom = repoType + ":" + repoUri;
                RepositoryAtom repo = RepositoryAtom.parse(repoAtom);
                if (repo == null) {
                    Output.print("^warn^ Invalid repository declared %s, ignoring.", repoAtom);
                    continue;
                }
                Auth auth = Repos.getAuth(configDirectory, scope, repo);
                repo.setAuth(auth);
                repositoryAtoms.add(repo);
            }
        }
        Collections.sort(repositoryAtoms, RepositoryAtom.LOCAL_COMPARATOR);
        HashMap<DependencyAtom, List<DependencyAtom>> synthetic = null;
        if (syntheticDependencyKey != null) {
            synthetic = new HashMap<DependencyAtom, List<DependencyAtom>>(1);
            synthetic.put(syntheticDependencyKey, syntheticDependencies);
        }
        return new RepositoryRegistry(localRepo, repositoryAtoms, synthetic);
    }

    public static RepositoryAtom getExistingRepo(File configDir, Scope scope, String repository) throws SystemExit {
        RepositoryAtom atom = RepositoryAtom.parse(repository);
        if (atom == null) {
            Output.print("^error^ Repository %s not of format [type:]repoUri.", repository);
            throw new SystemExit(1);
        }
        PropFile.Prop found = Props.get(atom.getPreResolvedUri(), Context.named("repositories"), scope, configDir);
        if (PropFile.Prop.Empty.equals(found)) {
            String toTry = FileUtil.reverseUnixTilde(atom.getPreResolvedUri());
            RepositoryAtom toTryAtom = RepositoryAtom.parse(toTry);
            PropFile.Prop prop = found = toTryAtom == null ? PropFile.Prop.Empty : Props.get(toTryAtom.getPreResolvedUri(), Context.named("repositories"), scope, configDir);
            if (PropFile.Prop.Empty.equals(found)) {
                Output.print("^warn^ Repository not found; given %s", repository);
                return null;
            }
            atom = toTryAtom;
        }
        return atom;
    }

    public static PropFile.Prop getAuthPropFromRepo(File configDir, Scope scope, RepositoryAtom repositoryAtom) {
        String repository = repositoryAtom.getPreResolvedUri();
        PropFile.Prop prop = Props.get(repository, Context.named("repomngr"), scope, configDir);
        if (PropFile.Prop.Empty.equals(prop)) {
            String toTry;
            if (repository.startsWith("~")) {
                toTry = FileUtil.resolveUnixTilde(repository);
            } else if (repository.startsWith("/")) {
                toTry = FileUtil.reverseUnixTilde(repository);
            } else {
                return prop;
            }
            return Props.get(toTry, Context.named("repomngr"), scope, configDir);
        }
        return prop;
    }

    public static PropFile.Prop addAuthRepomngrProp(PropFile repomngr, String repository, Auth auth) {
        String propertyValue = auth.getPropertyValue();
        if (repomngr.contains(repository)) {
            repomngr.remove(repository);
        }
        return repomngr.add(repository, propertyValue);
    }

    public static Auth getAuth(File configDir, Scope scope, RepositoryAtom repositoryAtom) {
        AuthType authType;
        String repository = repositoryAtom.getPreResolvedUri();
        PropFile.Prop prop = Repos.getAuthPropFromRepo(configDir, scope, repositoryAtom);
        if (PropFile.Prop.Empty.equals(prop)) {
            return null;
        }
        String value = prop.value();
        int index = value.indexOf(58);
        if (index == -1) {
            Output.print("^warn^ Found auth setting for repo [ %s ] but could not parse it [ %s ], ignoring", repository, value);
            return null;
        }
        String type = value.substring(0, index);
        try {
            authType = AuthType.valueOf(type);
        }
        catch (Exception e) {
            Output.print("^warn^ Found auth setting for repo [ %s ] but invalid auth-type [ %s ], ignoring", repository, value);
            return null;
        }
        int usernameIndex = value.indexOf(58, index + 1);
        if (usernameIndex == -1) {
            Output.print("^warn^ Found auth setting for repo [ %s ] but could not parse it [ %s ], ignoring", repository, value);
            return null;
        }
        String username = value.substring(index + 1, usernameIndex);
        if (usernameIndex >= value.length() - 1) {
            Output.print("^warn^ Found auth setting for repo [ %s ] but could not parse it [ %s ], ignoring", repository, value);
            return null;
        }
        String encryptedPwd = value.substring(usernameIndex + 1);
        return authType.get(username, encryptedPwd, repositoryAtom, configDir, scope);
    }

    private Repos() {
    }

    public static enum AuthType {
        git,
        basic;


        public Auth get(String username, String encryptedPwd, RepositoryAtom atom, File configDir, Scope scope) {
            switch (this) {
                case git: {
                    return new GitHubAuth(username, encryptedPwd, atom, configDir, scope);
                }
                case basic: {
                    return new BasicAuth(username, encryptedPwd, atom);
                }
            }
            throw new AssertionError((Object)"Unknown repo auth-type");
        }
    }
}

