/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.dep;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PwdUtil;
import net.ocheyedan.ply.dep.Auth;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.dep.RepositoryAtom;
import sun.misc.BASE64Encoder;

final class BasicAuth
implements Auth {
    private final String username;
    private final String encryptedPwd;
    private final RepositoryAtom repositoryAtom;
    private final Map<String, String> headers;

    BasicAuth(String username, String encryptedPwd, RepositoryAtom repositoryAtom) {
        this.username = username;
        this.encryptedPwd = encryptedPwd;
        this.repositoryAtom = repositoryAtom;
        this.headers = new HashMap<String, String>(2, 1.0f);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getEncryptedPwd() {
        return this.encryptedPwd;
    }

    @Override
    public RepositoryAtom getRepositoryAtom() {
        return this.repositoryAtom;
    }

    @Override
    public String getPropertyValue() {
        return String.format("basic:%s:%s", this.username, this.encryptedPwd);
    }

    @Override
    public String getArtifactPath(String remotePathDir, DependencyAtom dependencyAtom) {
        return FileUtil.pathFromParts(remotePathDir, dependencyAtom.getArtifactName());
    }

    @Override
    public String getDependenciesPath(String remotePathDir, String name) {
        return this.getPath(remotePathDir, name);
    }

    @Override
    public String getPath(String remotePathDir, String fileName) {
        return FileUtil.pathFromParts(remotePathDir, fileName);
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this.headers.isEmpty()) {
            String basicAuth = this.getBasicAuthenticationProperty(this.username, PwdUtil.decrypt(this.encryptedPwd));
            this.headers.put("Authorization", basicAuth);
        }
        return this.headers;
    }

    @Override
    public void acquireAccess(Auth.Acquisition acquisition) {
        String password = acquisition.getAccess(this.username, this.encryptedPwd);
        if (!this.head(this.repositoryAtom.getPreResolvedUri(), this.username, password)) {
            Output.print("^error^ Could not create auth token for ^b^%s^r^ in repo ^b^%s^r^", this.username, this.repositoryAtom.getPreResolvedUri());
            Output.print("^error^ Perhaps you entered the wrong password?", new Object[0]);
            System.exit(1);
        }
    }

    private String getBasicAuthenticationProperty(String username, String pwd) {
        try {
            String urlEncodedUsername = URLEncoder.encode(username, "UTF-8");
            String urlEncodedPwd = URLEncoder.encode(pwd, "UTF-8");
            String userpass = String.format("%s:%s", urlEncodedUsername, urlEncodedPwd);
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedUserpass = encoder.encode(userpass.getBytes());
            return "Basic " + encodedUserpass;
        }
        catch (UnsupportedEncodingException uee) {
            Output.print(uee);
            System.exit(1);
            return null;
        }
    }

    private boolean head(String urlPath, String username, String pwd) {
        URLConnection urlConnection = null;
        try {
            URL url = URI.create(urlPath).toURL();
            urlConnection = url.openConnection();
            if (urlConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)urlConnection).setRequestMethod("HEAD");
            }
            String basicAuth = this.getBasicAuthenticationProperty(username, pwd);
            urlConnection.setRequestProperty("Authorization", basicAuth);
            urlConnection.setDoOutput(false);
            urlConnection.connect();
            return true;
        }
        catch (IOException ioe) {
            Output.print(ioe);
            return false;
        }
    }
}

