/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;

public final class PlyUtil {
    public static final String INSTALL_DIRECTORY = System.getProperty("ply.home");
    public static final String PLY_VERSION = System.getProperty("ply.version");
    public static final File SYSTEM_CONFIG_DIR = new File(INSTALL_DIRECTORY + File.separator + "config");
    public static final File SYSTEM_SCRIPTS_DIR = new File(INSTALL_DIRECTORY + File.separator + "scripts");
    public static final File LOCAL_PROJECT_DIR = PlyUtil.resolveLocalDir();
    public static final File LOCAL_CONFIG_DIR = PlyUtil.resolveLocalConfigDir(LOCAL_PROJECT_DIR);
    private static final String OS = System.getProperty("os.name");
    private static final String OS_LOWER_CASE = OS == null ? "" : OS.toLowerCase();

    public static boolean isHeadless() {
        return "true".equalsIgnoreCase(Props.get("headless", Context.named("ply")).value());
    }

    public static boolean isUnicodeSupported() {
        return "true".equalsIgnoreCase(Props.get("unicode", Context.named("ply")).value());
    }

    public static String getProjectDir(File configDirectory) {
        return FileUtil.getCanonicalPath(FileUtil.fromParts(configDirectory.getPath(), ".."));
    }

    public static void addInvocationProperties(String name, String[] keys, String ... values) {
        if (keys == null || values == null || keys.length < 1 || keys.length != values.length) {
            throw new AssertionError((Object)"Must specify keys and the length must match values' length");
        }
        String path = Props.get("ply.invocation.dir", Context.named("project")).value();
        if (path == null || path.isEmpty()) {
            Output.print("^warn^ Property ^b^ply.invocation.dir^r^ not correctly setup in context ^b^project^r^", new Object[0]);
            return;
        }
        PropFile propFile = new PropFile(Context.named(""), PropFile.Loc.AdHoc);
        for (int i = 0; i < keys.length; ++i) {
            propFile.add(keys[i], values[i]);
        }
        PropFiles.store(propFile, FileUtil.fromParts(path, name).getAbsolutePath(), true);
    }

    public static String readInvocationProperty(String name, String key) {
        PropFile existing = PlyUtil.readInvocationProperties(name);
        return existing != null ? existing.get(key).value() : null;
    }

    public static boolean matchingInvocationProperty(String name, String key, String expected) {
        String value = PlyUtil.readInvocationProperty(name, key);
        return expected.equals(value);
    }

    public static PropFile readInvocationProperties(String name) {
        String path = Props.get("ply.invocation.dir", Context.named("project")).value();
        if (path == null || path.isEmpty()) {
            return null;
        }
        File file = FileUtil.fromParts(path, name);
        if (!file.exists()) {
            return null;
        }
        PropFile propFile = new PropFile(Context.named(""), PropFile.Loc.AdHoc);
        PropFiles.load(file.getAbsolutePath(), propFile, false, false);
        return propFile;
    }

    public static void cleanupInvocationProperties() {
        String path = Props.get("ply.invocation.dir", Context.named("project")).value();
        if (path == null || path.isEmpty()) {
            return;
        }
        File directory = new File(path);
        if (directory.exists()) {
            FileUtil.delete(directory);
        }
    }

    public static boolean isWindowsOs() {
        return OS_LOWER_CASE.contains("windows");
    }

    public static String[] varargs(String ... args) {
        return args;
    }

    private static File resolveLocalDir() {
        String defaultPath;
        File[] roots = File.listRoots();
        String path = defaultPath = "./.ply";
        File ply = new File(path);
        boolean atRoot = false;
        try {
            while (!ply.exists() && !(atRoot = PlyUtil.reachedRoot(roots, ".ply", ply.getCanonicalPath()))) {
                path = "../" + path;
                ply = new File(path);
            }
            if (atRoot) {
                return new File(defaultPath);
            }
        }
        catch (IOException ioe) {
            Output.print(ioe);
            return new File(defaultPath);
        }
        return ply;
    }

    private static boolean reachedRoot(File[] roots, String rootSuffix, String canonicalPath) {
        for (File root : roots) {
            if (!canonicalPath.equals(root.getPath() + rootSuffix)) continue;
            return true;
        }
        return false;
    }

    private static File resolveLocalConfigDir(File resolvedLocalProjectDir) {
        try {
            String path = resolvedLocalProjectDir.getCanonicalPath();
            return new File(path.endsWith(File.separator) ? path + "config" : path + File.separator + "config");
        }
        catch (IOException ioe) {
            Output.print(ioe);
            SystemExit.exit(1);
            return null;
        }
    }

    public static String getIPAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return inetAddress == null ? "<unknown>" : inetAddress.getHostAddress();
    }

    private PlyUtil() {
    }
}

