/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import net.ocheyedan.ply.BitUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PlyUtil;

public final class FileUtil {
    private static final String USER_HOME = System.getProperty("user.home");

    public static boolean copyDir(File fromDir, File toDir) {
        return FileUtil.copyDir(fromDir, toDir, null);
    }

    public static boolean copyDir(File fromDir, File toDir, FilenameFilter excluding) {
        if (!fromDir.isDirectory() || !fromDir.exists()) {
            return false;
        }
        toDir.mkdirs();
        for (File subFile : fromDir.listFiles()) {
            if (excluding != null && excluding.accept(subFile.getParentFile(), subFile.getName())) continue;
            File toDirSubFile = new File(toDir.getPath() + File.separator + subFile.getName());
            if (!(subFile.isDirectory() ? !FileUtil.copyDir(subFile, toDirSubFile) : !FileUtil.copy(subFile, toDirSubFile))) continue;
            return false;
        }
        return true;
    }

    public static boolean copy(File from, File to) {
        try {
            return FileUtil.copy(new BufferedInputStream(new FileInputStream(from)), to);
        }
        catch (FileNotFoundException fnfe) {
            Output.print(fnfe);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(URL from, File to) {
        InputStream inputStream = null;
        try {
            URLConnection urlConnection = from.openConnection();
            urlConnection.setConnectTimeout(1000);
            inputStream = urlConnection.getInputStream();
            boolean bl = FileUtil.copy(inputStream, to);
            return bl;
        }
        catch (IOException ioe) {
            Output.print(ioe);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    throw new AssertionError((Object)ioe);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(InputStream from, File to) {
        BufferedOutputStream outputStream = null;
        try {
            int read;
            if (!to.exists()) {
                to.getParentFile().mkdirs();
                to.createNewFile();
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(to));
            byte[] tx = new byte[8192];
            while ((read = from.read(tx)) != -1) {
                ((OutputStream)outputStream).write(tx, 0, read);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            Output.print("^error^ Could not copy stream to %s", to.getAbsolutePath());
            Output.print(ioe);
        }
        finally {
            try {
                if (from != null) {
                    from.close();
                }
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
            try {
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
        }
        return false;
    }

    public static String getLocalPath(URL url, Map<String, String> headers, String name, String intoName) {
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            return url.getFile();
        }
        try {
            File tmp = File.createTempFile("ply-", ".tmp");
            if (FileUtil.download(url, headers, tmp, name, intoName, true)) {
                return tmp.getPath();
            }
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static boolean download(URL remoteUrl, Map<String, String> headers, File into, String name, String intoName, boolean ignoreFNF) {
        InputStream stream;
        if (remoteUrl == null) {
            return false;
        }
        try {
            URLConnection urlConnection = remoteUrl.openConnection();
            if (headers != null) {
                for (String key : headers.keySet()) {
                    urlConnection.addRequestProperty(key, headers.get(key));
                }
            }
            stream = urlConnection.getInputStream();
        }
        catch (FileNotFoundException fnfe) {
            Output.print("^dbug^ Failed to download URL [ %s ] - FileNotFoundException - %s", remoteUrl.toString(), fnfe.getMessage());
            if (!ignoreFNF) {
                Output.print(fnfe);
            }
            return false;
        }
        catch (UnknownHostException uhe) {
            Output.print("^error^ Could not download %s; remote URL %s not accessible", name, intoName, remoteUrl.getHost());
            Output.print(uhe);
            Output.print("", new Object[0]);
            return false;
        }
        catch (IOException ioe) {
            Output.print(ioe);
            return false;
        }
        Output.print("^info^ Downloading %s from %s...", name, intoName);
        return FileUtil.copy(stream, into);
    }

    public static String pathFromParts(String ... parts) {
        if (parts == null || parts.length < 1) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (String part : parts) {
            if (buf.length() > 0 && buf.charAt(buf.length() - 1) != File.separatorChar && !part.startsWith(File.separator)) {
                buf.append(File.separatorChar);
            }
            buf.append(part);
        }
        return buf.toString();
    }

    public static File fromParts(String ... parts) {
        String path = FileUtil.pathFromParts(parts);
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    public static String resolveUnixTilde(String path) {
        if (!path.startsWith("~") || USER_HOME == null) {
            return path;
        }
        String resolved = FileUtil.pathFromParts(USER_HOME, path.substring(1));
        if (PlyUtil.isWindowsOs()) {
            resolved = resolved.replaceAll("\\\\", "/");
            resolved = String.format("file://%s%s", resolved.startsWith("/") ? "" : "/", resolved);
        }
        return resolved;
    }

    public static String reverseUnixTilde(String path) {
        String prefix;
        if (path.startsWith(USER_HOME)) {
            return path.replace(USER_HOME, "~");
        }
        String string = prefix = path.startsWith("/") ? "file://" : "file:///";
        if (path.startsWith(String.format("%s%s", prefix, USER_HOME))) {
            return path.replace(String.format("%s%s", prefix, USER_HOME), "~");
        }
        return path;
    }

    public static boolean isLocalPath(String path) {
        if (path == null) {
            return false;
        }
        if (path.startsWith("file:")) {
            return true;
        }
        if (PlyUtil.isWindowsOs()) {
            return !path.contains(":") || FileUtil.isCommonWindowsDrive(path);
        }
        return !path.contains(":");
    }

    private static boolean isCommonWindowsDrive(String path) {
        return (path = path.toLowerCase()).startsWith("/c:") || path.startsWith("c:") || path.startsWith("/d:") || path.startsWith("d:") || path.startsWith("/e:") || path.startsWith("e:") || path.startsWith("/a:") || path.startsWith("a:") || path.startsWith("/b:") || path.startsWith("b:") || path.startsWith("/f:") || path.startsWith("f:") || path.startsWith("/g:") || path.startsWith("g:") || path.startsWith("/h:") || path.startsWith("h:") || path.startsWith("/i:") || path.startsWith("i:") || path.startsWith("/j:") || path.startsWith("j:") || path.startsWith("/k:") || path.startsWith("k:") || path.startsWith("/l:") || path.startsWith("l:") || path.startsWith("/m:") || path.startsWith("m:") || path.startsWith("/n:") || path.startsWith("n:") || path.startsWith("/o:") || path.startsWith("o:") || path.startsWith("/p:") || path.startsWith("p:") || path.startsWith("/q:") || path.startsWith("q:") || path.startsWith("/r:") || path.startsWith("r:") || path.startsWith("/s:") || path.startsWith("s:") || path.startsWith("/t:") || path.startsWith("t:") || path.startsWith("/u:") || path.startsWith("u:") || path.startsWith("/v:") || path.startsWith("v:") || path.startsWith("/w:") || path.startsWith("w:") || path.startsWith("/x:") || path.startsWith("x:") || path.startsWith("/y:") || path.startsWith("y:") || path.startsWith("/z:") || path.startsWith("z:");
    }

    public static String encodeForURI(String filePath) {
        return filePath == null ? null : filePath.replaceAll(" ", "%20");
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                FileUtil.delete(subFile);
            }
        }
        if (!file.delete()) {
            Output.print("^error^ could not delete file ^b^%s^r^", file.getPath());
        }
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ioe) {
            Output.print("^error^ Could not get the canonical path of file %s", file.getPath());
            throw new RuntimeException(ioe);
        }
    }

    public static String stripFileUriPrefix(String path) {
        if (path == null) {
            return path;
        }
        if (path.startsWith("file://")) {
            return path.substring(7);
        }
        if (path.startsWith("file:/")) {
            return path.substring(6);
        }
        if (path.startsWith("file:")) {
            return path.substring(5);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSha1Hash(File file) {
        InputStream fileInputStream = null;
        try {
            MessageDigest hash = MessageDigest.getInstance("SHA1");
            fileInputStream = new BufferedInputStream(new FileInputStream(file));
            DigestInputStream digestInputStream = new DigestInputStream(fileInputStream, hash);
            byte[] buffer = new byte[8192];
            while (digestInputStream.read(buffer, 0, buffer.length) != -1) {
            }
            byte[] sha1 = hash.digest();
            String string = BitUtil.toHexString(sha1);
            return string;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AssertionError((Object)nsae);
        }
        catch (FileNotFoundException fnfe) {
            throw new AssertionError((Object)fnfe);
        }
        catch (IOException ioe) {
            Output.print(ioe);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
        }
        throw new AssertionError();
    }

    private FileUtil() {
    }
}

