/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.jna;

public final class JnaUtil {
    private static final String JNA_CLASS_NAME = "com.sun.jna.Library";
    private static final boolean jnaPresent;
    private static final Os os;

    public static boolean isJnaPresent() {
        return jnaPresent;
    }

    public static Os getOperatingSystem() {
        return os;
    }

    private JnaUtil() {
    }

    static {
        ClassLoader loader = JnaUtil.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        boolean jnaPresentLocal = false;
        if (loader != null) {
            try {
                loader.loadClass(JNA_CLASS_NAME);
                jnaPresentLocal = true;
            }
            catch (ClassNotFoundException cnfe) {
                jnaPresentLocal = false;
            }
        }
        jnaPresent = jnaPresentLocal;
        String osName = System.getProperty("os.name");
        String string = osName = osName == null ? "linux" : osName.toLowerCase();
        os = osName.contains("linux") || osName.contains("hp-ux") ? Os.Linux : (osName.contains("mac") || osName.contains("darwin") ? Os.OSX : (osName.contains("bsd") ? Os.BSD : (osName.contains("solaris") || osName.contains("sunos") ? Os.Solaris : (osName.contains("openvms") ? Os.OpenVMS : (osName.contains("os/2") ? Os.OS2 : (osName.contains("windows") ? Os.Windows : Os.Linux))))));
    }

    public static enum Os {
        Linux,
        OSX,
        BSD,
        Solaris,
        OpenVMS,
        OS2,
        Windows;


        public boolean isUnix() {
            return this == Linux || this == OSX || this == BSD || this == Solaris;
        }
    }
}

