/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.dep.RepositoryAtom;
import net.ocheyedan.ply.input.Resources;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.script.print.PrivilegedOutput;
import net.ocheyedan.ply.script.print.PrivilegedPrintStream;

public class JunitTester {
    public static void main(String[] args) {
        PropFile.Prop buildDirProp = Props.get((String)"build.dir", (Context)Context.named((String)"project"));
        PropFile.Prop artifactNameProp = Props.get((String)"artifact.name", (Context)Context.named((String)"project"));
        if (PropFile.Prop.Empty.equals((Object)buildDirProp) || PropFile.Prop.Empty.equals((Object)artifactNameProp)) {
            Output.print((String)"^warn^ No project.build.dir or project.artifact.name found, skipping test execution.", (Object[])new Object[0]);
            return;
        }
        PropFile resolvedDepProps = Deps.getResolvedProperties((boolean)true);
        if (resolvedDepProps == null) {
            Output.print((String)"^warn^ No resolved-deps.properties file found, skipping test execution.", (Object[])new Object[0]);
            return;
        }
        File artifact = FileUtil.fromParts((String[])new String[]{buildDirProp.value(), artifactNameProp.value()});
        if (!artifact.exists()) {
            Output.print((String)"^warn^ No test artifact, skipping test execution.", (Object[])new Object[0]);
            return;
        }
        List<URL> urls = JunitTester.getClasspathEntries(artifact, resolvedDepProps);
        URLClassLoader loader = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]), null);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        };
        Set<String> classNames = JunitTester.getClasses(artifact, filter);
        Set<Class> classes = JunitTester.loadClasses(classNames, loader);
        Output.print((String)"^dbug^ Loaded %d classes from test artifact.", (Object[])new Object[]{classes.size()});
        String[] matchers = null;
        String unsplitMatchers = null;
        if (args.length == 1) {
            unsplitMatchers = args[0];
            matchers = args[0].split(",");
        }
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        try {
            PropFile.Prop reportDirProp = Props.get((String)"reports.dir", (Context)Context.named((String)"project"));
            if (PropFile.Prop.Empty.equals((Object)reportDirProp)) {
                Output.print((String)"^warn^ Could not find property project.reports.dir, skipping out/err redirection.", (Object[])new Object[0]);
            } else {
                File outFile = FileUtil.fromParts((String[])new String[]{reportDirProp.value(), "tests-out.txt"});
                outFile.getParentFile().mkdirs();
                outFile.createNewFile();
                File errFile = FileUtil.fromParts((String[])new String[]{reportDirProp.value(), "tests-err.txt"});
                errFile.createNewFile();
                System.setOut(new PrivilegedPrintStream(oldOut, outFile));
                System.setErr(new PrivilegedPrintStream(oldErr, errFile));
            }
        }
        catch (IOException ioe) {
            PrivilegedOutput.print(ioe);
            System.exit(1);
        }
        try {
            Resources.setResourcesLoader((ClassLoader)loader);
            Class<?> junit4Invoker = loader.loadClass("net.ocheyedan.ply.script.Junit4Invoker");
            Runnable instance = (Runnable)junit4Invoker.getConstructor(Set.class, String[].class, String.class).newInstance(classes, matchers, unsplitMatchers);
            Thread runner = new Thread(instance);
            runner.setContextClassLoader(loader);
            runner.setName("Junit4Runner");
            runner.start();
            runner.join();
        }
        catch (ClassNotFoundException cfne) {
            PrivilegedOutput.print(cfne);
            System.exit(1);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError((Object)nsme);
        }
        catch (InstantiationException ie) {
            PrivilegedOutput.print(ie.getCause());
            System.exit(1);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError((Object)iae);
        }
        catch (InvocationTargetException ite) {
            PrivilegedOutput.print(ite.getCause());
            System.exit(1);
        }
        catch (InterruptedException ie) {
            PrivilegedOutput.print(ie);
            System.exit(1);
        }
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        for (Thread thread : threads) {
            if (thread == Thread.currentThread() || "main".equals(thread.getName()) || thread.isDaemon()) continue;
            PrivilegedOutput.print("^warn^ Found a non-daemon thread [ ^b^%s^r^ ] created within a unit-test which has not be halted; consider fixing this. Forcing halt for now.", thread.getName());
            System.exit(0);
        }
    }

    private static List<URL> getClasspathEntries(File artifact, PropFile dependencies) {
        URL plyJunitTester;
        ArrayList<URL> urls = new ArrayList<URL>();
        URL artifactUrl = JunitTester.getUrl(artifact);
        if (artifactUrl == null) {
            throw new AssertionError((Object)String.format("Could not find artifact: %s", artifact.getPath()));
        }
        urls.add(artifactUrl);
        if (dependencies == null) {
            return urls;
        }
        boolean includesPlyUtil = false;
        for (PropFile.Prop depName : dependencies.props()) {
            String depPath = depName.value();
            URL depUrl = JunitTester.getUrl(new File(depPath));
            if (depUrl == null) {
                throw new AssertionError((Object)String.format("Could not find dependency artifact: %s", depPath));
            }
            urls.add(depUrl);
            if (!depName.name.contains("ply-util")) continue;
            includesPlyUtil = true;
        }
        PropFile.Prop localRepoProp = Props.get((String)"localRepo", (Context)Context.named((String)"depmngr"));
        RepositoryAtom localRepo = RepositoryAtom.parse((String)localRepoProp.value());
        if (localRepo == null) {
            if (PropFile.Prop.Empty.equals((Object)localRepoProp)) {
                Output.print((String)"^error^ No ^b^localRepo^r^ property defined (^b^ply set localRepo=xxxx in depmngr^r^).", (Object[])new Object[0]);
            } else {
                Output.print((String)"^error^ Could not resolve directory for ^b^localRepo^r^ property [ is ^b^%s^r^ ].", (Object[])new Object[]{localRepoProp.value()});
            }
            System.exit(1);
        }
        if (!includesPlyUtil) {
            URL plyUtil = JunitTester.getUrl(FileUtil.fromParts((String[])new String[]{PlyUtil.INSTALL_DIRECTORY, "lib", "ply-util-1.0.jar"}));
            if (plyUtil == null) {
                throw new AssertionError((Object)"Could not find ^b^ply-util-1.0.jar^r^ in the installation lib directory.");
            }
            urls.add(plyUtil);
        }
        if ((plyJunitTester = JunitTester.getUrl(FileUtil.fromParts((String[])new String[]{PlyUtil.INSTALL_DIRECTORY, "scripts", "ply-test-junit-1.0.jar"}))) == null) {
            throw new AssertionError((Object)"Could not find ^b^ply-test-junit-1.0.jar^r^ in the installation scripts directory.");
        }
        urls.add(plyJunitTester);
        URL hamcrest = JunitTester.getUrl(FileUtil.fromParts((String[])new String[]{PlyUtil.INSTALL_DIRECTORY, "repo", "org.hamcrest", "hamcrest-core", "1.1", "hamcrest-core-1.1.jar"}));
        if (hamcrest == null) {
            throw new AssertionError((Object)"Could not find ^b^hamcrest-core-1.1.jar^r^ in local repository.");
        }
        urls.add(hamcrest);
        URL commonsLang = JunitTester.getUrl(FileUtil.fromParts((String[])new String[]{PlyUtil.INSTALL_DIRECTORY, "repo", "commons-lang", "commons-lang", "2.6", "commons-lang-2.6.jar"}));
        if (commonsLang == null) {
            throw new AssertionError((Object)"Could not find ^b^commons-lang-2.6.jar^r^ in local repository.");
        }
        urls.add(commonsLang);
        URL junit = JunitTester.getUrl(FileUtil.fromParts((String[])new String[]{PlyUtil.INSTALL_DIRECTORY, "repo", "junit", "junit", "4.10", "junit-4.10.jar"}));
        if (junit == null) {
            throw new AssertionError((Object)"Could not find ^b^junit-4.10.jar^r^ in local repository.");
        }
        urls.add(junit);
        return urls;
    }

    private static URL getUrl(File artifact) {
        URL artifactUrl;
        try {
            try {
                artifactUrl = new URL("file://" + artifact.getCanonicalPath());
            }
            catch (IOException ioe) {
                String path = artifact.getPath();
                path = FileUtil.stripFileUriPrefix((String)path);
                artifactUrl = new URL("file://" + path);
            }
        }
        catch (MalformedURLException murle) {
            Output.print((Throwable)murle);
            return null;
        }
        catch (IOException ioe) {
            Output.print((Throwable)ioe);
            return null;
        }
        return artifactUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getClasses(File artifact, FilenameFilter filter) {
        HashSet<String> classes = new HashSet<String>();
        ZipInputStream inputStream = null;
        try {
            inputStream = new JarInputStream(new FileInputStream(artifact));
            JarEntry entry = ((JarInputStream)inputStream).getNextJarEntry();
            while (entry != null) {
                if (filter.accept(null, entry.getName())) {
                    String javaClassName = entry.getName().substring(0, entry.getName().length() - 6);
                    javaClassName = javaClassName.replaceAll("/", ".");
                    classes.add(javaClassName);
                }
                entry = ((JarInputStream)inputStream).getNextJarEntry();
            }
        }
        catch (IOException ioe) {
            Output.print((Throwable)ioe);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    throw new AssertionError((Object)ioe);
                }
            }
        }
        return classes;
    }

    private static Set<Class> loadClasses(Set<String> classNames, ClassLoader loader) {
        HashSet<Class> classes = new HashSet<Class>(classNames.size());
        for (String className : classNames) {
            try {
                Class<?> clazz = Class.forName(className, true, loader);
                classes.add(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                Output.print((Throwable)cnfe);
            }
        }
        return classes;
    }
}

