/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.script.AllFilterCollectPad;
import net.ocheyedan.ply.script.print.PrivilegedOutput;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class Junit4RunListener
extends RunListener {
    private final Map<Description, Failure> failures = new HashMap<Description, Failure>();
    private final Map<String, Integer> methodNameOffsets = new HashMap<String, Integer>();
    private final AllFilterCollectPad padding;
    private final List<String> potentialStatements;
    private final List<String> failureStatements;
    private final String successChar = PlyUtil.isUnicodeSupported() ? "\u2713" : "";
    private final String failureChar = PlyUtil.isUnicodeSupported() ? "\u2620" : "";
    private final String ignoredChar = PlyUtil.isUnicodeSupported() ? "\u26a0" : "";

    public Junit4RunListener() {
        this(null);
    }

    public Junit4RunListener(AllFilterCollectPad padding) {
        this.padding = padding;
        this.potentialStatements = new LinkedList<String>();
        this.failureStatements = new LinkedList<String>();
    }

    public void printFailures() {
        for (String failureStatement : this.failureStatements) {
            System.out.println(failureStatement);
        }
    }

    public void testRunStarted(Description description) throws Exception {
        if (!Junit4RunListener.isSyntheticDescription(description)) {
            int size = description.getChildren().size();
            PrivilegedOutput.print("\nRunning tests from ^b^%d^r^ class%s\n", size, size != 1 ? "es" : "");
        }
    }

    public void testStarted(Description description) throws Exception {
        if (Junit4RunListener.isSyntheticDescription(description)) {
            return;
        }
        this.handleNewDescription(description);
        String statement = String.format("%s^no_line^\t^b^%s^r^ ", "^priv^", description.getMethodName());
        this.potentialStatements.add(statement);
        System.out.println(statement);
    }

    public void testFinished(Description description) throws Exception {
        if (Junit4RunListener.isSyntheticDescription(description)) {
            return;
        }
        if (this.failures.containsKey(description)) {
            Failure failure = this.failures.get(description);
            String message = Junit4RunListener.createEasilyIdentifiableDiffMessage(failure, failure.getMessage());
            String statement = String.format("%s^no_prefix^%s^red^^i^ %s FAILURE %s ^r^ %s", "^priv^", this.getPad(description), this.failureChar, this.failureChar, message);
            String descriptionStatement = this.getDescriptionPrintStatement(description);
            if (!this.failureStatements.contains(descriptionStatement)) {
                this.failureStatements.add(descriptionStatement);
            }
            this.failureStatements.addAll(this.potentialStatements);
            this.failureStatements.add(statement);
            System.out.println(statement);
        } else {
            System.out.println(String.format("%s^no_prefix^%s^green^^i^ %s SUCCESS %s ^r^", "^priv^", this.getPad(description), this.successChar, this.successChar));
        }
        this.potentialStatements.clear();
    }

    public void testFailure(Failure failure) throws Exception {
        if (Junit4RunListener.isSyntheticDescription(failure.getDescription())) {
            return;
        }
        this.failures.put(failure.getDescription(), failure);
    }

    public void testIgnored(Description description) throws Exception {
        if (Junit4RunListener.isSyntheticDescription(description)) {
            return;
        }
        this.handleNewDescription(description);
        System.out.println(String.format("%s^no_line^\t^b^%s^r^ ", "^priv^", description.getMethodName()));
        System.out.println(String.format("%s^no_prefix^%s^yellow^^i^ %s IGNORED %s ^r^", "^priv^", this.getPad(description), this.ignoredChar, this.ignoredChar));
    }

    public static boolean isSyntheticDescription(Description description) {
        return description.getClassName().startsWith("org.junit") || description.getClassName().startsWith("junit") || "initializationError".equals(description.getMethodName());
    }

    private void handleNewDescription(Description description) {
        if (!this.methodNameOffsets.containsKey(description.getClassName())) {
            this.methodNameOffsets.put(description.getClassName(), 0);
            PrivilegedOutput.print("^b^%s^r^", description.getClassName());
        }
    }

    private String getDescriptionPrintStatement(Description description) {
        return String.format("%s^b^%s^r^", "^priv^", description.getClassName());
    }

    private String getPad(Description description) {
        if (this.padding == null) {
            return "";
        }
        int pad = this.padding.getMaxMethodNameLength() - description.getMethodName().length();
        StringBuilder buffer = new StringBuilder(pad);
        for (int i = 0; i < pad; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    private static String createEasilyIdentifiableDiffMessage(Failure failure, String message) {
        Integer lineNumber = null;
        for (StackTraceElement stackTraceElement : failure.getException().getStackTrace()) {
            if (!stackTraceElement.getClassName().equals(failure.getDescription().getClassName())) continue;
            lineNumber = stackTraceElement.getLineNumber();
            break;
        }
        if (lineNumber != null) {
            if (message != null) {
                return String.format("@ ^b^line %d^r^ [ %s ]", lineNumber, message);
            }
            return String.format("@ ^b^line %d^r^", lineNumber);
        }
        if (message != null) {
            return String.format("[ %s ]", message);
        }
        return "";
    }
}

