/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.util.regex.Pattern;
import net.ocheyedan.ply.AntStyleWildcardUtil;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class DescriptionMatcher
extends Filter {
    private final String match;
    private final Pattern classOnlyPattern;
    private final Pattern pattern;

    public DescriptionMatcher(String match) {
        String regex = this.match = match.replaceAll("\\.", "/");
        String prefix = "";
        String suffix = "";
        if (!regex.contains("/") && !regex.startsWith("**")) {
            prefix = ".*?/";
        }
        String packageClassOnly = regex;
        if (!regex.contains("#")) {
            suffix = "#.*";
        } else {
            packageClassOnly = regex.substring(0, regex.indexOf("#"));
        }
        regex = AntStyleWildcardUtil.regexString((String)regex);
        packageClassOnly = AntStyleWildcardUtil.regexString((String)packageClassOnly);
        this.pattern = Pattern.compile(prefix + regex + suffix);
        this.classOnlyPattern = Pattern.compile(prefix + packageClassOnly);
    }

    public boolean shouldRun(Description description) {
        if (description.getMethodName() == null) {
            String toMatch = description.getClassName();
            if (!this.classOnlyPattern.matcher(toMatch = toMatch.replaceAll("\\.", "/")).matches()) {
                return false;
            }
            for (Description child : description.getChildren()) {
                String fullMatch = toMatch + "#" + child.getMethodName();
                if (!this.pattern.matcher(fullMatch).matches()) continue;
                return true;
            }
            return false;
        }
        String toMatch = description.getClassName() + "#" + description.getMethodName();
        toMatch = toMatch.replaceAll("\\.", "/");
        return this.pattern.matcher(toMatch).matches();
    }

    public String describe() {
        return this.match;
    }
}

