/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.jna.JnaAccessor;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.script.PackagingScript;
import net.ocheyedan.ply.script.ZipFiles;

public class ZipPackageScript
implements PackagingScript {
    private static final FilenameFilter DIRECTORY_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return FileUtil.fromParts((String[])new String[]{dir.getPath(), name}).isDirectory();
        }
    };

    @Override
    public void invoke() throws IOException, InterruptedException {
        String processStdoutLine;
        Process process;
        String buildPath = Props.get((String)"build.path", (Context)Context.named((String)"compiler")).value();
        String resBuildPath = Props.get((String)"res.build.dir", (Context)Context.named((String)"project")).value();
        File buildPathDir = new File(buildPath);
        File resBuildPathDir = new File(resBuildPath);
        if (!buildPathDir.exists() && !resBuildPathDir.exists()) {
            Output.print((String)"Nothing to package, skipping.", (Object[])new Object[0]);
            System.exit(0);
        }
        this.preprocess();
        Object[] cmdArgs = this.createArgs(this.getType(), null, this.getIncludes(buildPath, resBuildPath));
        Output.print((String)"^dbug^ Creating package with arguments: %s", (Object[])new Object[]{Arrays.toString(cmdArgs)});
        ProcessBuilder processBuilder = new ProcessBuilder((String[])cmdArgs).redirectErrorStream(true);
        try {
            process = processBuilder.start();
        }
        catch (IOException ioe) {
            Output.print((String)"^error^ Error creating %s file %s", (Object[])new Object[]{this.getType(), Arrays.toString(cmdArgs)});
            throw ioe;
        }
        InputStream processStdout = process.getInputStream();
        BufferedReader lineReader = new BufferedReader(new InputStreamReader(processStdout));
        while ((processStdoutLine = lineReader.readLine()) != null) {
            System.out.println(processStdoutLine);
        }
        int result = process.waitFor();
        if (result != 0) {
            System.exit(result);
        } else {
            result = this.postprocess(result);
        }
        System.exit(result);
    }

    protected String getType() {
        return "zip";
    }

    protected void preprocess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int postprocess(int exitCode) throws IOException, InterruptedException {
        exitCode |= this.packageSources();
        if (ZipPackageScript.getBoolean(Props.get((String)"includeDeps", (Context)Context.named((String)"package")).value())) {
            PropFile deps = Deps.getResolvedProperties((boolean)false);
            if (deps.isEmpty()) {
                return exitCode;
            }
            String packaging = this.getType();
            int numberDeps = deps.size();
            Output.print((String)"^info^ Including ^b^%d^r^ dependenc%s in ^b^%s^r^ package.", (Object[])new Object[]{numberDeps, numberDeps == 1 ? "y" : "ies", packaging});
            String name = this.getPackageName(packaging, null);
            String nameWithDeps = this.getPackageName(packaging, "with-deps");
            File nameWithDepsFile = new File(nameWithDeps);
            ZipOutputStream output = null;
            try {
                nameWithDepsFile.createNewFile();
                HashSet<String> existing = new HashSet<String>();
                output = new ZipOutputStream(new FileOutputStream(nameWithDepsFile));
                ZipFiles.append(new ZipInputStream(new FileInputStream(name)), output, existing);
                for (PropFile.Prop dep : deps.props()) {
                    if (DependencyAtom.isTransient((String)dep.name)) continue;
                    String depFile = dep.value();
                    ZipFiles.append(new ZipInputStream(new FileInputStream(depFile)), output, existing);
                }
                output.close();
            }
            catch (FileNotFoundException fnfe) {
                throw new AssertionError((Object)fnfe);
            }
            catch (IOException ioe) {
                Output.print((Throwable)ioe);
                int n = 1;
                return n;
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException ioe) {
                        throw new AssertionError((Object)ioe);
                    }
                }
            }
        }
        return exitCode;
    }

    protected int packageSources() throws IOException, InterruptedException {
        if (ZipPackageScript.getBoolean(Props.get((String)"includeSrc", (Context)Context.named((String)"package")).value())) {
            String processStdoutLine;
            Process process;
            Context projectContext = Context.named((String)"project");
            String srcDirPath = Props.get((String)"src.dir", (Context)projectContext).value();
            String resDirPath = Props.get((String)"res.dir", (Context)projectContext).value();
            Object[] cmdArgs = this.createArgs(this.getType(), "sources", this.getIncludes(srcDirPath, resDirPath));
            Output.print((String)"^dbug^ Creating source package with arguments: %s", (Object[])new Object[]{Arrays.toString(cmdArgs)});
            ProcessBuilder processBuilder = new ProcessBuilder((String[])cmdArgs).redirectErrorStream(true);
            try {
                process = processBuilder.start();
            }
            catch (IOException ioe) {
                Output.print((String)"^error^ Error creating %s file %s", (Object[])new Object[]{this.getType(), Arrays.toString(cmdArgs)});
                throw ioe;
            }
            InputStream processStdout = process.getInputStream();
            BufferedReader lineReader = new BufferedReader(new InputStreamReader(processStdout));
            while ((processStdoutLine = lineReader.readLine()) != null) {
                System.out.println(processStdoutLine);
            }
            return process.waitFor();
        }
        return 0;
    }

    protected String[] getIncludes(String compileDir, String resourceDir) {
        File compileDirFile = new File(compileDir);
        File resourceDirFile = new File(resourceDir);
        if (compileDirFile.exists() && resourceDirFile.exists()) {
            if (ZipPackageScript.subdirectoriesIntersect(compileDirFile, resourceDirFile)) {
                return ZipPackageScript.getIntersectedDirectories(compileDirFile, compileDir, resourceDirFile);
            }
            return new String[]{"-C", compileDir, ".", "-C", resourceDir, "."};
        }
        if (compileDirFile.exists()) {
            return new String[]{"-C", compileDir, "."};
        }
        if (resourceDirFile.exists()) {
            return new String[]{"-C", resourceDir, "."};
        }
        return new String[0];
    }

    protected String getBaseOptions() {
        return "cfM";
    }

    protected String[] createArgs(String packaging, String packagingNameSuffix, String[] includes) {
        String jarScript = Props.get((String)"java", (Context)Context.named((String)"ply")).value().replace("bin" + File.separator + "java", "bin" + File.separator + "jar");
        String options = this.getBaseOptions();
        if (ZipPackageScript.getBoolean(Props.get((String)"verbose", (Context)Context.named((String)"package")).value())) {
            options = options + "v";
        }
        if (!ZipPackageScript.getBoolean(Props.get((String)"compress", (Context)Context.named((String)"package")).value())) {
            options = options + "0";
        }
        String name = this.getPackageName(packaging, packagingNameSuffix);
        String[] args = new String[includes.length + 3];
        args[0] = jarScript;
        args[1] = options;
        args[2] = name;
        System.arraycopy(includes, 0, args, 3, includes.length);
        return args;
    }

    protected String getPackageName(String packaging, String suffix) {
        String name = Props.get((String)"name", (Context)Context.named((String)"package")).value();
        if (name.isEmpty()) {
            Output.print((String)"^warn^ Property 'package.name' was empty, defaulting to value of ${project.artifact.name}.", (Object[])new Object[0]);
            name = Props.get((String)"artifact.name", (Context)Context.named((String)"project")).value();
            if (name.isEmpty()) {
                Output.print((String)"^warn^ Property 'project.artifact.name' was empty, defaulting to value of ${project.name}.", (Object[])new Object[0]);
                name = Props.get((String)"name", (Context)Context.named((String)"project")).value();
                if (name.isEmpty()) {
                    Output.print((String)"^warn^ Property 'project.name' was empty, defaulting to 'no-name'.", (Object[])new Object[0]);
                    name = "no-name";
                }
            }
            name = name + "." + packaging;
        }
        if (suffix != null && !suffix.isEmpty()) {
            name = name.lastIndexOf(".") != -1 ? name.substring(0, name.lastIndexOf(".")) + "-" + suffix + name.substring(name.lastIndexOf(".")) : name + "-" + suffix;
        }
        return ZipPackageScript.getPackageFilePath(name);
    }

    static String getPackageFilePath(String name) {
        String buildDirPath = Props.get((String)"build.dir", (Context)Context.named((String)"project")).value();
        return FileUtil.pathFromParts((String[])new String[]{buildDirPath, name});
    }

    static boolean getBoolean(String value) {
        return "true".equalsIgnoreCase(value);
    }

    static boolean subdirectoriesIntersect(File first, File second) {
        Object[] firstSubfileNames = first.list(DIRECTORY_FILTER);
        Object[] secondSubfileNames = second.list(DIRECTORY_FILTER);
        Arrays.sort(firstSubfileNames);
        Arrays.sort(secondSubfileNames);
        for (Object firstSubfileName : firstSubfileNames) {
            if (Arrays.binarySearch(secondSubfileNames, firstSubfileName) < 0) continue;
            return true;
        }
        return false;
    }

    static String[] getIntersectedDirectories(File first, String firstPath, File second) {
        ZipPackageScript.linkIntersectedDirectories(first, second);
        return new String[]{"-C", firstPath, "."};
    }

    private static void linkIntersectedDirectories(File to, File from) {
        for (File secondFile : from.listFiles()) {
            File firstFile = FileUtil.fromParts((String[])new String[]{to.getPath(), secondFile.getName()});
            if (firstFile.exists()) {
                if (secondFile.isDirectory()) {
                    ZipPackageScript.linkIntersectedDirectories(firstFile, secondFile);
                    continue;
                }
                Output.print((String)"^warn^ Found a duplicate entry [ ^b^%s^r^ ], skipping inclusion of ^i^^yellow^%s^r^.", (Object[])new Object[]{firstFile.getPath(), secondFile.getPath()});
                continue;
            }
            if (JnaAccessor.getCUnixLibrary() != null) {
                JnaAccessor.getCUnixLibrary().symlink(secondFile.getAbsolutePath(), firstFile.getAbsolutePath());
                continue;
            }
            FileUtil.copy((File)secondFile, (File)firstFile);
        }
    }
}

