/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.ocheyedan.ply.Output;

public final class ZipFiles {
    public static void append(ZipInputStream zip, ZipOutputStream intoZip, Set<String> existing) throws IOException {
        ZipEntry entry;
        if (zip == null || intoZip == null) {
            return;
        }
        HashSet<String> duplicateWarnings = new HashSet<String>();
        byte[] buf = new byte[1024];
        while ((entry = zip.getNextEntry()) != null) {
            int len;
            String entryName = entry.getName();
            if (!existing.add(entryName)) {
                if (!duplicateWarnings.add(entryName) || entry.isDirectory() || "META-INF/MANIFEST.MF".equals(entryName) || entryName == null || entryName.startsWith("META-INF/ply/dependencies.")) continue;
                Output.print((String)"^warn^ Duplicate entry ^b^%s^r^ skipped.", (Object[])new Object[]{entryName});
                continue;
            }
            intoZip.putNextEntry(entry);
            while ((len = zip.read(buf)) > 0) {
                intoZip.write(buf, 0, len);
            }
            intoZip.closeEntry();
        }
        zip.close();
    }

    private ZipFiles() {
    }
}

