/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;
import net.ocheyedan.ply.script.ZipPackageScript;

public class JarPackageScript
extends ZipPackageScript {
    @Override
    protected String getType() {
        return "jar";
    }

    @Override
    protected void preprocess() {
        this.createManifestFile();
        String buildDir = this.getBuildDir();
        String artifactsScopeName = Props.get((String)"artifacts.label", (Context)Context.named((String)"project")).value();
        Scope artifactsScope = Scope.named((String)artifactsScopeName);
        File dependenciesFile = JarPackageScript.createDependenciesFile(artifactsScope, buildDir);
        if (dependenciesFile == null) {
            Output.print((String)"^error^ Error creating the %sMETA-INF/ply/dependencies%s.properties file.", (Object[])new Object[]{buildDir, artifactsScope.getFileSuffix()});
            System.exit(1);
        }
    }

    @Override
    protected String[] getIncludes(String compileDir, String resourceDir) {
        String[] standardArgs = super.getIncludes(compileDir, resourceDir);
        String manifestFile = JarPackageScript.getManifestFilePath();
        String buildDir = this.getBuildDir();
        String[] jarIncludes = new String[standardArgs.length + 4];
        jarIncludes[0] = manifestFile;
        jarIncludes[1] = "-C";
        jarIncludes[2] = buildDir;
        jarIncludes[3] = "META-INF/ply";
        System.arraycopy(standardArgs, 0, jarIncludes, 4, standardArgs.length);
        return jarIncludes;
    }

    @Override
    protected String getBaseOptions() {
        return "cfm";
    }

    protected String getBuildDir() {
        String buildDir = Props.get((String)"build.dir", (Context)Context.named((String)"project")).value();
        return buildDir + (buildDir.endsWith(File.separator) ? "" : File.separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createManifestFile() {
        Map<String, PropFile.Prop> manifestProps = JarPackageScript.getManifestProps();
        Context packageContext = Context.named((String)"package");
        String version = Props.get((String)"manifest.version", (Context)packageContext).value();
        manifestProps.remove("manifest.version");
        if (version.isEmpty()) {
            version = "1.0";
        }
        String createdBy = Props.get((String)"manfiest.createdBy", (Context)packageContext).value();
        manifestProps.remove("manfiest.createdBy");
        if (createdBy.isEmpty()) {
            createdBy = "Ply";
        }
        String mainClass = Props.get((String)"manifest.mainClass", (Context)packageContext).value();
        manifestProps.remove("manifest.mainClass");
        String classPath = Props.get((String)"manifest.classPath", (Context)packageContext).value();
        manifestProps.remove("manifest.classPath");
        String specTitle = Props.get((String)"manifest.spec.title", (Context)packageContext).value();
        manifestProps.remove("manifest.spec.title");
        String specVersion = Props.get((String)"manifest.spec.version", (Context)packageContext).value();
        manifestProps.remove("manifest.spec.version");
        String implTitle = Props.get((String)"manifest.impl.title", (Context)packageContext).value();
        manifestProps.remove("manifest.impl.title");
        String implVersion = Props.get((String)"manifest.impl.version", (Context)packageContext).value();
        manifestProps.remove("manifest.impl.version");
        StringBuilder buffer = new StringBuilder();
        JarPackageScript.appendManifestInformation("Manifest-Version", version, buffer);
        JarPackageScript.appendManifestInformation("Created-By", createdBy, buffer);
        JarPackageScript.appendManifestInformation("Main-Class", mainClass, buffer);
        JarPackageScript.appendManifestInformation("Class-Path", classPath, buffer);
        JarPackageScript.appendManifestInformation("Specification-Title", specTitle, buffer);
        JarPackageScript.appendManifestInformation("Specification-Version", specVersion, buffer);
        JarPackageScript.appendManifestInformation("Implementation-Title", implTitle, buffer);
        JarPackageScript.appendManifestInformation("Implementation-Version", implVersion, buffer);
        for (String property : manifestProps.keySet()) {
            JarPackageScript.appendManifestInformation(property, manifestProps.get(property).value(), buffer);
        }
        File manifestFile = new File(JarPackageScript.getManifestFilePath());
        PrintWriter writer = null;
        try {
            manifestFile.getParentFile().mkdirs();
            manifestFile.createNewFile();
            writer = new PrintWriter(manifestFile);
            writer.println(buffer.toString());
            writer.flush();
        }
        catch (IOException ioe) {
            Output.print((Throwable)ioe);
            ioe.printStackTrace();
            System.exit(1);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static void appendManifestInformation(String name, String value, StringBuilder buffer) {
        if (!value.isEmpty()) {
            buffer.append(name);
            buffer.append(": ");
            buffer.append(value);
            buffer.append('\n');
        }
    }

    protected static Map<String, PropFile.Prop> getManifestProps() {
        PropFileChain packageProps = Props.get((Context)Context.named((String)"package"));
        HashMap<String, PropFile.Prop> manifestProps = new HashMap<String, PropFile.Prop>();
        for (PropFile.Prop prop : packageProps.props()) {
            if (!prop.name.startsWith("manifest.")) continue;
            manifestProps.put(prop.name, prop);
        }
        return manifestProps;
    }

    protected static String getManifestFilePath() {
        String buildDirPath = Props.get((String)"build.dir", (Context)Context.named((String)"project")).value();
        File metaInfDir = FileUtil.fromParts((String[])new String[]{buildDirPath, "META-INF"});
        metaInfDir.mkdirs();
        return FileUtil.pathFromParts((String[])new String[]{metaInfDir.getPath(), "Manifest.mf"});
    }

    private static File createDependenciesFile(Scope artifactsScope, String buildDirPath) {
        PropFile dependencies = new PropFile(Context.named((String)"dependencies"), PropFile.Loc.System);
        PropFile resolvedDeps = Deps.getResolvedProperties((boolean)false);
        for (PropFile.Prop resolvedDep : resolvedDeps.props()) {
            dependencies.add(resolvedDep.name, "");
        }
        File metaInfPlyDepFile = FileUtil.fromParts((String[])new String[]{buildDirPath, "META-INF", "ply", String.format("dependencies%s.properties", artifactsScope.getFileSuffix())});
        PropFiles.store((PropFile)dependencies, (String)metaInfPlyDepFile.getPath(), (boolean)true);
        return metaInfPlyDepFile;
    }
}

