/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;
import net.ocheyedan.ply.script.CompilableFiles;

public class FileChangeDetector {
    public static void main(String[] args) {
        boolean computeSha1Hash = false;
        if (args != null && args.length > 0 && "--compute-hash".equals(args[0])) {
            computeSha1Hash = true;
        }
        Scope scope = Scope.named((String)Props.get((String)"scope", (Context)Context.named((String)"ply")).value());
        String srcDirPath = Props.get((String)"src.dir", (Context)Context.named((String)"project")).value();
        String buildDirPath = Props.get((String)"build.dir", (Context)Context.named((String)"project")).value();
        File lastSrcChanged = FileUtil.fromParts((String[])new String[]{buildDirPath, "changed-meta" + scope.getFileSuffix() + ".properties"});
        File changedPropertiesFile = FileUtil.fromParts((String[])new String[]{buildDirPath, "changed" + scope.getFileSuffix() + ".properties"});
        File filesToCompilePropertiesFile = FileUtil.fromParts((String[])new String[]{buildDirPath, "files-to-compile" + scope.getFileSuffix() + ".properties"});
        File srcDir = new File(srcDirPath);
        PropFile existing = PropFiles.load((String)lastSrcChanged.getPath(), (boolean)true, (boolean)false);
        try {
            changedPropertiesFile.createNewFile();
        }
        catch (IOException ioe) {
            Output.print((Throwable)ioe);
        }
        PropFile changedList = FileChangeDetector.computeFilesChanged(lastSrcChanged, changedPropertiesFile, srcDir, existing, scope, computeSha1Hash);
        PropFile filesToCompile = new CompilableFiles().compute(changedList, scope, srcDirPath, buildDirPath);
        PropFiles.store((PropFile)filesToCompile, (String)filesToCompilePropertiesFile.getPath(), (boolean)true);
        if (Scope.Default.equals((Object)scope)) {
            File compiledSinceTest = FileUtil.fromParts((String[])new String[]{buildDirPath, "default-scope-compiled.properties"});
            PropFile compiledSinceTestProps = PropFiles.load((String)compiledSinceTest.getAbsolutePath(), (boolean)false, (boolean)false);
            for (PropFile.Prop prop : filesToCompile.props()) {
                compiledSinceTestProps.add(prop.name, srcDirPath);
            }
            PropFiles.store((PropFile)compiledSinceTestProps, (String)compiledSinceTest.getAbsolutePath(), (boolean)true);
        }
    }

    private static PropFile computeFilesChanged(File lastSrcChanged, File changedPropertiesFile, File srcDir, PropFile existing, Scope scope, boolean computeSha1Hash) {
        PropFile changedList = new PropFile(Context.named((String)"changed"), PropFile.Loc.Local);
        PropFile properties = new PropFile(Context.named((String)"changed-meta"), PropFile.Loc.Local);
        FileChangeDetector.collectAllFileChanges(srcDir, changedList, properties, existing, scope, computeSha1Hash);
        PropFiles.store((PropFile)changedList, (String)changedPropertiesFile.getPath());
        PropFiles.store((PropFile)properties, (String)lastSrcChanged.getPath());
        return changedList;
    }

    private static void collectAllFileChanges(File from, PropFile changedList, PropFile into, PropFile existing, Scope scope, boolean computeSha1Hash) {
        File[] subfiles = from.listFiles();
        if (subfiles == null) {
            return;
        }
        for (File file : subfiles) {
            if (file.isDirectory()) {
                FileChangeDetector.collectAllFileChanges(file, changedList, into, existing, scope, computeSha1Hash);
                continue;
            }
            try {
                AtomicReference<String> sha1HashRef = new AtomicReference<String>();
                String path = file.getCanonicalPath();
                if (FileChangeDetector.hasChanged(file, existing, sha1HashRef, scope, computeSha1Hash) && file.exists()) {
                    String timeFileLastChanged = String.valueOf(file.lastModified());
                    String sha1Hash = computeSha1Hash ? (sha1HashRef.get() == null ? FileUtil.getSha1Hash((File)file) : sha1HashRef.get()) : "not-computed";
                    into.add(path, timeFileLastChanged + "," + sha1Hash);
                    changedList.add(path, "");
                    continue;
                }
                if (!file.exists()) continue;
                into.add(path, existing.get(path).value());
            }
            catch (IOException ioe) {
                Output.print((Throwable)ioe);
            }
        }
    }

    private static boolean hasChanged(File file, PropFile existing, AtomicReference<String> computedSha1, Scope scope, boolean computeSha1Hash) {
        try {
            String propertyValue = existing.get(file.getCanonicalPath()).value();
            if (propertyValue.isEmpty()) {
                return true;
            }
            String[] split = propertyValue.split("\\,");
            if (split.length != 2) {
                Output.print((String)"^warn^ corrupted changed-meta%s.properties file, recomputing.", (Object[])new Object[]{scope.getFileSuffix()});
                return true;
            }
            long timestamp = Long.valueOf(split[0]);
            if (file.lastModified() == timestamp) {
                return false;
            }
            if (computeSha1Hash) {
                String oldHashAsHex = split[1];
                String asHex = FileUtil.getSha1Hash((File)file);
                computedSha1.set(asHex);
                return !asHex.equals(oldHashAsHex);
            }
            computedSha1.set("not-computed");
            return true;
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        catch (NumberFormatException nfe) {
            Output.print((String)"^warn^ corrupted changed-meta%s.properties file, recomputing.", (Object[])new Object[]{scope.getFileSuffix()});
            return true;
        }
    }
}

