/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.util.Set;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.dep.ClassDeps;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

class CompilableFiles {
    CompilableFiles() {
    }

    public PropFile compute(PropFile changedFiles, Scope scope, String srcDirPath, String buildDirPath) {
        File changedDepsFile;
        String classDepsPath = Props.get((String)"class.deps", (Context)Context.named((String)"compiler")).value();
        File classDepsDirectory = new File(classDepsPath);
        if (!classDepsDirectory.exists()) {
            this.addExistingErrors(buildDirPath, scope, changedFiles);
            return changedFiles;
        }
        Context inconsequential = Context.named((String)"compile");
        PropFile needingCompiling = new PropFile(inconsequential, PropFile.Loc.AdHoc);
        for (PropFile.Prop prop : changedFiles.props()) {
            needingCompiling.add(prop.name, "");
            int index = prop.name.indexOf(srcDirPath);
            String name = prop.name.substring(index + srcDirPath.length());
            String fileName = name.replace(File.separatorChar, '.').replace(".java", ".properties");
            this.addDependentClasses(classDepsDirectory, fileName, srcDirPath, needingCompiling);
        }
        if (!Scope.Default.equals((Object)scope) && "test".equals(scope.name)) {
            File compiledSinceTest = FileUtil.fromParts((String[])new String[]{buildDirPath, "default-scope-compiled.properties"});
            PropFile compiledSinceTestProps = PropFiles.load((String)compiledSinceTest.getAbsolutePath(), (boolean)false, (boolean)false);
            for (PropFile.Prop compiledSinceTestProp : compiledSinceTestProps.props()) {
                String defaultSrcDirPath = compiledSinceTestProp.value();
                int index = compiledSinceTestProp.name.indexOf(defaultSrcDirPath);
                String name = compiledSinceTestProp.name.substring(index + defaultSrcDirPath.length());
                String fileName = name.replace(File.separatorChar, '.').replace(".java", ".properties");
                this.addDependentClasses(classDepsDirectory, fileName, srcDirPath, needingCompiling);
            }
        }
        if ((changedDepsFile = FileUtil.fromParts((String[])new String[]{buildDirPath, "changed-deps" + scope.getFileSuffix() + ".properties"})).exists()) {
            PropFile changedDeps = PropFiles.load((String)changedDepsFile.getPath(), (boolean)false, (boolean)false);
            for (PropFile.Prop changedDep : changedDeps.props()) {
                String jarFile = changedDep.value();
                ClassDeps classDeps = new ClassDeps();
                Set classesWithinJar = classDeps.getClasses(jarFile);
                for (String classWithinJar : classesWithinJar) {
                    this.addDependentClasses(classDepsDirectory, classWithinJar, srcDirPath, needingCompiling);
                }
            }
        }
        this.addExistingErrors(buildDirPath, scope, needingCompiling);
        return needingCompiling;
    }

    private void addDependentClasses(File classDepsDirectory, String fileName, String srcDirPath, PropFile propFile) {
        File classDep;
        if (fileName.startsWith(".") || fileName.startsWith(File.separator)) {
            fileName = fileName.substring(1);
        }
        if (!(classDep = FileUtil.fromParts((String[])new String[]{classDepsDirectory.getAbsolutePath(), fileName})).exists()) {
            return;
        }
        PropFile dependentClasses = PropFiles.load((String)classDep.getPath(), (boolean)false, (boolean)false);
        for (PropFile.Prop dependentClass : dependentClasses.props()) {
            propFile.add(this.getSourceFile(dependentClass, srcDirPath), "");
        }
    }

    private String getSourceFile(PropFile.Prop dependentClass, String sourceDir) {
        File dependentClassSourcePath = dependentClass.name.contains("$") ? FileUtil.fromParts((String[])new String[]{sourceDir, dependentClass.name.substring(0, dependentClass.name.indexOf(36)).replace('.', File.separatorChar) + ".java"}) : FileUtil.fromParts((String[])new String[]{sourceDir, dependentClass.name.replace('.', File.separatorChar) + ".java"});
        return dependentClassSourcePath.getAbsolutePath();
    }

    private void addExistingErrors(String buildDir, Scope scope, PropFile into) {
        File existingErrors = FileUtil.fromParts((String[])new String[]{buildDir, "compiler-errors" + scope.getFileSuffix() + ".properties"});
        if (!existingErrors.exists()) {
            return;
        }
        PropFile errors = PropFiles.load((String)existingErrors.getPath(), (boolean)false, (boolean)false);
        for (PropFile.Prop error : errors.props()) {
            into.add(error.name, "");
        }
    }
}

