/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.ocheyedan.ply.AntStyleWildcardUtil;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Filter;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.Props;

public final class FilterScript {
    public static void main(String[] args) {
        PropFileChain filterFiles;
        PropFile.Prop filterDirProp = Props.get((String)"filter.dir", (Context)Context.named((String)"project"));
        if (PropFile.Prop.Empty.equals((Object)filterDirProp)) {
            Output.print((String)"^error^ Could not find project.filter.dir property.", (Object[])new Object[0]);
            System.exit(1);
        }
        if ((filterFiles = Props.get((Context)Context.named((String)"filter-files"))) == null || !filterFiles.props().iterator().hasNext()) {
            Output.print((String)"^dbug^ No filter sets specified, nothing to filter.", (Object[])new Object[0]);
            return;
        }
        File filterDir = new File(filterDirProp.value());
        ArrayList<FilterPattern> filterPatterns = new ArrayList<FilterPattern>();
        for (PropFile.Prop filterProp : filterFiles.props()) {
            String filterExp = filterProp.name;
            if (!filterExp.startsWith("**")) {
                filterExp = FileUtil.pathFromParts((String[])new String[]{filterDir.getPath(), filterExp});
            }
            Pattern filterPattern = AntStyleWildcardUtil.regex((String)filterExp);
            boolean include = false;
            if ("include".equalsIgnoreCase(filterProp.value()) || filterProp.value().isEmpty()) {
                include = true;
            }
            filterPatterns.add(new FilterPattern(filterPattern, include));
        }
        HashSet<File> files = new HashSet<File>();
        FilterScript.getApplicableFiles(filterPatterns, filterDir, files);
        if (files.isEmpty()) {
            Output.print((String)"^dbug^ No files matched the filter set.", (Object[])new Object[0]);
            return;
        }
        for (File file : files) {
            Output.print((String)"^info^ Filtering file %s.", (Object[])new Object[]{file.getPath()});
            FilterScript.filter(file);
        }
    }

    private static void getApplicableFiles(List<FilterPattern> filterPatterns, File dir, Set<File> collecting) {
        if (dir.isDirectory()) {
            File[] subfiles = dir.listFiles(new CollectingFileFilter(filterPatterns, collecting));
            Collections.addAll(collecting, subfiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filter(File file) {
        AbstractInterruptibleChannel fc = null;
        try {
            RandomAccessFile stream = new RandomAccessFile(file, "rw");
            fc = stream.getChannel();
            MappedByteBuffer mappedByteBuffer = ((FileChannel)fc).map(FileChannel.MapMode.READ_WRITE, 0L, ((FileChannel)fc).size());
            String text = Charset.defaultCharset().decode(mappedByteBuffer).toString();
            text = Filter.filter((String)text, (Context)Context.named((String)"ply"), (String)String.valueOf(System.identityHashCode(file)), (Map)Props.get());
            ((FileChannel)fc).position(0L);
            ByteBuffer filtered = ByteBuffer.wrap(text.getBytes());
            long currentSize = ((FileChannel)fc).size();
            long newSize = filtered.capacity();
            while (filtered.hasRemaining()) {
                ((FileChannel)fc).write(filtered);
            }
            if (newSize < currentSize) {
                ((FileChannel)fc).truncate(newSize);
            }
        }
        catch (IOException ioe) {
            Output.print((Throwable)ioe);
            System.exit(1);
        }
        finally {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException ioe) {
                    throw new AssertionError((Object)ioe);
                }
            }
        }
    }

    private static final class CollectingFileFilter
    implements FileFilter {
        private final List<FilterPattern> filterPatterns;
        private final Set<File> collecting;

        private CollectingFileFilter(List<FilterPattern> filterPatterns, Set<File> collecting) {
            this.filterPatterns = filterPatterns;
            this.collecting = collecting;
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                FilterScript.getApplicableFiles(this.filterPatterns, pathname, this.collecting);
                return false;
            }
            for (FilterPattern filterPattern : this.filterPatterns) {
                if (!filterPattern.accept(pathname)) continue;
                return filterPattern.include;
            }
            return false;
        }
    }

    private static final class FilterPattern
    implements FileFilter {
        private final Pattern pattern;
        private final boolean include;

        private FilterPattern(Pattern pattern, boolean include) {
            this.pattern = pattern;
            this.include = include;
        }

        @Override
        public boolean accept(File pathname) {
            return this.pattern.matcher(pathname.getPath()).matches();
        }
    }
}

