/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.UUID;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.PwdUtil;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.dep.Auth;
import net.ocheyedan.ply.dep.Repos;
import net.ocheyedan.ply.dep.RepositoryAtom;
import net.ocheyedan.ply.input.InterruptibleInputReader;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;
import net.ocheyedan.ply.script.github.Authorization;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import sun.misc.BASE64Encoder;

public final class RepoManager {
    private static final String GIT_HUB_API_NAME = "GitHub API";
    private static final String GIT_HUB_SCOPE = "repo";

    public static void main(String[] args) {
        Scope scope = Scope.named((String)Props.get((String)"scope", (Context)Context.named((String)"ply")).value());
        if (args.length > 1 && "add".equals(args[0])) {
            RepoManager.addRepository(args[1], scope);
        } else if (args.length > 1 && "rm".equals(args[0])) {
            RepoManager.removeRepository(args[1], scope);
        } else if (args.length == 4 && "auth".equals(args[0])) {
            RepoManager.authRepository(args[1], args[2], args[3], scope, false);
        } else if (args.length == 4 && "auth-local".equals(args[0])) {
            RepoManager.authRepository(args[1], args[2], args[3], scope, true);
        } else {
            RepoManager.usage();
            System.exit(1);
        }
    }

    private static void addRepository(String repository, Scope scope) {
        RepositoryAtom atom = RepositoryAtom.parse((String)repository);
        if (atom == null) {
            Output.print((String)"^error^ Repository %s not of format [type:]repoUri.", (Object[])new Object[]{repository});
            System.exit(1);
        }
        try {
            atom.repositoryUri.toURL();
        }
        catch (Exception e) {
            Output.print((String)"^error^ Given value ^b^%s^r^ is not a valid URI and so is not a repository.", (Object[])new Object[]{atom.getPropertyName()});
            System.exit(1);
        }
        PropFile repositories = RepoManager.load("repositories", scope, true);
        if (repositories.contains(atom.getPropertyName())) {
            Output.print((String)"^info^ overriding repository %s; was %s now is %s.", (Object[])new Object[]{atom.getPropertyName(), repositories.get(atom.getPropertyName()).value(), atom.getPropertyValue()});
            repositories.remove(atom.getPropertyName());
        }
        repositories.add(atom.getPreResolvedUri(), atom.getPropertyValue());
        RepoManager.store("repositories", repositories, scope, true);
        Output.print((String)"Added repository %s%s", (Object[])new Object[]{atom.toString(), !Scope.Default.equals((Object)scope) ? String.format(" (in scope %s)", scope.getPrettyPrint()) : ""});
    }

    private static void removeRepository(String repository, Scope scope) {
        RepositoryAtom atom = null;
        try {
            atom = Repos.getExistingRepo((File)PlyUtil.LOCAL_CONFIG_DIR, (Scope)scope, (String)repository);
            if (atom == null) {
                return;
            }
        }
        catch (SystemExit se) {
            System.exit(se.exitCode);
        }
        PropFile repositories = RepoManager.load("repositories", scope, true);
        PropFile.Prop removed = repositories.remove(atom.getPreResolvedUri());
        RepoManager.store("repositories", repositories, scope, true);
        atom = RepositoryAtom.parse((String)String.format("%s:%s", removed.value(), removed.name));
        Output.print((String)"Removed repository %s%s", (Object[])new Object[]{atom.toString(), !Scope.Default.equals((Object)scope) ? String.format(" (in scope %s)", scope.getPrettyPrint()) : ""});
    }

    private static void authRepository(String repository, String authTypeName, String username, Scope scope, boolean local) {
        Repos.AuthType authType = null;
        try {
            authType = Repos.AuthType.valueOf((String)authTypeName);
        }
        catch (Exception e) {
            Output.print((String)"^error^ Auth-type ^b^%s^r^ not supported; only ^b^%s^r^ is supported.", (Object[])new Object[]{authTypeName, Repos.AuthType.git.name()});
            System.exit(1);
        }
        if (local) {
            try {
                RepositoryAtom atom = Repos.getExistingRepo((File)PlyUtil.LOCAL_CONFIG_DIR, (Scope)scope, (String)repository);
                if (atom == null) {
                    RepoManager.addRepository(repository, scope);
                    Output.print((String)"^warn^ Added repository ^b^%s^r^ automatically.", (Object[])new Object[]{repository});
                    Output.print((String)"^warn^   if this was a mistake, revert via command: ^b^ply repo rm %s^r^", (Object[])new Object[]{repository});
                }
            }
            catch (SystemExit se) {
                System.exit(se.exitCode);
            }
        }
        String password = RepoManager.getVerifiedPassword(username);
        String encrypted = PwdUtil.encrypt((String)password);
        PropFile repomngr = RepoManager.load("repomngr", scope, local);
        File configDir = new File(RepoManager.getConfigDirPath(local));
        Auth auth = authType.get(username, encrypted, RepositoryAtom.parse((String)repository), configDir, scope);
        final Repos.AuthType type = authType;
        Output.print((String)"Verifying authorization...", (Object[])new Object[0]);
        auth.acquireAccess(new Auth.Acquisition(){

            public String getAccess(String username, String encryptedPwd) {
                switch (type) {
                    case git: {
                        return RepoManager.getGitHubAuthToken(username, encryptedPwd);
                    }
                    case basic: {
                        return RepoManager.getBasicAuth(username, encryptedPwd);
                    }
                }
                throw new AssertionError();
            }
        });
        Repos.addAuthRepomngrProp((PropFile)repomngr, (String)repository, (Auth)auth);
        RepoManager.store("repomngr", repomngr, scope, local);
        Output.print((String)"Associated username/password with repository within ^b^repomngr^r^ context.", (Object[])new Object[0]);
    }

    private static String getBasicAuth(String username, String encryptedPwd) {
        return PwdUtil.decrypt((String)encryptedPwd);
    }

    private static String getGitHubAuthToken(String username, String encryptedPwd) {
        String existing = RepoManager.getExistingGitHubAuthToken(username, encryptedPwd);
        if (existing != null) {
            return existing;
        }
        String url = "https://api.github.com/authorizations";
        Authorization authorization = RepoManager.post(url, username, encryptedPwd, RepoManager.createGitHubAuthorizationPostData(), Authorization.class);
        return authorization == null ? null : authorization.getToken();
    }

    private static String getExistingGitHubAuthToken(String username, String encryptedPwd) {
        String authorizationsUrl = "https://api.github.com/authorizations";
        Authorization[] authorizations = RepoManager.get(authorizationsUrl, username, encryptedPwd, Authorization[].class);
        if (authorizations == null || authorizations.length < 1) {
            return null;
        }
        for (Authorization authorization : authorizations) {
            if (authorization == null || authorization.getApp() == null || !GIT_HUB_API_NAME.equals(authorization.getApp().getName()) || authorization.getToken() == null || authorization.getToken().isEmpty() || authorization.getScopes() == null || authorization.getScopes().length < 1) continue;
            for (String scope : authorization.getScopes()) {
                if (!GIT_HUB_SCOPE.equals(scope)) continue;
                return authorization.getToken();
            }
        }
        return null;
    }

    private static String createGitHubAuthorizationPostData() {
        return String.format("{\"note\":\"%s\", \"fingerprint\": \"%s\", \"scopes\":[\"repo\"]}", RepoManager.createGitHubNote(), RepoManager.createGitHubFingerPrint());
    }

    private static String createGitHubNote() {
        return String.format("Ply %s @ %d", PlyUtil.getIPAddress(), System.currentTimeMillis());
    }

    private static String createGitHubFingerPrint() {
        return UUID.randomUUID().toString();
    }

    private static <T> T post(String urlPath, String username, String encryptedPwd, String data, Class<T> clazz) {
        URLConnection urlConnection = null;
        try {
            URL url = URI.create(urlPath).toURL();
            urlConnection = url.openConnection();
            String pwd = PwdUtil.decrypt((String)encryptedPwd);
            String urlEncodedUsername = URLEncoder.encode(username, "UTF-8");
            String urlEncodedPwd = URLEncoder.encode(pwd, "UTF-8");
            String userpass = String.format("%s:%s", urlEncodedUsername, urlEncodedPwd);
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedUserpass = encoder.encode(userpass.getBytes());
            String basicAuth = "Basic " + encodedUserpass;
            urlConnection.setRequestProperty("Authorization", basicAuth);
            urlConnection.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(urlConnection.getOutputStream());
            writer.write(data);
            writer.flush();
            InputStream stream = urlConnection.getInputStream();
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
            return (T)objectMapper.readValue(stream, clazz);
        }
        catch (IOException ioe) {
            Output.print((Throwable)ioe);
            if (urlConnection != null) {
                try {
                    InputStream stream = ((HttpURLConnection)urlConnection).getErrorStream();
                    ObjectMapper objectMapper = new ObjectMapper();
                    objectMapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
                    HashMap map = (HashMap)objectMapper.readValue(stream, HashMap.class);
                    String response = map.toString();
                    Output.print((String)"^error^ Response:", (Object[])new Object[0]);
                    Output.print((String)"^error^   %s", (Object[])new Object[]{response});
                }
                catch (IOException inputIoe) {
                    Output.print((Throwable)inputIoe);
                }
            }
            return null;
        }
    }

    private static <T> T get(String urlPath, String username, String encryptedPwd, Class<T> clazz) {
        try {
            URL url = URI.create(urlPath).toURL();
            URLConnection urlConnection = url.openConnection();
            String pwd = PwdUtil.decrypt((String)encryptedPwd);
            String userpass = username + ":" + pwd;
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedUserpass = encoder.encode(userpass.getBytes());
            String basicAuth = "Basic " + encodedUserpass;
            urlConnection.setRequestProperty("Authorization", basicAuth);
            InputStream stream = urlConnection.getInputStream();
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
            return (T)objectMapper.readValue(stream, clazz);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private static String getVerifiedPassword(String username) {
        Output.print((String)"%s^no_line^Enter password for %s: ", (Object[])new Object[]{"^password^", username});
        String pwd = RepoManager.getPassword();
        Output.print((String)"%s^no_line^Reenter to verify: ", (Object[])new Object[]{"^password^", username});
        String reentered = RepoManager.getPassword();
        if (!pwd.equals(reentered)) {
            Output.print((String)"^error^ Passwords did not match, please retry.", (Object[])new Object[0]);
            return RepoManager.getVerifiedPassword(username);
        }
        return pwd;
    }

    private static String getPassword() {
        String answer;
        InterruptibleInputReader reader = new InterruptibleInputReader(System.in);
        try {
            answer = reader.readLine();
        }
        catch (IOException ioe) {
            Output.print((String)"%s^no_line^^error^ When entering password, please retry: ", (Object[])new Object[]{"^password^"});
            return RepoManager.getPassword();
        }
        if (answer == null || answer.isEmpty()) {
            Output.print((String)"%s^no_line^^error^ Password may not be blank, please retry: ", (Object[])new Object[]{"^password^"});
            return RepoManager.getPassword();
        }
        return answer;
    }

    private static PropFile load(String name, Scope scope, boolean local) {
        String path = RepoManager.getPath(name, scope, local);
        return PropFiles.load((String)path, (boolean)true, (boolean)false);
    }

    private static void store(String name, PropFile props, Scope scope, boolean local) {
        String path = RepoManager.getPath(name, scope, local);
        if (!PropFiles.store((PropFile)props, (String)path, (boolean)true)) {
            System.exit(1);
        }
    }

    private static String getConfigDirPath(boolean local) {
        if (local) {
            String localDir = Props.get((String)"project.dir", (Context)Context.named((String)"ply")).value();
            return FileUtil.pathFromParts((String[])new String[]{localDir, "config"});
        }
        String systemDir = System.getProperty("ply.home");
        return FileUtil.pathFromParts((String[])new String[]{systemDir, "config"});
    }

    private static String getPath(String name, Scope scope, boolean local) {
        String configDirPath = RepoManager.getConfigDirPath(local);
        return FileUtil.pathFromParts((String[])new String[]{configDirPath, name + scope.getFileSuffix() + ".properties"});
    }

    private static void usage() {
        Output.print((String)"repo <^b^command^r^>", (Object[])new Object[0]);
        Output.print((String)"  where ^b^command^r^ is either:", (Object[])new Object[0]);
        Output.print((String)"    ^b^add <repo-atom>^r^ : adds repo-atom to the list of repositories.", (Object[])new Object[0]);
        Output.print((String)"    ^b^rm <repo-atom>^r^ : removes repo-atom from the list of repositories.", (Object[])new Object[0]);
        Output.print((String)"    ^b^auth <repo-atom> <auth-type> <username>^r^ : adds authentication information for repo-atom (prompting for password).", (Object[])new Object[0]);
        Output.print((String)"    ^b^auth-local <repo-atom> <auth-type> <username>^r^ : same as auth but stores the information within the project configuration.", (Object[])new Object[0]);
        Output.print((String)"  ^b^repo-atom^r^ is [type:]repoURI (type is optional and defaults to ply, must be either ply or maven).", (Object[])new Object[0]);
        Output.print((String)"  ^b^auth-type^r^ must be 'git' or 'basic' ('basic' is http/https basic authentication)", (Object[])new Object[0]);
        Output.print((String)"  Repositories can be grouped by ^b^scope^r^ (i.e. test).  The default scope is null.", (Object[])new Object[0]);
    }
}

