/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.Props;

public class PrintClasspathScript {
    public static void main(String[] args) {
        String buildDir = Props.get((String)"build.dir", (Context)Context.named((String)"project")).value();
        DependencyAtom dependencyAtom = Deps.getProjectDep();
        String artifactName = dependencyAtom.getArtifactName();
        File artifactFile = FileUtil.fromParts((String[])new String[]{buildDir, artifactName});
        if (!artifactFile.exists()) {
            Output.print((String)"Packaged artifact [ %s ] not found, run `ply compile package` first.", (Object[])new Object[]{artifactName});
            System.exit(1);
        }
        String classpath = PrintClasspathScript.createClasspath(artifactFile.getPath(), Deps.getResolvedProperties((boolean)false));
        Output.print((String)classpath, (Object[])new Object[0]);
    }

    private static String createClasspath(String artifact, PropFile dependencies) {
        StringBuilder buffer = new StringBuilder(artifact);
        for (PropFile.Prop dependency : dependencies.props()) {
            buffer.append(File.pathSeparator);
            buffer.append(dependency.value());
        }
        return buffer.toString();
    }
}

