/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import com.sun.source.util.Trees;
import com.sun.tools.javac.tree.JCTree;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.script.DependencyGraphVisitor;

@SupportedAnnotationTypes(value={"*"})
public class DependencyGraphProcessor
extends AbstractProcessor {
    private Trees trees;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.trees = Trees.instance(env);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            Set<? extends Element> elements = roundEnv.getRootElements();
            for (Element element : elements) {
                if (element.getKind() != ElementKind.CLASS) continue;
                Output.print((String)"Looking at type %s", (Object[])new Object[]{element.getSimpleName()});
                JCTree tree = (JCTree)this.trees.getTree(element);
                DependencyGraphVisitor visitor = new DependencyGraphVisitor();
                tree.accept(visitor);
            }
        }
        return false;
    }
}

