/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.dep.ClassDeps;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PrefixedProps;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;
import net.ocheyedan.ply.script.FormattedDiagnosticListener;

public class CompilerScript {
    private final Scope scope;
    private final String srcDir;
    private final Set<String> sourceFilePaths;
    private final File errorsPropertiesFile;
    private final File changedDepsFile;
    private final File defaultScopedCompiledFile;
    private final AtomicReference<String> compilationVerb;

    public static void main(String[] args) {
        CompilerScript script = new CompilerScript();
        script.invoke();
    }

    private static boolean isSupportedJavaVersion(String version) {
        if (CompilerScript.isEmpty(version)) {
            return false;
        }
        try {
            Float javaVersion = Float.valueOf(version);
            if (javaVersion.floatValue() < 1.6f) {
                Output.print((String)"^error^ only JDK 1.6+ is supported for compilation [ running %f ].", (Object[])new Object[]{javaVersion});
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            throw new AssertionError((Object)nfe);
        }
        catch (NullPointerException npe) {
            throw new AssertionError((Object)npe);
        }
        return true;
    }

    private static String getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.length() > 2 && version.charAt(1) == '.') {
            version = version.substring(0, 3);
        }
        return version;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private static boolean getBoolean(String value) {
        return value != null && value.equalsIgnoreCase("true");
    }

    private CompilerScript() {
        if (!CompilerScript.isSupportedJavaVersion(CompilerScript.getJavaVersion())) {
            System.exit(1);
        }
        this.scope = Scope.named((String)Props.get((String)"scope", (Context)Context.named((String)"ply")).value());
        String srcDir = Props.get((String)"src.dir", (Context)Context.named((String)"project")).value();
        String buildDir = Props.get((String)"build.dir", (Context)Context.named((String)"project")).value();
        if (srcDir.isEmpty() || buildDir.isEmpty()) {
            Output.print((String)"^error^ could not determine source or build directory for compilation.", (Object[])new Object[0]);
            System.exit(1);
        }
        this.srcDir = srcDir;
        this.sourceFilePaths = new HashSet<String>();
        Context compilerContext = Context.named((String)"compiler");
        String buildClassesPath = Props.get((String)"build.path", (Context)compilerContext).value();
        File buildClassesDir = new File(buildClassesPath);
        buildClassesDir.mkdirs();
        String generatedSrcPath = Props.get((String)"generated.src.path", (Context)compilerContext).value();
        File generatedSrcDir = new File(generatedSrcPath);
        generatedSrcDir.mkdirs();
        File filesToCompilePropertiesFile = FileUtil.fromParts((String[])new String[]{buildDir, "files-to-compile" + this.scope.getFileSuffix() + ".properties"});
        PropFile changedProperties = PropFiles.load((String)filesToCompilePropertiesFile.getPath(), (boolean)false, (boolean)false);
        if (changedProperties == PropFile.Empty) {
            Output.print((String)"^error^ files-to-compile%s.properties not found, please run 'file-changed' before 'compiler'.", (Object[])new Object[]{this.scope.getFileSuffix()});
        } else {
            for (PropFile.Prop filePath : changedProperties.props()) {
                if (!filePath.name.endsWith(".java")) continue;
                this.sourceFilePaths.add(filePath.name);
            }
        }
        this.errorsPropertiesFile = FileUtil.fromParts((String[])new String[]{buildDir, "compiler-errors" + this.scope.getFileSuffix() + ".properties"});
        this.changedDepsFile = FileUtil.fromParts((String[])new String[]{buildDir, "changed-deps" + this.scope.getFileSuffix() + ".properties"});
        this.defaultScopedCompiledFile = FileUtil.fromParts((String[])new String[]{buildDir, "default-scope-compiled.properties"});
        this.compilationVerb = new AtomicReference<String>("Compiling");
    }

    private void invoke() {
        String srcPath;
        this.cleanupClassFilesForDeletedSourceFiles();
        if (this.sourceFilePaths.isEmpty()) {
            if (this.handleExistingErrors()) {
                System.exit(1);
            } else {
                Output.print((String)"Nothing to compile, everything is up to date.", (Object[])new Object[0]);
                return;
            }
        }
        File sourceDir = new File(this.srcDir);
        try {
            srcPath = sourceDir.getCanonicalPath();
            if (!srcPath.endsWith(File.separator)) {
                srcPath = srcPath + File.separator;
            }
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        FormattedDiagnosticListener diagnosticListener = new FormattedDiagnosticListener(srcPath);
        JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = javac.getStandardFileManager(diagnosticListener, null, null);
        Iterable<? extends JavaFileObject> sourceFiles = fileManager.getJavaFileObjectsFromStrings(this.sourceFilePaths);
        StringWriter extraPrintStatements = new StringWriter();
        List<String> compilerArguments = this.getCompilerArgs();
        if (Output.isDebug()) {
            String arguments = CompilerScript.getPrettyPrint(compilerArguments);
            Output.print((String)"^dbug^ compiler arguments = %s", (Object[])new Object[]{arguments});
        }
        JavaCompiler.CompilationTask compilationTask = javac.getTask(extraPrintStatements, fileManager, diagnosticListener, compilerArguments, null, sourceFiles);
        Output.print((String)"%s ^b^%d^r^ %ssource file%s for ^b^%s^r^", (Object[])new Object[]{this.compilationVerb.get(), this.sourceFilePaths.size(), Scope.named((String)Props.get((String)"scope", (Context)Context.named((String)"ply")).value()).getPrettyPrint(), this.sourceFilePaths.size() == 1 ? "" : "s", Props.get((String)"name", (Context)Context.named((String)"project")).value()});
        boolean result = compilationTask.call();
        for (String notes : diagnosticListener.getNotes()) {
            Output.print((String)notes, (Object[])new Object[0]);
        }
        for (String warning : diagnosticListener.getWarnings()) {
            Output.print((String)warning, (Object[])new Object[0]);
        }
        for (String error : diagnosticListener.getErrors()) {
            Output.print((String)error, (Object[])new Object[0]);
        }
        if (extraPrintStatements.getBuffer().length() > 0) {
            Output.print((String)extraPrintStatements.toString(), (Object[])new Object[0]);
        }
        this.handleFilesWithError(diagnosticListener.getFileErrors(), this.errorsPropertiesFile);
        this.generateClassDependenciesForSuccessfullyCompiled();
        if (!result) {
            Context compileContext = Context.named((String)"compiler");
            String javaProcessor = Props.get((String)"java.processor", (Context)compileContext).value();
            if (!CompilerScript.isEmpty(javaProcessor)) {
                Output.print((String)"^warn^ Compilation failed when using annotation processor ^b^%s^r^. Ensure it is accessible [via service discovery or processorpath].", (Object[])new Object[]{javaProcessor});
            }
            System.exit(1);
        } else {
            if (this.changedDepsFile.exists()) {
                Output.print((String)"^dbug^ Deleting changed-deps file (^yellow^%s^r^) as compilation succeeded", (Object[])new Object[]{this.changedDepsFile.getAbsolutePath()});
                this.changedDepsFile.delete();
            }
            if (!Scope.Default.equals((Object)this.scope) && "test".equals(this.scope.name) && this.defaultScopedCompiledFile.exists()) {
                Output.print((String)"^dbug^ Deleting default-scope-compiled file (^yellow^%s^r^) as test-compilation succeeded", (Object[])new Object[]{this.defaultScopedCompiledFile.getAbsolutePath()});
                this.defaultScopedCompiledFile.delete();
            }
        }
    }

    private void handleFilesWithError(Map<String, Set<String>> errors, File errorsPropertiesFile) {
        if (errors.isEmpty()) {
            if (errorsPropertiesFile.exists()) {
                FileUtil.delete((File)errorsPropertiesFile);
            }
            return;
        }
        PropFile errorsProperties = new PropFile(Context.named((String)"errors"), PropFile.Loc.Local);
        Context compileContext = Context.named((String)"compiler");
        File buildPath = new File(Props.get((String)"build.path", (Context)compileContext).value());
        PropFile.Prop prop = Props.get((Context)Context.named((String)"compiler"), (Scope)this.scope).get("class.deps");
        String classDepsDirectory = prop.value();
        for (Map.Entry<String, Set<String>> entry : errors.entrySet()) {
            File classDepEntry;
            String failedFile = entry.getKey();
            StringBuilder buffer = new StringBuilder();
            for (String error : entry.getValue()) {
                if (buffer.length() > 0) {
                    buffer.append(" & ");
                }
                buffer.append(error);
            }
            errorsProperties.add(failedFile, buffer.toString());
            int index = failedFile.indexOf(this.srcDir);
            String classSuffix = failedFile.substring(index + this.srcDir.length()).replace(".java", ".class");
            File classFile = FileUtil.fromParts((String[])new String[]{buildPath.getAbsolutePath(), classSuffix});
            if (classFile.exists()) {
                Output.print((String)"^dbug^ Deleting existing class file (^yellow^%s^r^) for failed compilation unit", (Object[])new Object[]{classFile.getAbsolutePath()});
                classFile.delete();
            }
            if (!(classDepEntry = FileUtil.fromParts((String[])new String[]{classDepsDirectory, classSuffix.replace(File.separatorChar, '.').replace(".class", ".properties")})).exists()) continue;
            Output.print((String)"^dbug^ Deleting existing class-dependency file (^yellow^%s^r^) for failed compilation unit", (Object[])new Object[]{classDepEntry.getAbsolutePath()});
            classDepEntry.delete();
        }
        PropFiles.store((PropFile)errorsProperties, (String)errorsPropertiesFile.getPath(), (boolean)true);
    }

    private boolean handleExistingErrors() {
        PropFile errorsProperties = PropFiles.load((String)this.errorsPropertiesFile.getPath(), (boolean)false, (boolean)false);
        if (errorsProperties.isEmpty()) {
            return false;
        }
        for (PropFile.Prop error : errorsProperties.props()) {
            Output.print((String)error.name, (Object[])new Object[0]);
        }
        return true;
    }

    private List<String> getCompilerArgs() {
        String javaImplicit;
        String javaProcessor;
        String javaProcessingPath;
        ArrayList<String> args = new ArrayList<String>();
        Context compileContext = Context.named((String)"compiler");
        args.add("-d");
        args.add(Props.get((String)"build.path", (Context)compileContext).value());
        args.add("-s");
        args.add(Props.get((String)"generated.src.path", (Context)compileContext).value());
        if (CompilerScript.getBoolean(Props.get((String)"optimize", (Context)compileContext).value())) {
            args.add("-O");
        }
        if (CompilerScript.getBoolean(Props.get((String)"debug", (Context)compileContext).value())) {
            String javaDebugLevel = Props.get((String)"java.debugLevel", (Context)compileContext).value();
            if (!CompilerScript.isEmpty(javaDebugLevel)) {
                args.add("-g:" + javaDebugLevel);
            } else {
                args.add("-g");
            }
        } else {
            args.add("-g:none");
        }
        if (CompilerScript.getBoolean(Props.get((String)"verbose", (Context)compileContext).value())) {
            args.add("-verbose");
        }
        if (CompilerScript.getBoolean(Props.get((String)"java.deprecation", (Context)compileContext).value())) {
            args.add("-deprecation");
        }
        if (!CompilerScript.getBoolean(Props.get((String)"warnings", (Context)compileContext).value())) {
            args.add("-Xlint:none");
        } else if (!CompilerScript.isEmpty(Props.get((String)"java.warningsLevel", (Context)compileContext).value())) {
            String[] tokens;
            for (String token : tokens = Props.get((String)"java.warningsLevel", (Context)compileContext).value().split(" ")) {
                args.add("-Xlint:" + token.trim());
            }
        } else {
            args.add("-Xlint");
        }
        String javaProc = Props.get((String)"java.proc", (Context)compileContext).value();
        if (!CompilerScript.isEmpty(javaProc)) {
            if ("none".equals(javaProc)) {
                Output.print((String)"^dbug^ Ignoring all annotation processing.", (Object[])new Object[0]);
                args.add("-proc:none");
            } else if ("only".equals(javaProc)) {
                Output.print((String)"Option ^b^-proc:only^r^ specified, no source compilation will happen simply annotation processing.", (Object[])new Object[0]);
                this.compilationVerb.set("Annotation processing");
                args.add("-proc:only");
            } else {
                Output.print((String)"^warn^ Ignoring ^b^java.proc^r^ value ^yellow^%s^r^; expected either ^b^none^r^ or ^b^only^b^", (Object[])new Object[]{javaProc});
            }
        }
        if (!CompilerScript.isEmpty(javaProcessingPath = Props.get((String)"java.processorpath", (Context)compileContext).value())) {
            Output.print((String)"^dbug^ Explicitly specifying the annotation processing path as ^b^%s^r^", (Object[])new Object[]{javaProcessingPath});
            args.add("-processorpath");
            args.add(javaProcessingPath);
        }
        if (!CompilerScript.isEmpty(javaProcessor = Props.get((String)"java.processor", (Context)compileContext).value())) {
            Output.print((String)"^dbug^ Explicitly specifying the annotation processing classes as ^b^%s^r^", (Object[])new Object[]{javaProcessor});
            args.add("-processor");
            args.add(javaProcessor);
        }
        if (!CompilerScript.isEmpty(javaImplicit = Props.get((String)"java.implicit", (Context)compileContext).value())) {
            if ("none".equals(javaImplicit)) {
                args.add("-implicit:none");
            } else if ("class".equals(javaImplicit)) {
                args.add("-implicit:class");
            } else {
                Output.print((String)"^warn^ Ignoring ^b^java.implicit^r^ value ^yellow^%s^r^; expected either ^b^none^r^ or ^b^class^b^", (Object[])new Object[]{javaImplicit});
            }
        }
        List annotationKeys = PrefixedProps.getArguments((Context)compileContext, (String)"java.A", (String)"=");
        for (String annotationKey : annotationKeys) {
            args.add(String.format("-A%s", annotationKey));
        }
        args.add("-source");
        String javaSource = Props.get((String)"java.source", (Context)compileContext).value();
        if (CompilerScript.isSupportedJavaVersion(javaSource)) {
            args.add(javaSource);
        } else {
            args.add(CompilerScript.getJavaVersion());
        }
        args.add("-target");
        String javaTarget = Props.get((String)"java.target", (Context)compileContext).value();
        if (CompilerScript.isSupportedJavaVersion(javaTarget)) {
            args.add(javaTarget);
        } else {
            args.add(CompilerScript.getJavaVersion());
        }
        String javaEncoding = Props.get((String)"java.encoding", (Context)compileContext).value();
        if (!CompilerScript.isEmpty(javaEncoding)) {
            args.add("-encoding");
            args.add(javaEncoding);
        }
        List supplementalArgs = PrefixedProps.getArguments((Context)compileContext, (String)"args");
        for (String supplemental : supplementalArgs) {
            args.add(supplemental);
        }
        args.add("-classpath");
        args.add(CompilerScript.createClasspath(Props.get((String)"build.path", (Context)compileContext).value(), Deps.getResolvedProperties((boolean)false)));
        args.add("-sourcepath");
        args.add(this.srcDir);
        return args;
    }

    private void cleanupClassFilesForDeletedSourceFiles() {
        Context compileContext = Context.named((String)"compiler");
        File directory = new File(Props.get((String)"build.path", (Context)compileContext).value());
        if (!directory.exists()) {
            return;
        }
        PropFile.Prop prop = Props.get((Context)Context.named((String)"compiler"), (Scope)this.scope).get("class.deps");
        String classDepsDirectory = prop.value();
        this.cleanupDeletedFiles(directory, directory.getAbsolutePath(), classDepsDirectory);
    }

    private void generateClassDependenciesForSuccessfullyCompiled() {
        Context compileContext = Context.named((String)"compiler");
        File buildPath = new File(Props.get((String)"build.path", (Context)compileContext).value());
        HashSet<String> classes = new HashSet<String>();
        for (String srcFile : this.sourceFilePaths) {
            int index = srcFile.indexOf(this.srcDir);
            String sourceName = srcFile.substring(index + this.srcDir.length());
            File classFile = FileUtil.fromParts((String[])new String[]{buildPath.getAbsolutePath(), sourceName.replace(".java", ".class")});
            if (!classFile.exists()) continue;
            classes.add(classFile.getAbsolutePath());
        }
        ClassDeps classDeps = new ClassDeps();
        classDeps.processClassDependencies(buildPath.getAbsolutePath(), classes);
    }

    private void cleanupDeletedFiles(File directory, String buildDir, String classDepsDirectory) {
        File[] entries = directory.listFiles();
        if (entries == null) {
            return;
        }
        for (File entry : entries) {
            if (entry.isDirectory()) {
                this.cleanupDeletedFiles(entry, buildDir, classDepsDirectory);
                continue;
            }
            String className = entry.getAbsolutePath().substring(buildDir.length());
            String withoutBuildAsJava = className.replace(".class", ".java");
            if (withoutBuildAsJava.contains("$")) continue;
            File sourceFile = FileUtil.fromParts((String[])new String[]{this.srcDir, withoutBuildAsJava});
            if (sourceFile.exists()) continue;
            Output.print((String)"^dbug^ Deleting existing class file (^yellow^%s^r^) for removed source file", (Object[])new Object[]{entry.getAbsolutePath()});
            entry.delete();
            File classDepEntry = FileUtil.fromParts((String[])new String[]{classDepsDirectory, className.replace(File.separatorChar, '.').replace(".class", ".properties")});
            if (!classDepEntry.exists()) continue;
            Output.print((String)"^dbug^ Deleting existing class-dependency file (^yellow^%s^r^) for removed source file", (Object[])new Object[]{classDepEntry.getAbsolutePath()});
            classDepEntry.delete();
        }
    }

    private static List<String> getArguments(Context context, String propertyPrefix) {
        ArrayList<String> arguments = new ArrayList<String>(1);
        PropFileChain chain = Props.get((Context)context);
        for (PropFile.Prop prop : chain.props()) {
            if (!prop.name.startsWith(propertyPrefix) || prop.name.length() <= propertyPrefix.length()) continue;
            String keyName = prop.name.substring(6);
            String keyValue = prop.value();
            arguments.add(String.format("%s%s", keyName, CompilerScript.isEmpty(keyValue) ? "" : keyValue));
        }
        return arguments;
    }

    private static String getPrettyPrint(List<String> arguments) {
        StringBuilder buffer = new StringBuilder();
        for (String argument : arguments) {
            buffer.append(argument);
            buffer.append(" ");
        }
        return buffer.toString().trim();
    }

    private static String createClasspath(String localPath, PropFile dependencies) {
        StringBuilder buffer = new StringBuilder(localPath);
        for (PropFile.Prop dependency : dependencies.props()) {
            buffer.append(File.pathSeparator);
            buffer.append(dependency.value());
        }
        return buffer.toString();
    }
}

