/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.Props;

public class ExecScript {
    public static void main(String[] args) {
        PrintStream output;
        String[] execArgs = args.length != 0 ? args : ExecScript.getExecArgs();
        String java = Props.get((String)"java", (Context)Context.named((String)"ply")).value();
        String execJvmArgs = "";
        PropFile.Prop execJvmArgsProp = Props.get((String)"jvm.opts", (Context)Context.named((String)"exec"));
        if (!PropFile.Prop.Empty.equals((Object)execJvmArgsProp)) {
            execJvmArgs = execJvmArgsProp.value();
        }
        String[] jvmArgs = execJvmArgs.isEmpty() ? new String[]{} : execJvmArgs.split(" ");
        String[] javaArgs = new String[3 + jvmArgs.length + execArgs.length];
        javaArgs[0] = java;
        System.arraycopy(jvmArgs, 0, javaArgs, 1, jvmArgs.length);
        javaArgs[1 + jvmArgs.length] = "-cp";
        javaArgs[2 + jvmArgs.length] = ExecScript.getClasspath();
        System.arraycopy(execArgs, 0, javaArgs, 3 + jvmArgs.length, execArgs.length);
        ProcessBuilder processBuilder = new ProcessBuilder(javaArgs).redirectErrorStream(true);
        String outputFilePath = Props.get((String)"output", (Context)Context.named((String)"exec")).value();
        try {
            if (outputFilePath.isEmpty() || "stdout".equals(outputFilePath)) {
                output = System.out;
            } else {
                File outputFile = new File(outputFilePath);
                outputFile.createNewFile();
                output = new PrintStream(new FileOutputStream(outputFile));
            }
        }
        catch (IOException ioe) {
            Output.print((String)"^warn^ Could not access ^b^%s^r^ [ %s ], output is being directed to ^b^stdout^r^.", (Object[])new Object[]{outputFilePath, ioe.getMessage()});
            output = System.out;
        }
        try {
            String processStdoutLine;
            Output.print((String)"Executing ^b^%s^r^", (Object[])new Object[]{ExecScript.getExecCommand(javaArgs)});
            Process process = processBuilder.start();
            InputStream processStdout = process.getInputStream();
            BufferedReader lineReader = new BufferedReader(new InputStreamReader(processStdout));
            while ((processStdoutLine = lineReader.readLine()) != null) {
                output.println(processStdoutLine);
            }
            int result = process.waitFor();
            if (result != 0) {
                System.exit(result);
            }
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        catch (InterruptedException ie) {
            throw new AssertionError((Object)ie);
        }
    }

    private static String getExecCommand(String[] args) {
        StringBuilder buffer = new StringBuilder();
        for (String arg : args) {
            if (buffer.length() != 0) {
                buffer.append(' ');
            }
            buffer.append(arg);
        }
        return buffer.toString();
    }

    private static String[] getExecArgs() {
        String mainClass = Props.get((String)"class", (Context)Context.named((String)"exec")).value();
        if (mainClass.isEmpty()) {
            mainClass = Props.get((String)"manifest.mainClass", (Context)Context.named((String)"package")).value();
        }
        if (mainClass.isEmpty()) {
            Output.print((String)"^warn^ Project doesn't have a 'exec.class' or 'package.manifest.mainClass' property set, skipping execution.", (Object[])new Object[0]);
            System.exit(0);
        }
        PropFileChain execProps = Props.get((Context)Context.named((String)"exec"));
        HashMap<Integer, String> systemArgs = new HashMap<Integer, String>(2);
        HashMap<Integer, String> programArgs = new HashMap<Integer, String>(2);
        for (PropFile.Prop execProp : execProps.props()) {
            if (execProp.name.startsWith("systemArg")) {
                try {
                    int index = Integer.parseInt(execProp.name.substring(9));
                    if (systemArgs.containsKey(index)) {
                        Output.print((String)"^warn^ Two system arguments with the same index [ %s and %s ] using the second value.", (Object[])new Object[]{systemArgs.get(index), execProp.value()});
                    }
                    systemArgs.put(index, execProp.value());
                }
                catch (NumberFormatException nfe) {
                    Output.print((String)"^warn^ Ignoring an invalid system argument [ %s=%s ]. Example of a valid argument: systemArg0=value", (Object[])new Object[]{execProp.name, execProp.value()});
                }
                continue;
            }
            if (!execProp.name.startsWith("programArg")) continue;
            try {
                int index = Integer.parseInt(execProp.name.substring(10));
                if (programArgs.containsKey(index)) {
                    Output.print((String)"^warn^ Two program arguments with the same index [ %s and %s ] using the second value.", (Object[])new Object[]{programArgs.get(index), execProp.value()});
                }
                programArgs.put(index, execProp.value());
            }
            catch (NumberFormatException nfe) {
                Output.print((String)"^warn^ Ignoring an invalid program argument [ %s=%s ]. Example of a valid argument: programArg0=value", (Object[])new Object[]{execProp.name, execProp.value()});
            }
        }
        String[] execArgs = new String[1 + systemArgs.size() + programArgs.size()];
        int index = 0;
        ArrayList systemArgIndices = new ArrayList(systemArgs.keySet());
        Collections.sort(systemArgIndices);
        ArrayList programArgIndices = new ArrayList(programArgs.keySet());
        Collections.sort(programArgIndices);
        if (!systemArgs.isEmpty()) {
            for (Integer systemArgIndex : systemArgIndices) {
                execArgs[index++] = "-D" + (String)systemArgs.get(systemArgIndex);
            }
        }
        execArgs[index++] = mainClass;
        if (!programArgs.isEmpty()) {
            for (Integer programArgIndex : programArgIndices) {
                execArgs[index++] = (String)programArgs.get(programArgIndex);
            }
        }
        return execArgs;
    }

    private static String getClasspath() {
        String artifactName = Props.get((String)"name", (Context)Context.named((String)"package")).value();
        String buildDirPath = Props.get((String)"build.dir", (Context)Context.named((String)"project")).value();
        String artifactPath = FileUtil.pathFromParts((String[])new String[]{buildDirPath, artifactName});
        PropFile deps = Deps.getResolvedProperties((boolean)false);
        return Deps.getClasspath((PropFile)deps, (String[])new String[]{artifactPath});
    }
}

