/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.submodules;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;
import net.ocheyedan.ply.submodules.Submodule;

public final class Submodules {
    public static List<Submodule> getSubmodules(File configDirectory) {
        PropFile.Prop submodulesScopeProp = Props.get((String)"submodules.scope", (Context)Context.named((String)"project"), (Scope)Props.getScope(), (File)configDirectory);
        Scope submodulesScope = submodulesScopeProp == null ? Scope.Default : Scope.named((String)submodulesScopeProp.value());
        HashMap<String, Submodule> submodules = new HashMap<String, Submodule>();
        LinkedList<String> ordering = new LinkedList<String>();
        Submodules.getSubmodules(configDirectory, submodulesScope, "", submodules, ordering);
        return Submodules.sortSubmodules(submodules, ordering, configDirectory, submodulesScope);
    }

    private static void getSubmodules(File configDirectory, Scope scope, String parentName, Map<String, Submodule> submodules, List<String> ordering) {
        PropFileChain submodulesProps = Props.get((Context)Context.named((String)"submodules"), (Scope)scope, (File)configDirectory);
        if (submodulesProps == null) {
            return;
        }
        for (PropFile.Prop submoduleProp : submodulesProps.props()) {
            String submoduleName;
            if ("exclude".equals(submoduleProp.value())) continue;
            String key = submoduleProp.name;
            String string = submoduleName = parentName.isEmpty() ? key : FileUtil.pathFromParts((String[])new String[]{parentName, key});
            File submoduleConfigDir = FileUtil.fromParts((String[])new String[]{configDirectory.getPath(), "..", "..", key, ".ply", "config"});
            if (!submoduleConfigDir.exists()) continue;
            String submoduleResolvedDepName = Submodules.getSubmoduleResolvedDepName(submoduleConfigDir, scope);
            Submodule submodule = new Submodule(submoduleName, submoduleResolvedDepName);
            submodules.put(submoduleResolvedDepName, submodule);
            ordering.add(submoduleResolvedDepName);
            Submodules.getSubmodules(submoduleConfigDir, scope, key, submodules, ordering);
        }
    }

    static List<Submodule> sortSubmodules(final Map<String, Submodule> submodules, final List<String> ordering, File configDirectory, Scope scope) {
        if (submodules == null || submodules.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Submodule> orderedSubmodules = new ArrayList<Submodule>();
        final HashMap<Submodule, Set<String>> submoduleDepMap = new HashMap<Submodule, Set<String>>();
        for (String submoduleDepName : submodules.keySet()) {
            Submodule submodule = submodules.get(submoduleDepName);
            orderedSubmodules.add(submodule);
            File submoduleConfigDir = FileUtil.fromParts((String[])new String[]{FileUtil.getCanonicalPath((File)configDirectory), "..", "..", submodule.name, ".ply", "config"});
            PropFileChain depProps = Props.get((Context)Context.named((String)"dependencies"), (Scope)scope, (File)submoduleConfigDir);
            Set<String> deps = Submodules.convertDeps(depProps, submodules);
            submoduleDepMap.put(submodule, deps);
        }
        Comparator<Submodule> comparator = new Comparator<Submodule>(){

            @Override
            public int compare(Submodule submoduleA, Submodule submoduleB) {
                if (submoduleA.name.equals(submoduleB.name)) {
                    return 0;
                }
                if (Submodules.dependsUpon(submoduleA, submoduleB, submodules, submoduleDepMap)) {
                    return 1;
                }
                if (Submodules.dependsUpon(submoduleB, submoduleA, submodules, submoduleDepMap)) {
                    return -1;
                }
                if (submoduleA.name.contains(submoduleB.name)) {
                    return 1;
                }
                if (submoduleB.name.contains(submoduleA.name)) {
                    return -1;
                }
                if (submoduleA.name.contains(File.separator) && !submoduleB.name.contains(File.separator)) {
                    return 1;
                }
                if (submoduleB.name.contains(File.separator) && !submoduleA.name.contains(File.separator)) {
                    return -1;
                }
                int submoduleAOrdering = ordering.indexOf(submoduleA.dependencyName);
                int submoduleBOrdering = ordering.indexOf(submoduleB.dependencyName);
                return Integer.valueOf(submoduleAOrdering).compareTo(submoduleBOrdering);
            }
        };
        Collections.sort(orderedSubmodules, comparator);
        return orderedSubmodules;
    }

    private static boolean dependsUpon(Submodule submodule, Submodule dependencyToCheck, Map<String, Submodule> submodules, Map<Submodule, Set<String>> submoduleDepMap) {
        Set<String> submoduleDeps = submoduleDepMap.get(submodule);
        if (submoduleDeps == null) {
            return false;
        }
        if (submoduleDeps.contains(dependencyToCheck.dependencyName)) {
            return true;
        }
        for (String dep : submoduleDeps) {
            if (!submodules.containsKey(dep) || !Submodules.dependsUpon(submodules.get(dep), dependencyToCheck, submodules, submoduleDepMap)) continue;
            return true;
        }
        return false;
    }

    private static String getSubmoduleResolvedDepName(File submoduleConfigDir, Scope scope) {
        String defaultArtifactName;
        Context projectContext = Context.named((String)"project");
        String namespace = Props.get((String)"namespace", (Context)projectContext, (Scope)scope, (File)submoduleConfigDir).value();
        String name = Props.get((String)"name", (Context)projectContext, (Scope)scope, (File)submoduleConfigDir).value();
        String version = Props.get((String)"version", (Context)projectContext, (Scope)scope, (File)submoduleConfigDir).value();
        String artifactName = Props.get((String)"artifact.name", (Context)projectContext, (Scope)scope, (File)submoduleConfigDir).value();
        if (artifactName.equals(defaultArtifactName = name + "-" + version + "." + "jar")) {
            return namespace + ":" + name + ":" + version;
        }
        return namespace + ":" + name + ":" + version + ":" + artifactName;
    }

    private static Set<String> convertDeps(PropFileChain depProps, Map<String, Submodule> submodules) {
        if (depProps == null) {
            return Collections.emptySet();
        }
        HashSet<String> deps = new HashSet<String>();
        for (PropFile.Prop depProp : depProps.props()) {
            String dep = depProp.name + ":" + depProp.value();
            if (!submodules.containsKey(dep)) continue;
            deps.add(dep);
        }
        return deps;
    }

    private Submodules() {
    }
}

