/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.props;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.exec.Execution;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Loader;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

public final class PropsExt {
    private static final Map<String, Map<String, String>> RESOLVED_ENV_CACHE = new HashMap<String, Map<String, String>>();
    private static final String ENV_VAR_NAME_PREFIX = "ply_";

    public static Map<String, String> getPropsForEnv(Execution execution, File configDirectory, Scope scope) {
        String cacheKey = FileUtil.getCanonicalPath((File)configDirectory) + "-" + scope.name + "-" + execution.getEnvKeyId();
        if (RESOLVED_ENV_CACHE.containsKey(cacheKey)) {
            return RESOLVED_ENV_CACHE.get(cacheKey);
        }
        PropFile.Prop submodulesScopeProp = Props.get((String)"submodules.scope", (Context)Context.named((String)"project"), (Scope)Props.getScope(), (File)configDirectory);
        Scope submodulesScope = Scope.named((String)submodulesScopeProp.value());
        Map props = Props.get((Scope)scope, (File)configDirectory);
        HashMap<String, String> envProps = new HashMap<String, String>(props.size() * 5);
        for (Context context : props.keySet()) {
            PropFileChain contextProps = (PropFileChain)props.get(context);
            if ("submodules".equals(context.name) && !scope.equals((Object)submodulesScope)) {
                contextProps = Props.get((Context)context, (Scope)submodulesScope);
            }
            for (PropFile.Prop prop : contextProps.props()) {
                String envKey = execution.getEnvKey(ENV_VAR_NAME_PREFIX, context, prop.name);
                envProps.put(envKey, prop.value());
            }
        }
        Context plyContext = Context.named((String)"ply");
        envProps.put(execution.getEnvKey(ENV_VAR_NAME_PREFIX, plyContext, "project.dir"), PlyUtil.getProjectDir((File)configDirectory));
        envProps.put(execution.getEnvKey(ENV_VAR_NAME_PREFIX, plyContext, "java"), System.getProperty("ply.java"));
        envProps.put(execution.getEnvKey(ENV_VAR_NAME_PREFIX, plyContext, "original.user.dir"), System.getProperty("user.dir"));
        envProps.put(execution.getEnvKey(ENV_VAR_NAME_PREFIX, plyContext, "scope"), scope.name);
        envProps.put(execution.getEnvKey(ENV_VAR_NAME_PREFIX, plyContext, "color"), String.valueOf(Output.isColoredOutput()));
        envProps.put(execution.getEnvKey(ENV_VAR_NAME_PREFIX, plyContext, "invoker"), "ply");
        RESOLVED_ENV_CACHE.put(cacheKey, envProps);
        return envProps;
    }

    public static void invalidateFilteredCaches(File configurationDirectory) {
        Props.invalidateFilteredCaches((File)configurationDirectory);
    }

    public static void invalidateCaches(File configurationDirectory) {
        Loader.invalidateCaches((File)configurationDirectory);
        Props.invalidateFilteredCaches((File)configurationDirectory);
    }

    private PropsExt() {
    }
}

