/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.exec;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

final class StdinProcessPipe
extends Thread {
    final AtomicBoolean started;
    final AtomicReference<OutputStream> processStdin;

    public StdinProcessPipe() {
        this(new AtomicReference<Object>(null));
    }

    private StdinProcessPipe(AtomicReference<OutputStream> processStdin) {
        super(new Runner(processStdin));
        this.setDaemon(true);
        this.started = new AtomicBoolean(false);
        this.processStdin = processStdin;
    }

    void write(char[] buffer) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.processStdin.get()));
        writer.write(buffer, 0, buffer.length);
        writer.write(10);
        writer.flush();
    }

    public void pausePipe() {
        this.processStdin.set(null);
    }

    public void startPipe(OutputStream processStdin) {
        this.processStdin.set(processStdin);
        this.start();
    }

    @Override
    public void start() {
        if (!this.started.getAndSet(true)) {
            super.start();
        }
    }

    static final class Runner
    implements Runnable {
        final AtomicReference<OutputStream> processStdin;

        Runner(AtomicReference<OutputStream> processStdin) {
            this.processStdin = processStdin;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[4096];
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    int avail = System.in.available();
                    if (avail > 0) {
                        int read = System.in.read(buffer, 0, Math.min(avail, buffer.length));
                        OutputStream stdin = this.processStdin.get();
                        if (stdin == null) continue;
                        stdin.write(buffer, 0, read);
                        stdin.flush();
                        continue;
                    }
                    Thread.sleep(100L);
                }
                catch (IOException ioe) {
                    if (ioe.getMessage().contains("Broken pipe")) {
                        this.processStdin.set(null);
                        continue;
                    }
                    throw new AssertionError((Object)ioe);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

