/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.exec;

import java.io.File;
import java.util.regex.Pattern;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.cmd.build.Script;
import net.ocheyedan.ply.cmd.build.ShellScript;
import net.ocheyedan.ply.exec.Execution;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

final class ShellExecution
extends Execution {
    static ShellExecution createShellExecutable(Execution execution, File configDirectory) {
        String executable = execution.executionArgs[0];
        String shell = Props.get((String)"shell", (Context)Context.named((String)"scripts-sh"), (Scope)execution.script.scope, (File)configDirectory).value();
        String shellArgs = Props.get((String)"shell.args", (Context)Context.named((String)"scripts-sh"), (Scope)execution.script.scope, (File)configDirectory).value();
        if (shell.isEmpty()) {
            Output.print((String)"^error^ Cannot run '^b^%s^r^'. No ^b^shell^r^ property defined (^b^ply set shell=xxxx in scripts-sh^r^).", (Object[])new Object[]{executable});
            throw new SystemExit(1);
        }
        int supplimentalArgLength = 1 + (shellArgs.isEmpty() ? 0 : 1);
        String[] args = new String[supplimentalArgLength + 1];
        args[0] = shell;
        if (supplimentalArgLength > 1) {
            args[1] = shellArgs;
        }
        args[supplimentalArgLength] = ShellExecution.combine(execution.executionArgs);
        if (Output.isDebug() && execution.script instanceof ShellScript) {
            return new ShellExecution(executable, execution.script, args);
        }
        return new ShellExecution(execution.name, execution.script, args);
    }

    static String combine(String[] args) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                buffer.append(" ");
            }
            buffer.append(arg);
            first = false;
        }
        return buffer.toString();
    }

    ShellExecution(String name, Script script, String[] executionArgs) {
        super(name, script, executionArgs);
    }

    @Override
    public String getEnvKey(String prefix, Context context, String propName) {
        propName = propName.replaceAll(Pattern.quote("."), "_");
        return prefix + context.name + "_" + propName;
    }

    @Override
    public String getEnvKeyId() {
        return "shellexecution";
    }
}

