/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.exec;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.cmd.build.Script;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.dep.Repos;
import net.ocheyedan.ply.dep.RepositoryRegistry;
import net.ocheyedan.ply.exec.Execution;
import net.ocheyedan.ply.exec.StdinProcessPipe;
import net.ocheyedan.ply.graph.DirectedAcyclicGraph;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileReader;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

final class JvmExecution
extends Execution {
    private final boolean usingJvmPrimer;

    static JvmExecution createJarExecutable(Execution execution, File configDirectory) {
        String classpath = null;
        AtomicReference<String> mainClass = new AtomicReference<String>();
        AtomicBoolean staticClasspath = new AtomicBoolean(false);
        AtomicBoolean containsJvmPrimer = new AtomicBoolean(false);
        String[] options = JvmExecution.getJarScriptOptions(configDirectory, execution, staticClasspath, containsJvmPrimer);
        if (!staticClasspath.get()) {
            classpath = JvmExecution.getClasspathEntries(execution.executionArgs[0], execution.script.scope, mainClass, configDirectory);
        }
        int classpathLength = staticClasspath.get() ? 0 : (classpath == null ? 2 : 3);
        int propertyLength = 3;
        String script = System.getProperty("ply.java");
        String[] newCmdArray = new String[execution.executionArgs.length + options.length + classpathLength + propertyLength];
        newCmdArray[0] = script;
        newCmdArray[1] = "-Dply.home=" + System.getProperty("ply.home");
        newCmdArray[2] = "-Dply.version=" + System.getProperty("ply.version");
        newCmdArray[3] = "-Dply.java=" + System.getProperty("ply.java");
        System.arraycopy(options, 0, newCmdArray, 4, options.length);
        if (classpath != null) {
            newCmdArray[options.length + propertyLength + 1] = "-classpath";
            newCmdArray[options.length + propertyLength + 2] = classpath;
            newCmdArray[options.length + propertyLength + 3] = mainClass.get();
        } else if (!staticClasspath.get()) {
            newCmdArray[options.length + propertyLength + 1] = "-jar";
            newCmdArray[options.length + propertyLength + 2] = execution.executionArgs[0];
        }
        System.arraycopy(execution.executionArgs, 1, newCmdArray, options.length + classpathLength + propertyLength + 1, execution.executionArgs.length - 1);
        return new JvmExecution(execution.name, execution.script, newCmdArray, containsJvmPrimer.get());
    }

    static JvmExecution createClojureExecutable(Execution execution, File configDirectory) {
        String clojureJar = Props.get((String)"clojure.home", (Context)Context.named((String)"scripts-clj"), (Scope)execution.script.scope, (File)configDirectory).value();
        if (clojureJar.isEmpty()) {
            Output.print((String)"^error^ Cannot execute clojure script ^b^%s^r^ as the ^b^clojure.home^r^ property was not set within the ^b^scripts-clj^r^ context.", (Object[])new Object[]{execution.executionArgs[0]});
            throw new SystemExit(1);
        }
        JvmExecution jarExec = JvmExecution.createJarExecutable(execution.with(clojureJar), configDirectory);
        String[] args = jarExec.executionArgs;
        String[] clojureArgs = new String[args.length + 2];
        System.arraycopy(args, 0, clojureArgs, 0, args.length);
        if (clojureArgs[args.length - 2].equals("-jar")) {
            clojureArgs[args.length - 2] = "-cp";
        }
        clojureArgs[args.length] = "clojure.main";
        clojureArgs[args.length + 1] = execution.executionArgs[0];
        return new JvmExecution(jarExec.name, jarExec.script, clojureArgs, false);
    }

    private static String getClasspathEntries(String jarPath, Scope scope, AtomicReference<String> mainClass, File projectConfigDir) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarPath, false);
            Manifest manifest = jarFile.getManifest();
            if (manifest != null) {
                mainClass.set(manifest.getMainAttributes().getValue("Main-Class"));
            }
            String artifactsLabelName = Props.get((String)"artifacts.label", (Context)Context.named((String)"project"), (Scope)scope).value();
            Scope artifactsLabel = Scope.named((String)artifactsLabelName);
            JarEntry dependenciesJarEntry = jarFile.getJarEntry(String.format("META-INF/ply/dependencies%s.properties", artifactsLabel.getFileSuffix()));
            if (dependenciesJarEntry == null) {
                String string = null;
                return string;
            }
            InputStream dependenciesStream = jarFile.getInputStream(dependenciesJarEntry);
            PropFile dependencies = new PropFile(Context.named((String)"dependencies"), PropFile.Loc.Local);
            PropFileReader.Default.load(new BufferedReader(new InputStreamReader(dependenciesStream)), dependencies);
            if (dependencies.isEmpty()) {
                String string = null;
                return string;
            }
            List deps = Deps.parse((PropFile)dependencies, null);
            RepositoryRegistry repos = Repos.createRepositoryRegistry((File)projectConfigDir, (Scope)scope, null, null);
            DirectedAcyclicGraph depGraph = Deps.getDependencyGraph((List)deps, Collections.emptySet(), (RepositoryRegistry)repos);
            PropFile resolvedDependencies = Deps.convertToResolvedPropertiesFile((DirectedAcyclicGraph)depGraph);
            String string = Deps.getClasspath((PropFile)resolvedDependencies, (String[])new String[]{jarPath});
            return string;
        }
        catch (IOException ioe) {
            Output.print((Throwable)ioe);
            throw new SystemExit(1);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ioe) {
                    throw new AssertionError((Object)ioe);
                }
            }
        }
    }

    private static String[] getJarScriptOptions(File configDirectory, Execution execution, AtomicBoolean staticClasspath, AtomicBoolean containsJvmPrimer) {
        String options;
        String executable = execution.executionArgs[0];
        int index = executable.lastIndexOf(File.separator);
        if (index != -1) {
            executable = executable.substring(index + 1);
        }
        if ((options = Props.get((String)("options." + executable), (Context)Context.named((String)"scripts-jar"), (Scope)execution.script.scope, (File)configDirectory).value()).isEmpty()) {
            options = Props.get((String)"options.default", (Context)Context.named((String)"scripts-jar"), (Scope)execution.script.scope, (File)configDirectory).value();
        }
        if (options.contains("-cp") || options.contains("-classpath") || options.contains("-Xbootclasspath")) {
            staticClasspath.set(true);
        }
        if (options.contains("net.ocheyedan.ply.JvmPrimer")) {
            containsJvmPrimer.set(true);
        }
        return options.split(" ");
    }

    JvmExecution(String name, Script script, String[] executionArgs, boolean usingJvmPrimer) {
        super(name, script, executionArgs);
        this.usingJvmPrimer = usingJvmPrimer;
    }

    @Override
    void preInvoke(File projectRoot, Map<String, String> supplementalEnvironment) {
        super.preInvoke(projectRoot, supplementalEnvironment);
        if (!this.usingJvmPrimer) {
            return;
        }
        try {
            Process process = ((ProcessBuilder)this.processBuilder.get()).start();
            this.process.set(process);
        }
        catch (IOException ioe) {
            this.process.set(null);
        }
    }

    @Override
    void invoke(String scriptName) throws IOException {
        if (!this.usingJvmPrimer || this.process.get() == null) {
            super.invoke(scriptName);
        } else {
            Output.print((String)"^dbug^ invoking %s", (Object[])new Object[]{scriptName});
            ((Process)this.process.get()).getOutputStream().write(11);
            ((Process)this.process.get()).getOutputStream().flush();
            ((StdinProcessPipe)STDIN_PROCESS_PIPE.get()).startPipe(((Process)this.process.get()).getOutputStream());
            this.processStdout.set(new BufferedReader(new InputStreamReader(((Process)this.process.get()).getInputStream())));
        }
    }
}

