/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.cmd.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.cmd.Args;
import net.ocheyedan.ply.cmd.config.Config;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

public class Describe
extends Config {
    public Describe(Args args) {
        super(args);
    }

    @Override
    protected void runAfterAssumptionsCheck() {
        this.print(PlyUtil.LOCAL_CONFIG_DIR);
    }

    public void print(File configurationDirectory) {
        ArrayList<String> printStatements = new ArrayList<String>();
        List<Info> infos = this.extractInfo(Props.get((File)configurationDirectory));
        int count = 0;
        for (Info info : infos) {
            if (!this.printContext(info, printStatements)) continue;
            ++count;
        }
        Output.print((String)"There are ^b^%d^r^ local contexts", (Object[])new Object[]{count});
        for (String printStatement : printStatements) {
            Output.print((String)printStatement, (Object[])new Object[0]);
        }
        Output.print((String)"Property counts are for the default scope", (Object[])new Object[0]);
    }

    protected List<Info> extractInfo(Map<Scope, Map<Context, PropFileChain>> data) {
        ArrayList<Info> infos = new ArrayList<Info>();
        HashMap<String, Info> mapping = new HashMap<String, Info>();
        for (Map.Entry<Scope, Map<Context, PropFileChain>> entry : data.entrySet()) {
            Scope scope = entry.getKey();
            for (Map.Entry<Context, PropFileChain> contextEntry : entry.getValue().entrySet()) {
                List<PropFile.Prop> props;
                Integer count;
                Info info = (Info)mapping.get(contextEntry.getKey().name);
                if (info == null) {
                    info = new Info(contextEntry.getKey().name, new HashMap<String, Integer>());
                    mapping.put(contextEntry.getKey().name, info);
                    infos.add(info);
                }
                if ((count = (Integer)info.scopeToPropertyCount.get(scope.name)) == null) {
                    count = 0;
                }
                if ((props = this.collect(contextEntry.getValue().props(), scope)).isEmpty()) continue;
                count = count + props.size();
                info.scopeToPropertyCount.put(scope.name, count);
            }
        }
        Collections.sort(infos);
        return infos;
    }

    protected List<PropFile.Prop> collect(Iterable<PropFile.Prop> props, Scope scope) {
        ArrayList<PropFile.Prop> properties = new ArrayList<PropFile.Prop>();
        for (PropFile.Prop prop : props) {
            if (!this.accept(prop) || !prop.scope().equals((Object)scope)) continue;
            properties.add(prop);
        }
        return properties;
    }

    protected boolean accept(PropFile.Prop prop) {
        return prop.loc() != PropFile.Loc.System;
    }

    protected boolean printContext(Info info, List<String> printStatements) {
        if (info == null || info.scopeToPropertyCount == null || info.scopeToPropertyCount.isEmpty()) {
            return false;
        }
        Integer count = (Integer)info.scopeToPropertyCount.get(Scope.Default.name);
        ArrayList scopeNames = new ArrayList(info.scopeToPropertyCount.keySet());
        Collections.sort(scopeNames);
        StringBuilder scopes = new StringBuilder();
        int scopeCount = 0;
        for (String scopeName : scopeNames) {
            if (scopeName.isEmpty() || info.scopeToPropertyCount.get(scopeName) == null || (Integer)info.scopeToPropertyCount.get(scopeName) < 1) continue;
            if (scopes.length() > 0) {
                scopes.append(", ");
            }
            ++scopeCount;
            scopes.append("^magenta^");
            scopes.append(scopeName);
            scopes.append("^r^");
        }
        String appendage = "";
        if (scopes.length() > 0) {
            appendage = String.format(" (and non-default scope%s %s)", scopeCount > 1 ? "s" : "", scopes.toString());
        }
        printStatements.add(String.format("    ^b^%s^r^ contains ^b^%d^r^ properties%s", info.contextName, count == null ? 0 : count, appendage));
        return true;
    }

    private static class Info
    implements Comparable<Info> {
        private final String contextName;
        private final Map<String, Integer> scopeToPropertyCount;

        public Info(String contextName, Map<String, Integer> scopeToPropertyCount) {
            this.contextName = contextName;
            this.scopeToPropertyCount = scopeToPropertyCount;
        }

        @Override
        public int compareTo(Info other) {
            return this.contextName.compareTo(other.contextName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            return this.contextName == null ? info.contextName == null : this.contextName.equals(info.contextName);
        }

        public int hashCode() {
            return this.contextName != null ? this.contextName.hashCode() : 0;
        }
    }
}

