/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.cmd.config;

import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.cmd.Args;
import net.ocheyedan.ply.cmd.Usage;
import net.ocheyedan.ply.cmd.config.Config;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

public class Append
extends Config {
    public Append(Args args) {
        super(args);
    }

    @Override
    protected void runAfterAssumptionsCheck() {
        Opts opts = this.parse(this.args);
        if (opts == null) {
            new Usage(this.args).run();
            return;
        }
        String path = FileUtil.pathFromParts((String[])new String[]{PlyUtil.LOCAL_CONFIG_DIR.getPath(), opts.context.name + opts.scope.getFileSuffix() + ".properties"});
        PropFile properties = new PropFile(opts.context, opts.scope, PropFile.Loc.Local);
        PropFiles.load((String)path, (PropFile)properties, (boolean)true);
        String propValue = opts.propValue;
        String existing = this.getExisting(opts.context, opts.propName);
        if (existing != null) {
            propValue = this.getFromExisting(existing, propValue);
        }
        properties.remove(opts.propName);
        properties.add(opts.propName, propValue);
        PropFiles.store((PropFile)properties, (String)path, (boolean)true);
    }

    protected String getFromExisting(String existing, String addition) {
        return (existing.isEmpty() ? existing : existing + " ") + addition;
    }

    protected String getExisting(Context context, String propName) {
        PropFileChain props = Props.get((Context)context);
        if (props == null) {
            return null;
        }
        for (PropFile.Prop prop : props.props()) {
            if (!prop.name.equals(propName)) continue;
            return prop.unfilteredValue;
        }
        return null;
    }

    Opts parse(Args args) {
        Scope scope = Scope.Default;
        int scopeIndex = args.args.get(0).indexOf(":");
        if (scopeIndex != -1) {
            scope = Scope.named((String)args.args.get(0).substring(0, scopeIndex));
        }
        switch (args.args.size()) {
            case 6: {
                if (!"to".equals(args.args.get(2)) || !"in".equals(args.args.get(4))) break;
                String propName = args.args.get(3);
                String propValue = args.args.get(1);
                return new Opts(scope, new Context(args.args.get(5)), propName, propValue);
            }
        }
        return null;
    }

    static class Opts {
        final Scope scope;
        final Context context;
        final String propName;
        final String propValue;

        Opts(Scope scope, Context context, String propName, String propValue) {
            this.scope = scope;
            this.context = context;
            this.propName = propName;
            this.propValue = propValue;
        }
    }
}

