/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.cmd.build;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.OutputExt;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.cmd.Args;
import net.ocheyedan.ply.cmd.Command;
import net.ocheyedan.ply.cmd.build.Module;
import net.ocheyedan.ply.exec.Exec;
import net.ocheyedan.ply.exec.Execution;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.submodules.Submodule;
import net.ocheyedan.ply.submodules.Submodules;

public final class Build
extends Command.ProjectReliant {
    public Build(Args args) {
        super(args);
    }

    @Override
    protected void runBeforeAssumptionsCheck() {
    }

    @Override
    protected void runAfterAssumptionsCheck() {
        long start = System.currentTimeMillis();
        List<Execution> executions = Module.resolve(this.args, PlyUtil.LOCAL_CONFIG_DIR);
        OutputExt.init();
        String projectName = Props.get((String)"name", (Context)Context.named((String)"project")).value();
        String projectVersion = Props.get((String)"version", (Context)Context.named((String)"project")).value();
        Output.printNoLine((String)"^ply^ building ^b^%s^r^, %s", (Object[])new Object[]{projectName, projectVersion});
        List<Submodule> orderedSubmodules = Submodules.getSubmodules(PlyUtil.LOCAL_CONFIG_DIR);
        if (orderedSubmodules == null || orderedSubmodules.isEmpty()) {
            Output.print((String)"", (Object[])new Object[0]);
            if (!Exec.invoke(PlyUtil.LOCAL_PROJECT_DIR, executions)) {
                throw new SystemExit(1);
            }
        } else {
            float seconds;
            Output.print((String)" and its submodules:", (Object[])new Object[0]);
            for (Submodule submodule : orderedSubmodules) {
                Output.print((String)"^ply^   ^b^%s^r^", (Object[])new Object[]{submodule.name});
            }
            LinkedHashMap<String, Float> submodulesTimeMap = new LinkedHashMap<String, Float>(orderedSubmodules.size());
            Output.print((String)"^ply^", (Object[])new Object[0]);
            Output.print((String)"^ply^ building ^b^%s^r^ itself before its submodules", (Object[])new Object[]{projectName});
            long projectStart = System.currentTimeMillis();
            if (!Exec.invoke(PlyUtil.LOCAL_PROJECT_DIR, executions)) {
                throw new SystemExit(1);
            }
            int maxSubmoduleName = projectName.length();
            float maxSubmoduleTime = seconds = this.printTime(projectStart, String.format("^b^%s^r^ ", projectName));
            submodulesTimeMap.put(projectName, Float.valueOf(seconds));
            Output.print((String)"^ply^", (Object[])new Object[0]);
            for (Submodule submodule : orderedSubmodules) {
                Output.print((String)"^ply^ building ^b^%s^r^", (Object[])new Object[]{submodule});
                if (submodule.name.length() > maxSubmoduleName) {
                    maxSubmoduleName = submodule.name.length();
                }
                long submoduleStart = System.currentTimeMillis();
                File submodulePlyDir = FileUtil.fromParts((String[])new String[]{PlyUtil.LOCAL_PROJECT_DIR.getPath(), "..", submodule.name, ".ply"});
                if (!submodulePlyDir.exists()) {
                    File submoduleDir = FileUtil.fromParts((String[])new String[]{PlyUtil.LOCAL_PROJECT_DIR.getPath(), "..", submodule.name});
                    if (!submoduleDir.exists()) {
                        Output.print((String)"^warn^ directory ^b^%s^r^ doesn't exist.", (Object[])new Object[]{submodule.name});
                    } else {
                        Output.print((String)"^warn^ submodule ^b^%s^r^ is not a ply project, skipping.", (Object[])new Object[]{submodule.name});
                    }
                    Output.print((String)"^ply^", (Object[])new Object[0]);
                    continue;
                }
                File submoduleConfigDir = FileUtil.fromParts((String[])new String[]{FileUtil.getCanonicalPath((File)submodulePlyDir), "config"});
                List<Execution> submoduleExecutions = Module.resolve(this.args, submoduleConfigDir);
                if (!Exec.invoke(submodulePlyDir, submoduleExecutions)) {
                    throw new SystemExit(1);
                }
                Object[] objectArray = new Object[]{submodule.name};
                seconds = this.printTime(submoduleStart, String.format("^b^%s^r^ ", objectArray));
                if (seconds > maxSubmoduleTime) {
                    maxSubmoduleTime = seconds;
                }
                submodulesTimeMap.put(submodule.name, Float.valueOf(seconds));
                Output.print((String)"^ply^", (Object[])new Object[0]);
            }
            Output.print((String)"^ply^ Build Summary", (Object[])new Object[0]);
            maxSubmoduleName = Math.min(maxSubmoduleName, 80);
            int maxTimeLength = String.valueOf(Float.valueOf(maxSubmoduleTime).intValue()).length();
            for (String module : submodulesTimeMap.keySet()) {
                int pad = Math.max(1, maxSubmoduleName + 1 - module.length());
                float time = ((Float)submodulesTimeMap.get(module)).floatValue();
                int timePad = Math.max(0, maxTimeLength - String.valueOf(Float.valueOf(time).intValue()).length());
                String timePadString = timePad == 0 ? "" : String.valueOf(timePad);
                Output.print((String)("^ply^ ^b^%s^r^%" + pad + "s%" + timePadString + "s^b^%.3f^r^ seconds"), (Object[])new Object[]{module, "", "", Float.valueOf(time)});
            }
        }
        this.printTime(start, "");
    }

    private float printTime(long start, String suppliment) {
        long end = System.currentTimeMillis();
        float seconds = (float)(end - start) / 1000.0f;
        long totalMem = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
        long freeMem = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
        Output.print((String)"^ply^ Finished %sin ^b^%.3f seconds^r^ using ^b^%d/%d MB^r^.", (Object[])new Object[]{suppliment, Float.valueOf(seconds), totalMem - freeMem, totalMem});
        return seconds;
    }
}

