/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.cmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.OutputExt;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.SlowTaskThread;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.cmd.Args;
import net.ocheyedan.ply.cmd.Command;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;

public final class Update
extends Command.SystemReliant {
    public Update(Args args) {
        super(args);
    }

    @Override
    protected void runBeforeAssumptionsCheck() {
        OutputExt.init();
    }

    @Override
    public void runAfterAssumptionsCheck() {
        try {
            final String currentVersion = this.getCurrentVersion();
            Output.print((String)"Ply is at version ^b^%s^r^, checking for updates.", (Object[])new Object[]{currentVersion});
            final String updateUrl = Props.get((String)"update.url", (Context)Context.named((String)"ply")).value();
            Map updateInstructions = (Map)SlowTaskThread.after((long)2000L).warn("It's taking longer than expected to download the update instructions. Still trying...").onlyIfNotLoggingInfo().whenDoing((Callable)new Callable<Map<String, List<String>>>(){

                @Override
                public Map<String, List<String>> call() throws Exception {
                    return Update.this.validateUpdateInstructions(Update.this.downloadUpdateInstr(updateUrl), currentVersion);
                }
            }).start();
            this.update(updateInstructions, currentVersion);
        }
        catch (SystemExit se) {
            System.exit(se.exitCode);
        }
        catch (Throwable t) {
            Output.print((Throwable)t);
            System.exit(1);
        }
    }

    private void update(Map<String, List<String>> updateInstructions, String currentVersion) {
        File plyHomeDir;
        List<String> versions = updateInstructions.get("VERSIONS");
        int currentVersionIndex = versions.indexOf(currentVersion);
        int numberOfUpdates = versions.size() - 1 - currentVersionIndex;
        if (numberOfUpdates == 0) {
            Output.print((String)"No updates needed, ply is already up to date.", (Object[])new Object[0]);
            return;
        }
        Output.print((String)"Found %d updates to ply.", (Object[])new Object[]{numberOfUpdates});
        String plyHome = PlyUtil.INSTALL_DIRECTORY;
        if (plyHome == null || !(plyHomeDir = new File(plyHome)).exists()) {
            Output.print((String)"^error^ Could not find the PLY_HOME environment variable. Cannot update ply.", (Object[])new Object[0]);
            throw new SystemExit(1);
        }
        File backupDir = this.backup(plyHomeDir, currentVersion);
        try {
            int warnings = 0;
            for (int i = currentVersionIndex; i < versions.size(); ++i) {
                String version = versions.get(i);
                List<String> instructions = updateInstructions.get(version);
                warnings += this.update(version, instructions, plyHomeDir);
            }
            String numberOfUpdatesText = numberOfUpdates > 1 ? String.format(" (^b^%d^r^ updates)", numberOfUpdates) : "";
            String mostUpToDateVersion = versions.get(versions.size() - 1);
            if (warnings == 0) {
                Output.print((String)"Successfully updated ply from ^yellow^%s^r^ to ^green^%s^r^%s!", (Object[])new Object[]{currentVersion, mostUpToDateVersion, numberOfUpdatesText});
            } else {
                Output.print((String)"Updated ply from ^yellow^%s^r^ to ^b^%s^r^%s but need %d manual correction%s.", (Object[])new Object[]{currentVersion, mostUpToDateVersion, numberOfUpdatesText, warnings, warnings == 1 ? "" : "s"});
            }
        }
        catch (Exception e) {
            Output.print((Throwable)e);
            if (!this.restore(plyHomeDir, backupDir, currentVersion)) {
                Output.print((String)"^error^ Ah! Failed to restore from backup. So sorry, we suck, you may have to reinstall ply.", (Object[])new Object[0]);
            }
            throw new SystemExit(1, (Throwable)e);
        }
    }

    private int update(String version, List<String> instructions, File plyHomeDir) {
        int warnings = 0;
        if (!instructions.isEmpty()) {
            Output.print((String)"^info^ Updating from ^b^%s^r^", (Object[])new Object[]{version});
        }
        for (String instruction : instructions) {
            warnings += this.update(instruction, plyHomeDir);
        }
        return warnings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int update(String instruction, final File plyHomeDir) {
        int warnings = 0;
        if (instruction.startsWith("OUTPUT=")) {
            String output = instruction.substring("OUTPUT=".length());
            Output.print((String)"^dbug^ %s", (Object[])new Object[]{output});
            return warnings;
        } else {
            if (!instruction.startsWith("METHOD=")) throw new AssertionError((Object)String.format("Unknown instruction ^b^%s^r^.", instruction));
            String methodInstruction = instruction.substring("METHOD=".length());
            int methodIndex = methodInstruction.indexOf("=");
            if (methodIndex == -1) {
                Output.print((String)"^error^ Invalid method instruction [ %s ].", (Object[])new Object[]{methodInstruction});
                throw new SystemExit(1);
            }
            String method = methodInstruction.substring(0, methodIndex);
            instruction = methodInstruction.substring(methodIndex + 1);
            if ("property".equals(method)) {
                warnings += this.updateProperty(instruction, FileUtil.fromParts((String[])new String[]{plyHomeDir.getPath(), "config"}));
                return warnings;
            } else if ("download".equals(method)) {
                final String parsedInstruction = instruction;
                try {
                    warnings += ((Integer)SlowTaskThread.after((long)2000L).warn("It's taking longer than expected to download an update. Still trying...").onlyIfNotLoggingDebug().whenDoing((Callable)new Callable<Integer>(){

                        @Override
                        public Integer call() throws Exception {
                            return Update.this.download(parsedInstruction, plyHomeDir);
                        }
                    }).start()).intValue();
                    return warnings;
                }
                catch (SystemExit se) {
                    throw se;
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            } else {
                Output.print((String)"^error^ Unrecognized method [ %s ].", (Object[])new Object[]{method});
                throw new SystemExit(1);
            }
        }
    }

    private int updateProperty(String instruction, File configDirectory) {
        int propertyNameIndex;
        int contextIndex;
        int n = contextIndex = instruction == null ? -1 : instruction.indexOf(".");
        if (contextIndex == -1) {
            Output.print((String)"^error^ Invalid property instruction [ %s ].", (Object[])new Object[]{instruction});
            throw new SystemExit(1);
        }
        String context = instruction.substring(0, contextIndex);
        if (context.contains("#")) {
            context = context.replaceAll("#", ".");
        }
        if ((propertyNameIndex = (instruction = instruction.substring(contextIndex + 1)).indexOf("=")) == -1) {
            Output.print((String)"^error^ Invalid property instruction [ %s ].", (Object[])new Object[]{instruction});
            throw new SystemExit(1);
        }
        String propName = instruction.substring(0, propertyNameIndex);
        instruction = instruction.substring(propertyNameIndex + 1);
        char[] characters = instruction.toCharArray();
        boolean escaped = false;
        int index = -1;
        String propValue = null;
        String expectedPropValue = null;
        block4: for (char character : characters) {
            ++index;
            switch (character) {
                case '\\': {
                    escaped = true;
                    continue block4;
                }
                case '|': {
                    if (!escaped) {
                        propValue = instruction.substring(0, index);
                        expectedPropValue = index < characters.length - 1 ? instruction.substring(index + 1) : null;
                        break block4;
                    }
                }
                default: {
                    escaped = false;
                }
            }
        }
        if (propValue == null) {
            Output.print((String)"^error^ Invalid property instruction [ %s ].", (Object[])new Object[]{instruction});
            throw new SystemExit(1);
        }
        String contextFile = FileUtil.pathFromParts((String[])new String[]{configDirectory.getPath(), context + ".properties"});
        PropFile properties = PropFiles.load((String)contextFile, (boolean)false, (boolean)false);
        propValue = propValue.replaceAll("\\\\\\|", "|");
        if (expectedPropValue != null) {
            boolean modifiedAndNewTheSame;
            boolean bl = propValue == null ? !properties.contains(propName) : (modifiedAndNewTheSame = propValue.equals(properties.get(propName).value()));
            if (!properties.contains(propName) || !expectedPropValue.equals(properties.get(propName).value()) && !modifiedAndNewTheSame) {
                Output.print((String)"^warn^ Your ply has set ^b^%s^r^=\"%s\" (in context ^b^%s^r^) but ply wants to set it to ^b^%s^r^=\"%s\". Please manually resolve.", (Object[])new Object[]{propName, properties.get(propName).value(), context, propName, propValue});
                return 1;
            }
            if (modifiedAndNewTheSame) {
                return 0;
            }
        } else if (properties.contains(propName)) {
            Output.print((String)"^warn^ Your ply has set ^b^%s^r^=\"%s\" (in context ^b^%s^r^) but ply wants to set it to ^b^%s^r^=\"%s\". Please manually resolve.", (Object[])new Object[]{propName, properties.get(propName).value(), context, propName, propValue});
            return 1;
        }
        properties.set(propName, propValue);
        PropFiles.store((PropFile)properties, (String)contextFile, (boolean)true);
        return 0;
    }

    private int download(String instruction, File plyHomeDir) {
        URL file;
        int locationIndex;
        int n = locationIndex = instruction == null ? -1 : instruction.indexOf(" to ");
        if (locationIndex == -1 || instruction.length() <= locationIndex + 4) {
            Output.print((String)"^error^ Invalid download instruction [ %s ].", (Object[])new Object[]{instruction});
            throw new SystemExit(1);
        }
        String filePath = instruction.substring(0, locationIndex);
        String locationPath = instruction.substring(locationIndex + 4);
        if (filePath.isEmpty() || locationPath.isEmpty()) {
            Output.print((String)"^error^ Invalid download instruction [ %s ].", (Object[])new Object[]{instruction});
            throw new SystemExit(1);
        }
        try {
            file = new URL(filePath);
        }
        catch (MalformedURLException murle) {
            Output.print((Throwable)murle);
            throw new SystemExit(1, (Throwable)murle);
        }
        File location = FileUtil.fromParts((String[])new String[]{plyHomeDir.getPath(), locationPath});
        if (!FileUtil.copy((URL)file, (File)location)) {
            Output.print((String)"^error^ Could not download ^b^%s^r^ to ^b^%s^r^.", (Object[])new Object[]{filePath, locationPath});
            FileNotFoundException fnfe = new FileNotFoundException(String.format("Could not download %s", filePath));
            throw new SystemExit(1, (Throwable)fnfe);
        }
        return 0;
    }

    private File backup(File plyHomeDir, String currentVersion) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        File backDir = FileUtil.fromParts((String[])new String[]{tmpDir, "ply-" + currentVersion + ".backup"});
        if (!FileUtil.copyDir((File)plyHomeDir, (File)backDir)) {
            Output.print((String)"^error^ Could not create a backup of ply at ^b^%s^r^", (Object[])new Object[]{backDir.getPath()});
            throw new SystemExit(1);
        }
        return backDir;
    }

    private boolean restore(File plyHomeDir, File backup, String currentVersion) {
        Output.print((String)"Restoring ply to version ^b^%s^r^", (Object[])new Object[]{currentVersion});
        return FileUtil.copyDir((File)backup, (File)plyHomeDir);
    }

    private String getCurrentVersion() {
        String currentVersion = System.getProperty("ply.version");
        if (currentVersion == null || currentVersion.isEmpty()) {
            Output.print((String)"^error^ Could not determine the current ply version.", (Object[])new Object[0]);
            throw new SystemExit(1);
        }
        return currentVersion;
    }

    private Map<String, List<String>> downloadUpdateInstr(String updateUrl) throws SystemExit {
        HashMap<String, List<String>> updateInstructions = new HashMap<String, List<String>>();
        InputStream stream = null;
        try {
            String line;
            Output.print((String)"^info^ Downloading update instructions.", (Object[])new Object[0]);
            URL url = new URL(updateUrl);
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(1000);
            stream = connection.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            ArrayList<String> versions = new ArrayList<String>();
            ArrayList<String> instructions = null;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("VERSION=")) {
                    String version = line.substring("VERSION=".length());
                    versions.add(version);
                    instructions = new ArrayList<String>();
                    updateInstructions.put(version, instructions);
                    continue;
                }
                if (instructions == null) {
                    Output.print((String)"^error^ The update instructions file is in an invalid format. Cannot update ply.", (Object[])new Object[0]);
                    throw new SystemExit(1);
                }
                instructions.add(line);
            }
            updateInstructions.put("VERSIONS", versions);
        }
        catch (MalformedURLException murle) {
            Output.print((String)"^error^ Invalid url specified in ^b^ply.update.url^r^ property: %s", (Object[])new Object[]{updateUrl});
            Output.print((Throwable)murle);
            throw new SystemExit(1, (Throwable)murle);
        }
        catch (FileNotFoundException fnfe) {
            fnfe = new FileNotFoundException("Unable to download " + fnfe.getMessage());
            Output.print((Throwable)fnfe);
            throw new SystemExit(1, (Throwable)fnfe);
        }
        catch (IOException ioe) {
            Output.print((Throwable)ioe);
            throw new SystemExit(1, (Throwable)ioe);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    Output.print((Throwable)ioe);
                    throw new SystemExit(1, (Throwable)ioe);
                }
            }
        }
        return updateInstructions;
    }

    private Map<String, List<String>> validateUpdateInstructions(Map<String, List<String>> updateInstructions, String currentVersion) {
        if (updateInstructions == null || !updateInstructions.containsKey("VERSIONS")) {
            Output.print((String)"^error^ Could not download the update instructions file. Cannot update ply.", (Object[])new Object[0]);
            throw new SystemExit(1);
        }
        if (!updateInstructions.containsKey(currentVersion)) {
            Output.print((String)"^error^ Current ply version [ ^b^%s^r^ ] not supported for automatic update. Please manually update by reinstalling ply.", (Object[])new Object[]{currentVersion});
            throw new SystemExit(1);
        }
        return updateInstructions;
    }
}

