/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.cmd;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.OutputExt;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.cmd.Args;
import net.ocheyedan.ply.cmd.Command;
import net.ocheyedan.ply.cmd.config.Get;
import net.ocheyedan.ply.dep.RepositoryAtom;
import net.ocheyedan.ply.mvn.MavenPom;
import net.ocheyedan.ply.mvn.MavenPomParser;
import net.ocheyedan.ply.props.AdHoc;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.PropsExt;
import net.ocheyedan.ply.props.Scope;

public final class Init
extends Command {
    private static final Set<File> CLEANUP_FILES = new HashSet<File>();

    public Init(Args args) {
        super(args);
    }

    @Override
    public void run() {
        try {
            OutputExt.init("true", "true", "warn,info");
            Init.init(new File("."), this.args);
        }
        catch (PomNotFound pnf) {
            Output.print((String)"^ply^ ^error^ Specified maven pom file [ ^b^%s^r^ ] does not exist.", (Object[])new Object[]{pnf.pom});
            Init.cleanupAfterFailure();
            throw new SystemExit(1);
        }
        catch (NoRepositories nr) {
            Output.print((String)"^ply^ ^error^ No global repositories.  Reinstall ply or add a repository to the ^b^$PLY_HOME/config/repositories.properties^r^ file.", (Object[])new Object[0]);
            Init.cleanupAfterFailure();
            throw new SystemExit(1);
        }
        catch (PomParseException ppe) {
            Output.print((String)"^ply^ ^error^ Could not parse pom [ %s ].", (Object[])new Object[]{ppe.getMessage()});
            Output.print((String)"^ply^ ^error^ As this is a maven project be sure to have run ^b^mvn clean install^r^ before running ^b^ply init^r^.", (Object[])new Object[0]);
            Output.print((String)"^ply^ ^error^ Also ensure your local maven repository is accessible to ply: add line ^b^~/.m2/repository=maven^r^ to file ^b^$PLY_HOME/config/repositories.properties^r^", (Object[])new Object[0]);
            Init.cleanupAfterFailure();
            throw new SystemExit(1);
        }
        catch (InitException ie) {
            Output.print((String)"^ply^ ^error^ Could not initialize project [ %s ].", (Object[])new Object[]{ie.getCause() != null ? ie.getCause() : ""});
            Init.cleanupAfterFailure();
            throw new SystemExit(1);
        }
        catch (AlreadyInitialized ai) {
            Output.print((String)"^ply^ Current directory is already initialized.", (Object[])new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Init.cleanupAfterFailure();
            throw new SystemExit(1);
        }
    }

    private static void init(File from, Args args) throws AlreadyInitialized, PomNotFound {
        File ply = FileUtil.fromParts((String[])new String[]{from.getPath(), ".ply"});
        if (ply.exists()) {
            throw new AlreadyInitialized();
        }
        CLEANUP_FILES.add(ply);
        File configDir = FileUtil.fromParts((String[])new String[]{from.getPath(), ".ply", "config"});
        configDir.mkdirs();
        File mavenPom = Init.getMavenPom(from, args);
        if (mavenPom != null) {
            if (!mavenPom.exists()) {
                throw new PomNotFound(mavenPom.getPath());
            }
            List<RepositoryAtom> repositoryAtoms = Init.getRepositories();
            MavenPomParser parser = new MavenPomParser();
            PrintStream old = Init.setupTabOutput();
            MavenPom pom = null;
            for (RepositoryAtom repositoryAtom : repositoryAtoms) {
                try {
                    pom = parser.parsePom(mavenPom.getPath(), repositoryAtom);
                    if (pom == null) continue;
                    break;
                }
                catch (Exception exception) {
                }
            }
            Init.revertTabOutput(old);
            if (pom == null || !Init.createProperties(from, pom)) {
                throw new PomParseException(mavenPom.getPath());
            }
            if (pom.modules != null && !pom.modules.isEmpty()) {
                for (PropFile.Prop submodule : pom.modules.props()) {
                    File pomFile = FileUtil.fromParts((String[])new String[]{from.getPath(), submodule.name});
                    try {
                        if (pomFile.exists()) {
                            ArrayList<String> rawArgs = new ArrayList<String>(2);
                            rawArgs.add("init");
                            rawArgs.add("--from-pom=pom.xml");
                            Args pomArgs = new Args(rawArgs, args.adHocProps);
                            Init.init(pomFile, pomArgs);
                            continue;
                        }
                        Output.print((String)"^warn^ Module [ ^b^%s^r^ ] specified in %s but directory not found.", (Object[])new Object[]{submodule, mavenPom.getPath()});
                    }
                    catch (AlreadyInitialized rawArgs) {
                    }
                    catch (PomNotFound pnf) {
                        Output.print((String)"^warn^ Could not find ^b^%s^r^'s pom file. For init of sub-modules the pom must be named ^b^pom.xml^r^", (Object[])new Object[]{pomFile.getPath()});
                    }
                }
            }
        } else if (!Init.createDefaultProperties(from)) {
            throw new InitException(null);
        }
        Init.createDefaultDirectories(from);
        PropsExt.invalidateCaches(configDir);
        Output.print((String)"^ply^ Created the following project properties:", (Object[])new Object[0]);
        Output.print((String)"^ply^", (Object[])new Object[0]);
        PrintStream old = Init.setupTabOutput();
        Get get = new Get(null);
        get.print(configDir, null, Scope.Default, null, false);
        Init.revertTabOutput(old);
        String projectName = Props.get((String)"name", (Context)Context.named((String)"project"), (Scope)Scope.Default, (File)configDir).value();
        Output.print((String)"^ply^", (Object[])new Object[0]);
        Output.print((String)"^ply^ Project ^b^%s^r^ initialized successfully.", (Object[])new Object[]{projectName});
    }

    private static File getMavenPom(File from, Args args) {
        if (args.args.size() > 1 && args.args.get(1).startsWith("--from-pom=")) {
            return FileUtil.fromParts((String[])new String[]{from.getPath(), args.args.get(1).substring("--from-pom=".length())});
        }
        if (Init.isHeadless()) {
            return null;
        }
        File[] poms = Init.findPomFiles(from);
        if (poms != null && poms.length > 0) {
            String options;
            if (poms.length == 1) {
                options = "[Y/n]";
                Output.printNoLine((String)"^ply^ Found a pom file [ ^b^%s^r^ ], parse configuration from it %s ", (Object[])new Object[]{poms[0].getPath(), options});
            } else {
                options = "[num/n]";
                Output.print((String)"^ply^ Found pom files:", (Object[])new Object[0]);
                int choice = 1;
                for (File pom : poms) {
                    Output.print((String)"^ply^ [^b^%d^r^] %s", (Object[])new Object[]{choice++, pom.getPath()});
                }
                Output.printNoLine((String)"^ply^ parse configuration from %s? ", (Object[])new Object[]{options});
            }
            try {
                while (true) {
                    CharBuffer buffer = CharBuffer.allocate(Integer.valueOf(poms.length).toString().length() + 1);
                    new InputStreamReader(System.in).read(buffer);
                    buffer.rewind();
                    String answer = buffer.toString().trim();
                    Integer answerAsNumber = null;
                    try {
                        answerAsNumber = Integer.parseInt(answer);
                    }
                    catch (NumberFormatException nfe) {
                        answerAsNumber = null;
                    }
                    if (poms.length == 1 && answer.equalsIgnoreCase("y")) {
                        return poms[0];
                    }
                    if (poms.length > 1 && answerAsNumber != null) {
                        int index = answerAsNumber - 1;
                        if (index >= 0 && index < poms.length) {
                            return poms[index];
                        }
                        Output.printNoLine((String)"^ply^ ^red^invalid number^r^; must be between %d and %d, parse configuration %s ", (Object[])new Object[]{1, poms.length, options});
                        continue;
                    }
                    if (!answer.equalsIgnoreCase("n")) {
                        Output.printNoLine((String)"^ply^ ^red^invalid option^r^, parse configuration %s ", (Object[])new Object[]{options});
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                throw new InitException(ioe);
            }
        }
        return null;
    }

    private static void cleanupAfterFailure() {
        for (File file : CLEANUP_FILES) {
            FileUtil.delete((File)file);
        }
    }

    private static boolean isHeadless() {
        String plyPropertiesPath = FileUtil.pathFromParts((String[])new String[]{PlyUtil.SYSTEM_CONFIG_DIR.getPath(), "ply.properties"});
        PropFile plySystemProps = PropFiles.load((String)plyPropertiesPath, (boolean)false, (boolean)false);
        return "true".equalsIgnoreCase(plySystemProps.get("headless").value());
    }

    private static boolean createProperties(File from, MavenPom pom) {
        HashMap<String, PropFile> fileToProps = new HashMap<String, PropFile>(3, 1.0f);
        PropFile projectProps = new PropFile(Context.named((String)"project"), PropFile.Loc.Local);
        projectProps.add("namespace", pom.groupId);
        projectProps.add("name", pom.artifactId);
        projectProps.add("version", pom.version);
        if (pom.packaging != null && !"jar".equals(pom.packaging) && !"pom".equals(pom.packaging)) {
            projectProps.add("packaging", pom.packaging);
        }
        if (pom.buildDirectory != null) {
            projectProps.add("build.dir", pom.buildDirectory);
        }
        if (pom.buildSourceDirectory != null) {
            projectProps.add("src.dir", pom.buildSourceDirectory);
        }
        if (pom.buildFinalName != null) {
            projectProps.add("artifact.name", pom.buildFinalName);
        }
        fileToProps.put(FileUtil.pathFromParts((String[])new String[]{from.getPath(), ".ply", "config", "project.properties"}), projectProps);
        if (pom.dependencies != null && !pom.dependencies.isEmpty()) {
            fileToProps.put(FileUtil.pathFromParts((String[])new String[]{from.getPath(), ".ply", "config", "dependencies.properties"}), pom.dependencies);
        }
        if (pom.testDependencies != null && !pom.testDependencies.isEmpty()) {
            fileToProps.put(FileUtil.pathFromParts((String[])new String[]{from.getPath(), ".ply", "config", "dependencies.test.properties"}), pom.testDependencies);
        }
        if (pom.repositories != null && !pom.repositories.isEmpty()) {
            fileToProps.put(FileUtil.pathFromParts((String[])new String[]{from.getPath(), ".ply", "config", "repositories.properties"}), pom.repositories);
        }
        if (pom.buildOutputDirectory != null) {
            PropFile compilerProps = new PropFile(Context.named((String)"compiler"), PropFile.Loc.Local);
            compilerProps.add("build.path", pom.buildOutputDirectory);
            fileToProps.put(FileUtil.pathFromParts((String[])new String[]{from.getPath(), ".ply", "config", "compiler.properties"}), compilerProps);
        }
        if (pom.buildTestOutputDirectory != null) {
            PropFile compilerTestProps = new PropFile(Context.named((String)"compiler"), Scope.named((String)"test"), PropFile.Loc.Local);
            compilerTestProps.add("build.path", pom.buildTestOutputDirectory);
            fileToProps.put(FileUtil.pathFromParts((String[])new String[]{from.getPath(), ".ply", "config", "compiler.test.properties"}), compilerTestProps);
        }
        if (pom.buildTestSourceDirectory != null) {
            PropFile projectTestProps = new PropFile(Context.named((String)"project"), Scope.named((String)"test"), PropFile.Loc.Local);
            projectTestProps.add("src.dir", pom.buildTestSourceDirectory);
            fileToProps.put(FileUtil.pathFromParts((String[])new String[]{from.getPath(), ".ply", "config", "project.test.properties"}), projectTestProps);
        }
        if (pom.modules != null && !pom.modules.isEmpty()) {
            fileToProps.put(FileUtil.pathFromParts((String[])new String[]{from.getPath(), ".ply", "config", "submodules.properties"}), pom.modules);
        }
        return Init.createProperties(fileToProps);
    }

    private static void createDefaultDirectories(File baseDir) {
        boolean createdResTest;
        File configDir = FileUtil.fromParts((String[])new String[]{baseDir.getPath(), ".ply", "config"});
        File projectPropsFile = FileUtil.fromParts((String[])new String[]{configDir.getPath(), "project.properties"});
        File projectTestPropsFile = FileUtil.fromParts((String[])new String[]{configDir.getPath(), "project.test.properties"});
        PropFileChain projectProps = Props.get((Context)Context.named((String)"project"), (Scope)Scope.Default, (File)projectPropsFile, (boolean)true);
        PropFileChain projectTestProps = Props.get((Context)Context.named((String)"project"), (Scope)Scope.named((String)"test"), (File)projectTestPropsFile, (boolean)true);
        String srcDirPath = projectProps.get("src.dir").value();
        String resDirPath = projectProps.get("res.dir").value();
        String srcTestDirPath = projectTestProps.get("src.dir").value();
        String resTestDirPath = projectTestProps.get("res.dir").value();
        File srcDir = FileUtil.fromParts((String[])new String[]{baseDir.getPath(), srcDirPath});
        File resDir = FileUtil.fromParts((String[])new String[]{baseDir.getPath(), resDirPath});
        File srcTestDir = FileUtil.fromParts((String[])new String[]{baseDir.getPath(), srcTestDirPath});
        File resTestDir = FileUtil.fromParts((String[])new String[]{baseDir.getPath(), resTestDirPath});
        boolean createdSrc = !srcDirPath.isEmpty() && (srcDir.exists() || srcDir.mkdirs());
        boolean createdRes = !resDirPath.isEmpty() && (resDir.exists() || resDir.mkdirs());
        boolean createdSrcTest = !srcTestDirPath.isEmpty() && (srcTestDir.exists() || srcTestDir.mkdirs());
        boolean bl = createdResTest = !resTestDirPath.isEmpty() && (resTestDir.exists() || resTestDir.mkdirs());
        if (!(createdSrc && createdRes && createdSrcTest && createdResTest)) {
            Output.print((String)"^ply^^warn^ Could not create project directories.", (Object[])new Object[0]);
        }
    }

    private static boolean createDefaultProperties(File from) {
        Map adHocProps = AdHoc.get();
        HashMap<String, PropFile> projectMap = new HashMap<String, PropFile>(3, 1.0f);
        for (Scope scope : adHocProps.keySet()) {
            Map contexts = (Map)adHocProps.get(scope);
            for (Context context : contexts.keySet()) {
                PropFile adHocPropFile = (PropFile)contexts.get(context);
                if (adHocPropFile.isEmpty()) continue;
                String path = FileUtil.pathFromParts((String[])new String[]{from.getPath(), ".ply", "config", PropFiles.getFileName((PropFile)adHocPropFile)});
                projectMap.put(path, adHocPropFile);
            }
        }
        String projectKey = FileUtil.pathFromParts((String[])new String[]{from.getPath(), ".ply", "config", "project.properties"});
        try {
            PropFile projectProps;
            int lastPathIndex;
            File projectDirectory = new File(".");
            String path = projectDirectory.getCanonicalPath();
            if (path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - 1);
            }
            if ((lastPathIndex = path.lastIndexOf(File.separator)) != -1) {
                path = path.substring(lastPathIndex + 1);
            }
            if ((projectProps = (PropFile)projectMap.get(projectKey)) == null) {
                projectProps = new PropFile(Context.named((String)"project"), Scope.Default, PropFile.Loc.Local);
                projectMap.put(projectKey, projectProps);
            }
            if (!projectProps.contains("namespace")) {
                projectProps.add("namespace", path);
            }
            if (!projectProps.contains("name")) {
                projectProps.add("name", path);
            }
            if (!projectProps.contains("version")) {
                projectProps.add("version", "1.0");
            }
            return Init.createProperties(projectMap);
        }
        catch (IOException ioe) {
            Output.print((String)"^error^ could not create the local project's properties files.", (Object[])new Object[0]);
            Output.print((Throwable)ioe);
            return false;
        }
    }

    private static boolean createProperties(Map<String, PropFile> fileToProps) {
        for (String filePath : fileToProps.keySet()) {
            PropFile localProperties = fileToProps.get(filePath);
            if (PropFiles.store((PropFile)localProperties, (String)filePath, (boolean)true)) continue;
            return false;
        }
        return true;
    }

    private static PrintStream setupTabOutput() {
        final PrintStream old = System.out;
        PrintStream tabbed = new PrintStream((OutputStream)new ByteArrayOutputStream()){
            final Object[] nil;
            {
                super(x0);
                this.nil = new Object[0];
            }

            @Override
            public void print(String out) {
                old.print(String.format("%s %s", OutputExt.resolve("^ply^", this.nil), out));
            }

            @Override
            public void println(String out) {
                old.println(String.format("%s %s", OutputExt.resolve("^ply^", this.nil), out));
            }
        };
        System.setOut(tabbed);
        return old;
    }

    private static void revertTabOutput(PrintStream old) {
        System.setOut(old);
    }

    private static File[] findPomFiles(File from) {
        return from.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("pom.xml");
            }
        });
    }

    private static List<RepositoryAtom> getRepositories() throws NoRepositories {
        ArrayList<RepositoryAtom> repositories = new ArrayList<RepositoryAtom>();
        String localRepoPath = Init.getSystemLocalRepo();
        RepositoryAtom local = RepositoryAtom.parse((String)localRepoPath);
        if (local != null) {
            repositories.add(local);
        }
        Collection<PropFile.Prop> repositoryProperties = Init.getSystemRepositories();
        for (PropFile.Prop prop : repositoryProperties) {
            RepositoryAtom repo = RepositoryAtom.parse((String)RepositoryAtom.atomFromProp((PropFile.Prop)prop));
            if (repo == null) continue;
            repositories.add(repo);
        }
        if (repositories.isEmpty()) {
            throw new NoRepositories();
        }
        Collections.sort(repositories, RepositoryAtom.LOCAL_COMPARATOR);
        return repositories;
    }

    private static String getSystemLocalRepo() {
        PropFile depmngr = PropFiles.load((String)FileUtil.pathFromParts((String[])new String[]{PlyUtil.SYSTEM_CONFIG_DIR.getPath(), "depmngr.properties"}), (boolean)false, (boolean)true);
        if (depmngr == null) {
            return null;
        }
        return depmngr.get("localRepo").value();
    }

    private static Collection<PropFile.Prop> getSystemRepositories() {
        String systemRepositoriesPath = FileUtil.pathFromParts((String[])new String[]{PlyUtil.SYSTEM_CONFIG_DIR.getPath(), "repositories.properties"});
        PropFile systemRepositoriesProps = PropFiles.load((String)systemRepositoriesPath, (boolean)false, (boolean)false);
        ArrayList<PropFile.Prop> props = new ArrayList<PropFile.Prop>();
        for (PropFile.Prop systemRepoProp : systemRepositoriesProps.props()) {
            props.add(systemRepoProp);
        }
        return props;
    }

    private static class NoRepositories
    extends RuntimeException {
        private NoRepositories() {
        }
    }

    private static class InitException
    extends RuntimeException {
        private InitException(Throwable cause) {
            super(cause);
        }
    }

    private static class PomParseException
    extends RuntimeException {
        private PomParseException(String message) {
            super(message);
        }
    }

    private static class PomNotFound
    extends RuntimeException {
        final String pom;

        private PomNotFound(String pom) {
            this.pom = pom;
        }
    }

    private static class AlreadyInitialized
    extends RuntimeException {
        private AlreadyInitialized() {
        }
    }
}

