/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.cmd;

import java.util.ArrayList;
import java.util.Collections;
import net.ocheyedan.ply.Iter;
import net.ocheyedan.ply.cmd.Args;
import net.ocheyedan.ply.cmd.Command;
import net.ocheyedan.ply.cmd.Init;
import net.ocheyedan.ply.cmd.Update;
import net.ocheyedan.ply.cmd.Usage;
import net.ocheyedan.ply.cmd.Version;
import net.ocheyedan.ply.cmd.build.Build;
import net.ocheyedan.ply.cmd.config.Append;
import net.ocheyedan.ply.cmd.config.Describe;
import net.ocheyedan.ply.cmd.config.Get;
import net.ocheyedan.ply.cmd.config.GetAll;
import net.ocheyedan.ply.cmd.config.Prepend;
import net.ocheyedan.ply.cmd.config.Remove;
import net.ocheyedan.ply.cmd.config.Set;

public final class CommandLineParser {
    static final Args NIL = new Args(Collections.<String>emptyList(), Collections.<String>emptyList());

    public static Command parse(String[] args) {
        if (args == null || args.length < 1 || "--usage".equals(args[0]) || "--help".equals(args[0])) {
            return new Usage(CommandLineParser.parseArgs((Iter.Sized<String>)Iter.sized((Object[])args)));
        }
        if ("--version".equals(args[0]) || "-v".equals(args[0]) || "-version".equals(args[0])) {
            return new Version(CommandLineParser.parseArgs((Iter.Sized<String>)Iter.sized((Object[])args)));
        }
        if ("init".equals(args[0])) {
            return new Init(CommandLineParser.parseArgs((Iter.Sized<String>)Iter.sized((Object[])args)));
        }
        if ("get".equals(args[0]) || args[0].endsWith(":get")) {
            return new Get(CommandLineParser.parseArgs((Iter.Sized<String>)Iter.sized((Object[])args)));
        }
        if ("get-all".equals(args[0]) || args[0].endsWith(":get-all")) {
            return new GetAll(CommandLineParser.parseArgs((Iter.Sized<String>)Iter.sized((Object[])args)));
        }
        if ("set".equals(args[0]) || args[0].endsWith(":set")) {
            return new Set(CommandLineParser.parseArgs((Iter.Sized<String>)Iter.sized((Object[])args)));
        }
        if ("rm".equals(args[0]) || args[0].endsWith(":rm")) {
            return new Remove(CommandLineParser.parseArgs((Iter.Sized<String>)Iter.sized((Object[])args)));
        }
        if ("append".equals(args[0]) || args[0].endsWith(":append")) {
            return new Append(CommandLineParser.parseArgs((Iter.Sized<String>)Iter.sized((Object[])args)));
        }
        if ("prepend".equals(args[0]) || args[0].endsWith(":prepend")) {
            return new Prepend(CommandLineParser.parseArgs((Iter.Sized<String>)Iter.sized((Object[])args)));
        }
        if ("update".equals(args[0]) || args[0].endsWith(":update")) {
            return new Update(CommandLineParser.parseArgs((Iter.Sized<String>)Iter.sized((Object[])args)));
        }
        if ("describe".equals(args[0]) || args[0].endsWith(":describe")) {
            return new Describe(CommandLineParser.parseArgs((Iter.Sized<String>)Iter.sized((Object[])args)));
        }
        return new Build(CommandLineParser.parseArgs((Iter.Sized<String>)Iter.sized((Object[])args)));
    }

    public static Args parseArgs(Iter.Sized<String> clArgs) {
        if (clArgs == null || clArgs.size() < 1) {
            return NIL;
        }
        ArrayList<String> args = new ArrayList<String>(clArgs.size());
        ArrayList<String> adHocProps = new ArrayList<String>(2);
        for (String arg : clArgs) {
            if (arg.startsWith("-P")) {
                if (arg.length() <= 2) continue;
                adHocProps.add(arg.substring(2));
                continue;
            }
            args.add(arg);
        }
        return new Args(args, adHocProps);
    }
}

