# Contributing to Fluentd

We'd love your contribution. Here are the guidelines!

## Got a question or problem?

RESOURCES of [Official site](http://www.fluentd.org/) and [Fluentd documentation](http://docs.fluentd.org/) may help you.

If you have further questions about Fluentd and plugins, please direct these to [Mailing List](https://groups.google.com/forum/#!forum/fluentd).

Don't use Github issue for asking questions.
Github issue is mainly for submitting a bug report or feature request. See below.

## Found a bug?

If you find a bug of Fluentd or a mistake in the documentation, you can help us by
submitting an issue to Fluentd. Even better you can submit a Pull Request with a fix.

* **Fluentd**: Use [fluentd](https://github.com/fluent/fluentd) repository.
* **Documentation**: Use [fluentd-docs](https://github.com/fluent/fluentd-docs) repository.

If you find a bug of 3rd party plugins, please submit an issue to each plugin repository.

## Patch Guidelines

Here are some things that would increase a chance that your patch is accepted:

* Write tests.
* Run tests before send Pull Request by `bundle exec rake test`
* Write a [good commit message](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html).

There are some patches which are hard to write tests, e.g. process handling, concurrency issue or etc.
In such case, please don't hesitate to submit a Pull Request.
We can discuss how to manage a patch on Pull Request :)
