<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output omit-xml-declaration="no"/>
	<xsl:template match="toc">		
		<toc label="Nexaweb Studio User Guide">			
			<xsl:apply-templates select="tocitem"/> 
		</toc>		
	</xsl:template>
	<xsl:template match="tocitem">
		<topic>
			<xsl:attribute name="label">
				<xsl:value-of select="@text" />
			</xsl:attribute> 	
			<xsl:if test="@target != ''">
				<xsl:attribute name="href">
					<xsl:value-of select="concat('docs/studio_rtf/', @target, '.htm')" />
				</xsl:attribute> 
			</xsl:if>					
			<xsl:apply-templates select="tocitem"/> 
		</topic>		
	</xsl:template>
</xsl:stylesheet>
