<?php
require_once("db.php");

//functions that require a bit more processing than just grabbing/updating data in the db

class system {

	static function get_domain() {
		return (($_SERVER['HTTPS'] != '') && ($_SERVER['https'] != 'off') ? 'https://' : 'http://').$_SERVER['SERVER_NAME'];
	}
	
	static function get_directory() {
		return str_replace('/','',dirname($_SERVER['REQUEST_URI']));
	}

	static function get_base_location() {
		$script_location = dirname($_SERVER['SCRIPT_FILENAME']);
		$directory = self::get_directory();
		if (substr($script_location, 0-strlen($directory)) == $directory) {
			return substr($script_location,0,-strlen($directory));
		} else {
			return $script_location;
		}
	}

	static function create_test($name) {
		$base_location = self::get_base_location();
		if (file_exists($base_location.$name)) {
			return false;
		}
		if (count(db::get_test_by_name($name)) != 0) {
			return false;
		}
		
		mkdir($base_location.$name);
		file_put_contents($base_location.$name."/index.php","<?php\ninclude '".dirname(__FILE__)."/base.php';");
		return db::new_test($name);
		//TODO:
		// Create the directory with the link to base
	}
	
	static function delete_test($id) {
		$test = db::get_test($id);
		$base_location = self::get_base_location();
		unlink($base_location.$test[TEST_NAME]."/index.php");
		rmdir($base_location.$test[TEST_NAME]);
		db::delete_test($id);
	}
	
	static function get_tests_list() {
		$tests = db::get_tests();
		
		foreach($tests as &$test) {
			$variants = db::get_variants($test[TEST_ID]);
			$hits = 0;
			$conversions = 0;
			foreach($variants as $variant) {
				$hits += $variant[VARIANT_HITS];
				$conversions += $variant[VARIANT_CONV];
			}
			$test[TEST_HITS] = $hits;
			$test[TEST_CONV] = $conversions;
			$test[TEST_NUM_VARIANTS] = count($variants);
		}
		
		return $tests;
	}
	
	static function check_admin_password($password) {
		return (md5($password) == trim(file_get_contents("password.txt")));
	}
	
	static function set_admin_password($password) {
		file_put_contents("password.txt",md5($password));
	}
}

