<?php
session_start();
ini_set('display_errors', 0);
error_reporting(0);

if (!isset($_SESSION["is_logged_in"])) {
	exit();
}

require_once("system.php");

header("Content-type: text/csv");  
header("Cache-Control: no-store, no-cache");  
header('Content-Disposition: attachment; filename="redirects-'.date('Y-m-d').'.csv"');

function write_csv_line($arr) {
	echo '"'.implode($arr,'","').'"'."\n";
}

write_csv_line(array('Test Name','Variant URL','Visitors Funnelled','Visitors Converted'));

$tests = system::get_tests_list();

foreach($tests as $test) {
	$variants = db::get_variants($test[TEST_ID]);
	foreach($variants as $variant) {
		$line = array(
			htmlspecialchars($test[TEST_NAME]), 
			htmlspecialchars($variant[VARIANT_URL]), 
			htmlspecialchars($variant[VARIANT_HITS]),
			htmlspecialchars($variant[VARIANT_CONV])
		);
	write_csv_line($line);
	}
}
