<?php
require_once('flatfile.php');

define('TESTS_DB', 'tests.txt');
define('TEST_ID',0);
define('TEST_NAME',1);
define('TEST_AUTO_CONV',2);

//these two shouldn't be used to actually store data,
//they are used for convenience elsewhere
define('TEST_HITS',3);
define('TEST_CONV',4);
define('TEST_NUM_VARIANTS',5);

define('VARIANTS_DB', 'variants.txt');
define('VARIANT_ID',0);
define('VARIANT_TEST_ID',1);
define('VARIANT_URL',2);
define('VARIANT_HITS',3);
define('VARIANT_CONV',4);

class db {
	private static $db;
	
	
	static function init() {
		self::$db = new Flatfile();
		self::$db->datadir = dirname(__FILE__).'/';
	}
	
	/*
	static function query($sql, $params=array(), $fetch=true) {
		$stmt = self::$db->prepare($sql);
		if (!$stmt) {
			echo "Error preparing query: ".print_r(self::$db->errorInfo(), true);
			exit();
		}
		if (!$stmt->execute($params)) {
			echo "Error executing query: ".print_r(self::$db->errorInfo(), true);
			exit();
		}

		if ($fetch)
			return $stmt->fetchAll();
		else
			return $stmt;
	}


	//Checks that the result set has a single result and returns just that,
	//Returns false otherwise
	static function single_result($rs) {
		if (count($rs) == 1) {
			return $rs[0];
		} else {
			return false;
		}
	}
	
	static function last_insert_id() {
		return self::$db->lastInsertId();
	}

	static function create_db() {
		$sql = '
			CREATE TABLE tests (
				"id" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
				"name" TEXT NOT NULL,
				"conversions_auto" INTEGER NOT NULL DEFAULT (0)
			);';
		self::query($sql);

		$sql = '
			CREATE TABLE variants (
				"id" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
				"name" TEXT NOT NULL,
				"url" TEXT NOT NULL,
				"test_id" INTEGER,
				"hits" INTEGER NOT NULL DEFAULT (0)
				"conversions" INTEGER NOT NULL DEFAULT (0)
			);';
		self::query($sql);
	}
	*/
	
	static function new_test($name, $conv=0) {
		$test[TEST_ID] = 0;
		$test[TEST_NAME]= $name;
		$test[TEST_AUTO_CONV] = $conv;
		return self::$db->insertWithAutoId(TESTS_DB, TEST_ID, $test);
		
		//$sql = "insert into tests (name) values (?)";
		//self::query($sql,array($name));
		//return self::last_insert_id();
	}
	
	static function get_tests() {
		return self::$db->selectAll(TESTS_DB);
	}
	
	static function update_auto_conv($test_id, $conv) {
		self::$db->updateSetWhere(TESTS_DB, 
							array(TEST_AUTO_CONV => $conv), 
							new SimpleWhereClause(TEST_ID,'=',$test_id));
	}
	
	static function get_test($id) {
		return self::$db->selectUnique(TESTS_DB, TEST_ID, $id);
	}
	
	static function get_test_by_name($name) {
		return self::$db->selectUnique(TESTS_DB, TEST_NAME, $name);
		
		//$res = self::query("select * from tests where name = ?");
		//return self::single_result($res);
	}
	
	static function add_variant($url,$test_id) {
		$variant[VARIANT_ID] = 0;
		$variant[VARIANT_TEST_ID] = $test_id;
		$variant[VARIANT_URL] = $url;
		$variant[VARIANT_HITS] = 0;
		$variant[VARIANT_CONV] = 0;
		return self::$db->insertWithAutoId(VARIANTS_DB, VARIANT_ID, $variant);
		
		//$sql = "insert into variants (name, url, test_id) values (?,?,?)";
		//self::query($sql, array($name,$url,$test_id));
		//return self::last_insert_id();*/
	}
	
	static function get_variant($variant_id) {
		return self::$db->selectUnique(VARIANTS_DB, VARIANT_ID, $variant_id);
		
		//$sql = "select * from variants where id = ?";
		//return self::single_result(self::query($sql, array($variant_id)));
	}
	
	static function get_variants($test_id) {
		return self::$db->selectWhere(VARIANTS_DB, new SimpleWhereClause(VARIANT_TEST_ID, '=', $test_id));
		
		// $sql = "select * from variants where test_id = ?";
		// return self::query($sql, array($test_id));
	}

	static function get_random_variant($test_id) {
		$variants = self::get_variants($test_id);
		return $variants[array_rand($variants)];
	}
	
	static function delete_variant($variant_id) {
		self::$db->deleteWhere(VARIANTS_DB, new SimpleWhereClause(VARIANT_ID, '=', $variant_id));
	}
	
	static function variant_hit($variant_id) {
		$variant = self::get_variant($variant_id);
		self::$db->updateSetWhere(VARIANTS_DB, 
						array(VARIANT_HITS => ($variant[VARIANT_HITS]+1)), 
						new SimpleWhereClause(VARIANT_ID, '=', $variant_id));
		
		//$sql = "update variants set hits = hits + 1 where id = ?";
		//self::query($sql, array($variant_id));
	}
	
	static function conversion_hit($variant_id) {
		$variant = self::get_variant($variant_id);
		self::$db->updateSetWhere(VARIANTS_DB, 
						array(VARIANT_CONV => ($variant[VARIANT_CONV]+1)), 
						new SimpleWhereClause(VARIANT_ID, '=', $variant_id));
		//$sql = "update variants set conversions = conversions + 1 where id = ?";
		//self::query($sql, array($variant_id));
	}
	
	static function delete_test($test_id) {
		self::$db->deleteWhere(VARIANTS_DB, new SimpleWhereClause(VARIANT_TEST_ID, '=', $test_id));
		self::$db->deleteWhere(TESTS_DB, new SimpleWhereClause(TEST_ID, '=', $test_id));		

		//self::query("delete from variants where test_id = ?", array($test_id));
		//self::query("delete from tests where id = ?", array($test_id));
	}
	
	static function reset_hits($test_id) {
		self::$db->updateSetWhere(VARIANTS_DB, 
				array(VARIANT_HITS => 0, VARIANT_CONV => 0), 
				new SimpleWhereClause(VARIANT_TEST_ID, '=', $test_id));
	}
	
	static function get_variants_with_conversions($test_id, $number_of_conversions) {
		$compClause = new AndWhereClause();
		$compClause->add(new SimpleWhereClause(VARIANT_TEST_ID, '=', $test_id));
		$compClause->add(new SimpleWhereClause(VARIANT_CONV, '>', $number_of_conversions-1));
		return self::$db->selectWhere(VARIANTS_DB, $compClause);
	}
}

db::init();
