<?php
require_once("db.php");

//deal with cross domain cookie stuff
header('P3P:CP="IDC DSP COR ADM DEVi TAIi PSA PSD IVAi IVDi CONi HIS OUR IND CNT"');
ini_set('display_errors', 0);
//error_reporting(0);

//strip the slashes out of the uri, to get the original test name
$test_name = str_replace('/','', $_SERVER["REQUEST_URI"]);
$test = db::get_test_by_name($test_name);
if ($test[TEST_AUTO_CONV] > 0) {
	$variants = db::get_variants_with_conversions($test[TEST_ID], $test[TEST_AUTO_CONV]);
	if (count($variants) > 0) {
		//we've hit the auto select conversion so set the cookie and do the redirect
		db::variant_hit($variants[0][VARIANT_ID]);
		setcookie("mv_variant_id", $variants[0][VARIANT_ID],time()+60*60*24*30,'/');
		header("Location: ".$variants[0][VARIANT_URL]);
		exit();
	}
}

if (isset($_COOKIE["mv_variant_id"])) {
	$variant = db::get_variant($_COOKIE["mv_variant_id"]);

	if ($variant[VARIANT_TEST_ID] == $test[TEST_ID]) {
		//if this variant is for this test then do the redirect without updating anything
		//we already clicked this link.
		header("Location: ".$variant[VARIANT_URL]);
		exit();
	}
}

//delete the conversion tracking cookie by setting its time to be in the past
setcookie ("mv_variant_conv", "", time() - 3600);

$variant = db::get_random_variant($test[TEST_ID]);
setcookie("mv_variant_id", $variant[VARIANT_ID],time()+60*60*24*30,'/');
db::variant_hit($variant[VARIANT_ID]);

header("Location: ".$variant[VARIANT_URL]);
