<?php
session_start();
ini_set('display_errors', 0);
//error_reporting(0);
require_once("system.php");
?>
<html>
<head>
<style type='text/css'>
	html, body, img {
		border:none;
		padding:0;
		margin:0;
	}
	#menu {
		width:200px;
		height:100%;
		float:left;
		background-color:#aaa;
		margin:none;
		padding:none;
	}
	#main {
		float:left;
		width:700px;
	}
	.menu-item {
		display:block;
	}
	
	th, td {
		padding: 3px 8px;
		text-align:left;
	}
	
	.top {
		border-top: 1px solid #aaa;
	}
	
	table {
		border-collapse:collapse;
	}
	
	.message {
		font-size: 0.9em;
		color:#800;
	}
</style>
</head>
<body>
<?php

if (isset($_GET['page']) && $_GET['page'] == 'logout') {
	unset($_SESSION['is_logged_in']);
}

// attempt login:
if (isset($_POST["username"])) {
	if (($_POST["username"] == "admin") && (system::check_admin_password($_POST["password"]))) {
		$_SESSION["is_logged_in"] = true;
	} else {
		echo "<p class='message'>Invalid login</p>";
	}
}
// if we're not logged in then
if (!isset($_SESSION["is_logged_in"])) {
	//show login form here
	?>
	<form action="admin.php" method="post">
		<table>
			<tr><td>Username</td><td><input type='text' name='username' /></td></tr>
			<tr><td>Password</td><td><input type='password' name='password' /></td></tr>
			<tr><td>&nbsp;</td><td><input type='submit' value='login' /></td></tr>
		</table>
	</form>

	<?
} else {
	//the following pages are if we're logged in
?>

	<div id="menu">
		<a class="menu-item" href="admin.php?page=add">Create new test</a>
		<a class="menu-item" href="admin.php?page=list">List Tests</a>
		<a class="menu-item" href="getcsv.php">Download stats csv</a>
		<a class="menu-item" href="admin.php?page=account">Change password</a>
		<a class="menu-item" href="admin.php?page=tracking">Conversion code</a>
		<a class="menu-item" href="admin.php?page=logout">Logout</a>
	</div>
	<div id="main">
<?php

	$action = $_POST['action'];
	switch ($action) {
		case 'new_test':
			$test_name = $_POST["test_name"];
			if (!preg_match('/^[a-zA-Z0-9_][a-zA-Z0-9\\-_]*$/',$_POST["test_name"])) {
				$page = 'add';
				$error = 'Invalid test name. Name must be contain only letters, numbers, dash(-) and underscore(_) and cannot start with a dash';
			} else {
				$id = system::create_test($test_name);
				if ($id === false) {
					$page = 'add';
					$error = 'Could not add test. Make sure the test and directory does not already exist';
				} else {
					$page = 'view';
					$_GET["id"] = $id;
				}
			}
		break;
		
		case 'reset_test':
			db::reset_hits($_POST["id"]);
			$page = 'view';
			$_GET["id"] = $_POST["id"];
		break;
		
		case 'delete_test':
			system::delete_test($_POST["id"]);
			$page = 'list';
		break;
		
		case 'set_auto_conv':
			db::update_auto_conv($_POST["id"], $_POST["conversions"]);
			$page = 'view';
			$_GET["id"] = $_POST["id"];
		break;
		
		case 'add_variant':
			db::add_variant($_POST["variant_url"],$_POST["id"]);
			$page = 'view';
			$_GET["id"] = $_POST["id"];
		break;
		
		case 'delete_variant':
			db::delete_variant($_POST["variant_id"]);
			$page = 'view';
			$_GET["id"] = $_POST["id"];
		break;
		
	}


	if (!isset($page)) {
		// if we haven't set a page due to the action above yet
		$page = isset($_GET["page"]) ? $_GET["page"] : 'add';
	}

	switch ($page) {
		case 'add':
			if (isset($error)) { echo "<p class='message'>$error</p>"; }
			?>
			<form action="admin.php" method="post">
				<input type='hidden' name='action' value='new_test' />
				<table>
				<tr>
					<td>Test name</td>
					<td>&nbsp;</td>
				</tr>
				<tr>
					<td><input type="text" name="test_name" /></td>
					<td><input type="submit" value="Create test" /></td>
				</tr>
				</table>
			</form>
			<?php
		break;

		case 'list':
			$tests = system::get_tests_list();
			
			
			echo "<table>";
			echo "<tr><th style='width:100px;'>Link</th><th style='width:50px'>Hits</th><th style='width:50px'>Conversions</th><th style='width:100px'>Edit/View</th><th style='width:100px'>Delete</th></tr>";
			
			foreach($tests as $test) {
				echo "<tr>";
				echo "<td class='top'><a href='".system::get_domain()."/".htmlspecialchars($test[TEST_NAME])."'>".htmlspecialchars($test[TEST_NAME])."</a></td>";
				echo "<td class='top'>".$test[TEST_HITS]."</td>";
				echo "<td class='top'>".$test[TEST_CONV]."</td>";
				echo "<td class='top'>";
				?>
				<a href="admin.php?page=view&id=<?php echo $test[TEST_ID]; ?>">Edit/View</a>
				</td>
				<td class='top'>
				<form action='admin.php' method='post'>
					<input type='hidden' name='action' value='delete_test' />
					<input type='hidden' name='id' value='<?php echo $test[TEST_ID] ?>' />
					<input type='submit' value='Delete' onclick='return confirm("Are you sure?")' />
				</form>
				</td>
				<?php
				echo "</tr>";
			}
			echo "</table>";
		break;
		
		case 'view':
			$test = db::get_test($_GET["id"]);
			?>
			<strong>Viewing test: <?php echo $test[TEST_NAME] ?></strong>
			<p>
				<form action='admin.php' method='post'>
				<input type='hidden' name='action' value='set_auto_conv' />
				<input type='hidden' name='id' value='<?php echo $_GET["id"] ?>' />
				Auto select a variant when it gets to
				<input type='text' name='conversions' value='<?php echo $test[TEST_AUTO_CONV]; ?>' style='width:50px' />
				conversions
				<input type='submit' value='update' /> (0 for no autoselect)
				</form>
			</p>
			<p>
				<form action='admin.php' method='post'>
				<input type='hidden' name='action' value='add_variant' />
				<input type='hidden' name='id' value='<?php echo $_GET["id"] ?>' />
				Add new variant url: <input type='text' name='variant_url' /><input type='submit' value='add' />
				</form>
			</p>
			Current variants, hits and conversions:
			<table>
				<tr><th>URL</th><th>Visitors funnelled</th><th>Conversions tracked</th><th>&nbsp;</th></tr>
			<?php
				$variants = db::get_variants($_GET["id"]);
				foreach($variants as $variant) {
					echo "<tr>";
					echo "<td>".$variant[VARIANT_URL]."</td>";
					echo "<td>".$variant[VARIANT_HITS]."</td>";
					echo "<td>".$variant[VARIANT_CONV]."</td>";
					echo "<td><form action='admin.php' method='post'>
							<input type='hidden' name='action' value='delete_variant' />
							<input type='hidden' name='variant_id' value='".$variant[VARIANT_ID]."' />
							<input type='hidden' name='id' value='".$_GET["id"]."' />
							<input type='submit' value='Delete' />
							</form>
						</td>";
					echo "</tr>";
				}
			?>
			</table>
			<p>
			<form action='admin.php' method='post'>
				<input type='hidden' name='action' value='reset_test' />
				<input type='hidden' name='id' value='<?php echo $test[TEST_ID]; ?>' />
				<input type='submit' value='Reset all hits and conversions' onclick='return confirm("are you sure?") ' />
			</form>
			</p>
			<?php
				
		break;
	
		case 'account':
			if (isset($_POST["current_password"])) {
				$current = $_POST["current_password"];
				$new = $_POST["new_password"];
				$new2 = $_POST["new_password2"];
				if ($new != $new2) {
					echo "<p class='message'>Password confirmation does not match the new password</p>";
				} elseif (!system::check_admin_password($current)) {
					echo "<p class='message'>Current password incorrect</p>";
				} else {
					system::set_admin_password($new);
					echo "<p class='message'>Password has been updated</p>";
				}
			}
		?>
			<form action="admin.php?page=account" method="post">
				<table>
				<tr><td>Current password</td><td><input type="password" name="current_password" /></td>
				<tr><td>New password</td><td><input type="password" name="new_password" /></td>
				<tr><td>Confirm new password</td><td><input type="password" name="new_password2" /></td>
				<tr><td>&nbsp;</td><td><input type='submit' value='Change Password' /></td>
				</table>
			</form>
		<?php
		break;
		
		case 'tracking':
			?>
				<p>Use the following tracking code:</p>
				<textarea style='width:400px; height:100px'><?php
					echo htmlspecialchars('<script type=\'text/javascript\' src=\''.system::get_domain().'/'.system::get_directory().'/track.php\'></script>',ENT_QUOTES);
				?></textarea>
				<p>To use, copy the tag into the &lt;head&gt; section of the page you want to track. When visitors visit that page it will count as a conversion hit on the variant that they were given for the test they clicked</p>
			<?php
		break;
	}
}
?>
	</div>
</body>
</html>
