<?php



/**

 * Template for admin page: Settings

 */



if( ! current_user_can( 'manage_options' ) ){

    return;

} // restrict access



?>



<div class="wrap">

    <h2><?php _e( 'Settings', 'wp_newswire' ); ?></h2>

    <?php wp_newswire_messages(); ?>

    <form method="post" action="<?php echo esc_attr( add_query_arg( 'action', 'save' ) ); ?>">

        <?php wp_nonce_field( 'wpnwr_settings', 'wpnwr_settings_nonce' ); ?>

        <hr>

        <h3><?php _e( 'Queue Settings', 'wp_newswire' ); ?></h3>

        <hr>

        <table class="form-table">

            <tbody>

                <tr>

                    <th class="row">

                        <label for="wpnwr_queue_time_interval" class="wpnwr-required"><?php _e( 'Time Interval', 'wp_newswire' ); ?></label>

                    </th>

                    <td>

                        <input id="wpnwr_queue_time_interval" name="wpnwr_settings[queue_time_interval]" type="text" value="<?php echo esc_attr( $settings['queue_time_interval'] ); ?>" class="regular-text">

                        <select name="wpnwr_settings[queue_time_interval_unit]" style="vertical-align: top;">

                            <option value="sec" <?php selected( $settings['queue_time_interval_unit'], 'sec' ); ?>><?php esc_html_e( 'Seconds', 'wp_newswire' ); ?></option>

                            <option value="min" <?php selected( $settings['queue_time_interval_unit'], 'min' ); ?>><?php esc_html_e( 'Minutes', 'wp_newswire' ); ?></option>

                            <option value="hr" <?php selected( $settings['queue_time_interval_unit'], 'hr' ); ?>><?php esc_html_e( 'Hours', 'wp_newswire' ); ?></option>

                        </select>

                        <p class="description"><?php _e( 'How long to wait before another queue update is requested.', 'wp_newswire' ); ?></p>

                    </td>

                </tr>

                <tr>

                    <th class="row">

                        <label for="wpnwr_queue_chunks" class="wpnwr-required"><?php _e( 'Items Quantity', 'wp_newswire' ); ?></label>

                    </th>

                    <td>

                        <input id="wpnwr_queue_chunks" name="wpnwr_settings[queue_chunks]" type="text" value="<?php echo esc_attr( $settings['queue_chunks'] ); ?>" class="regular-text">

                        <p class="description"><?php _e( 'How many items to fetch per one request. Recommended range: from 1 to 5 items. ', 'wp_newswire' ); ?></p>

                    </td>

                </tr>

            </tbody>

        </table>

        <hr>

        <h3><?php _e( 'Youtube Settings', 'wp_newswire' ); ?></h3>

        <hr>

        <table class="form-table">

            <tbody>

                <tr>

                    <th class="row">

                        <label for="wpnwr_youtube_data_api_key"><?php _e( 'Youtube Data API key', 'wp_newswire' ); ?></label>

                    </th>

                    <td>

                        <input id="wpnwr_youtube_data_api_key" name="wpnwr_settings[youtube_data_api_key]" type="text" value="<?php echo esc_attr( $settings['youtube_data_api_key'] ); ?>" class="regular-text">

                        <p class="description">

                            <?php printf( __( 'Get your %s to start importing data from youtube.', 'wp_newswire' ), 

                                '<a href="#wpnwr_youtube_data_api_key_instructions" class="wpnwr-opener">' . __( 'Youtube Data API key', 'wp_newswire') . '</a>' ); ?>

                        </p>

                        <div id="wpnwr_youtube_data_api_key_instructions" class="wpnwr-opener-target">

                            <?php ?>

                            <ol>

                                <li><?php

                                $google_console_link = '<a href="https://console.developers.google.com/" target="_blank">' . 

                                        __( 'Google Developers Console', 'wp_newswire' ) . '</a>';

                                printf( __( 'Go to the %s.', 'wp_newswire' ), $google_console_link ); ?></li>

                                <li><?php _e( 'Select a project or create a new one.', 'wp_newswire' ); ?></li>

                                <li><?php _e( 'In the sidebar on the left, select <strong>APIs & auth</strong>. In the list of APIs, make sure the status is <strong>ON</strong> for the <strong>YouTube Data API v3</strong>.', 'wp_newswire' ); ?></li>

                                <li><?php _e( 'In the sidebar on the left, select <strong>Credentials</strong>.', 'wp_newswire' ); ?></li>

                                <li><?php _e( 'Click on <strong>Create new Key</strong> button and choose <strong>Server Key</strong> option.', 'wp_newswire' ); ?></li>

                                <li><?php _e( 'Optionally set IP address restriction by adding your server IP address in the modal field. Click <strong>Create</strong> button.', 'wp_newswire' ); ?></li>

                                <li><?php _e( 'Copy the value for <strong>API KEY</strong> to the field above.', 'wp_newswire' ); ?></li>

                            </ol>  

                            <p><?php _e( '<em>Note:</em> If you already have <strong>Server Key</strong> generated skip through steps 5 and 6.', 'wp_newswire' ); ?></p>

                        </div>

                    </td>

                </tr>

            </tbody>

        </table>

        <?php submit_button( __( 'Save Settings', 'wp_newswire' ) ); ?>

    </form>

</div><!-- /.wrap -->