<?php



/**

 * Template for admin page: Newswire List

 */



if( ! current_user_can( 'manage_options' ) ){

    return;

} // restrict accessss



?>



<div class="wrap">

    <h2><?php _e( 'Newswire List', 'wp_newswire' ); ?></h2>

    <?php wp_newswire_messages(); ?>

    <form method="post" action="<?php echo esc_attr(add_query_arg( 'action', 'delete' ) ); ?>">

        <?php wp_nonce_field( 'wpnwr_newswire_list', 'wpnwr_newswire_list_nonce' ); ?>

        <div class="wpnwr-newswire-list-header">

            <a href="#wpnwr-list-table-rss" class="button button-large button-disabled"><?php _e( 'RSS Feeds', 'wp_newswire' ); ?></a>

            <a href="#wpnwr-list-table-videos" class="button button-large"><?php _e( 'Youtube Videos', 'wp_newswire' ); ?></a>

            <a href="#wpnwr-list-table-prwire" class="button button-large"><?php _e( 'Press Releases', 'wp_newswire' ); ?></a>

        </div><!-- /.wpnwr-newswire-list-header -->

        

        <div id="wpnwr-list-table-rss" class="wpnwr-newswire-list-table-container wpnwr-state-active">

            <?php 

                $list_table = new WP_Newswire_List_Page_List_Table( 'rss' );

                $list_table->prepare_items();

                $list_table->display();

            ?>

        </div><!-- /#wpnwr-list-table-rss -->

        <div id="wpnwr-list-table-videos" class="wpnwr-newswire-list-table-container">

            <?php 

                $list_table = new WP_Newswire_List_Page_List_Table( 'video' );

                $list_table->prepare_items();

                $list_table->display();

            ?>

        </div><!-- /#wpnwr-list-table-videos -->

        <div id="wpnwr-list-table-prwire" class="wpnwr-newswire-list-table-container">

            <?php 

                $list_table = new WP_Newswire_List_Page_List_Table( 'prwire' );

                $list_table->prepare_items();

                $list_table->display();

            ?>

        </div><!-- /#wpnwr-list-table-prwire -->

        

        <?php submit_button( __( 'Delete', 'wp_newswire' ) ); ?>

    </form>

</div><!-- /.wrap -->