<?php



/**

 * Template for admin page: Add RSS Feed

 */



if( ! current_user_can( 'manage_options' ) ){

    return;

} // restrict access

?>



<div class="wrap">

    <h2><?php _e( 'Add RSS Feed', 'wp_newswire' ); ?></h2>

    <?php wp_newswire_messages(); ?>

    <form method="post" action="<?php echo esc_attr( add_query_arg( 'action', 'add' ) ); ?>">

        <?php wp_nonce_field( 'wpnwr_add_rss', 'wpnwr_add_rss_nonce' ); ?>

        <table class="form-table">

            <tbody>

                <tr>

                    <th class="row">

                        <label for="wpnwr_feed_address" class="wpnwr-required"><?php _e( 'RSS Feed Address', 'wp_newswire' ); ?></label>

                    </th>

                    <td>

                        <input id="wpnwr_feed_address" name="wpnwr_feed[address]" type="text" value="<?php echo esc_attr( $address ); ?>" class="regular-text code">

                    </td>

                </tr>

                <tr>

                    <th class="row">

                        <label for="wpnwr_keywords"><?php _e( 'Filter Stories by Keywords', 'wp_newswire' ); ?></label>

                    </th>

                    <td>

                        <input id="wpnwr_keywords" name="wpnwr_feed[keywords]" type="text" value="<?php echo esc_attr( $keywords ); ?>" class="regular-text">

                        <p class="description"><?php _e( 'Separated by commas.', 'wp_newswire' ); ?></p>

                    </td>

                </tr>

                <tr>

                    <th class="row">

                        <label for="wpnwr_length"><?php _e( 'Snippet Length', 'wp_newswire' ); ?></label>

                    </th>

                    <td>

                        <input id="wpnwr_length" name="wpnwr_feed[length]" type="text" value="<?php echo esc_attr( $length ); ?>" class="small-text">

                        <p class="description"><?php _e( 'Number of sentences to publish. HTML tags will be stripped.', 'wp_newswire' ); ?></p>

                    </td>

                </tr>

                <tr>

                    <th class="row">

                        <label for="wpnwr_import_number"><?php _e( 'Import', 'wp_newswire' ); ?></label>

                    </th>

                    <td>

                        <input id="wpnwr_import_number" name="wpnwr_feed[import_number]" type="text" value="<?php echo esc_attr( $import_number ); ?>" class="small-text">

                        <p class="description"><?php _e( 'Number of prior articles to import', 'wp_newswire' ); ?></p>

                    </td>

                </tr>

                <tr>

                    <th class="row">

                        <label for="wpnwr_include_images"><?php _e( 'Include Images', 'wp_newswire' ); ?></label>

                    </th>

                    <td>

                        <input id="wpnwr_include_images" name="wpnwr_feed[include_images]" type="checkbox" value="yes" <?php checked( $include_images, 'yes', true ); ?>>

                    </td>

                </tr>

                <tr>

                    <th class="row">

                        <label for="wpnwr_manually"><?php _e( 'Manually Approve New Posts', 'wp_newswire' ); ?></label>

                    </th>

                    <td>

                        <input id="wpnwr_manually" name="wpnwr_feed[manually]" type="checkbox" value="yes" <?php checked( $manually, 'yes', true ); ?>>

                    </td>

                </tr>

                <tr>

                    <th class="row">

                        <label for="wpnwr_html_before"><?php _e( 'Extra HTML Before Snippet', 'wp_newswire' ); ?></label>

                    </th>

                    <td>

                        <textarea id="wpnwr_html_before" name="wpnwr_feed[html_before]" rows="4" cols="50"><?php echo esc_textarea( $html_before ); ?></textarea>

                    </td>

                </tr>

                <tr>

                    <th class="row">

                        <label for="wpnwr_html_after"><?php _e( 'Extra HTML After Snippet', 'wp_newswire' ); ?></label>

                    </th>

                    <td>

                        <textarea id="wpnwr_html_after" name="wpnwr_feed[html_after]" rows="4" cols="50"><?php echo esc_textarea( $html_after ); ?></textarea>

                    </td>

                </tr>

                <tr>

                    <th class="row">

                        <label for="wpnwr_post_type"><?php _e( 'Add to', 'wp_newswire' ); ?></label>

                    </th>

                    <td>

                        <select id="wpnwr_post_type" name="wpnwr_feed[post_type]">

                            <option value="post" <?php selected( $post_type, 'post' ) ?>><?php _e( 'Posts', 'wp_newswire' ); ?></option>

                            <option value="page" <?php selected( $post_type, 'page' ) ?>><?php _e( 'Pages', 'wp_newswire' ); ?></option>

                        </select>

                        <?php wp_dropdown_categories( array(

                            'show_option_none' => __( 'None', 'wp_newswire' ),

                            'hide_empty' => false,

                            'name' => 'wpnwr_feed[post_category]',

                            'id' => 'wpnwr_post_category',

                            'selected' => $post_category

                        ) ); ?>

                    </td>

                </tr>

            </tbody>

        </table>

        <?php submit_button( __( 'Add RSS Feed', 'wp_newswire' ) ); ?>

    </form>

</div><!-- /.wrap -->