<?php



/**

 * @package WP_Newswire

 */

class WP_Newswire{

    public $messages = array();



    /**

     * Constructor

     */

    function __construct() {

    }

    

    public function add_message($state, $message) {

        $this->messages[$state][] = $message;

    }

    

# Data

    

    public function data_setup() {

        // PR Wire Allowed Tags

        $prwire_allowed_content_tags = $this->get_data( 'prwire_allowed_content_tags' );

        

        if( ! empty( $prwire_allowed_content_tags ) ){

            foreach ( $prwire_allowed_content_tags as $tag_name ){

                $prwire_allowed_content_tag_string .= '<' . $tag_name . '>';

            }

            

            $this->add_data( 'prwire_allowed_content_tag_string', $prwire_allowed_content_tag_string );

        }

    }

    

    public function add_data( $data_name, $data ) {

        global $wp_newswire_data;

        

        if( isset( $wp_newswire_data[$data_name] ) ){

            return;

        } // already exists

        

        $wp_newswire_data[$data_name] = $data;

    }

    

    public function get_data( $data_name ) {

        global $wp_newswire_data;

        

        return $wp_newswire_data[$data_name];

    }

    

# Initialization

    

    /**

     * Plugin initialization.

     */

    public function init() {

        // Initialize Settings

        global $wp_newswire_settings_manager;

        $wp_newswire_settings_manager = new WP_Newswire_Settings_Manager();

        $wp_newswire_settings_manager->init();

                

        // Initialize Queue

        global $wp_newswire_queue_manager;

        $wp_newswire_queue_manager = new WP_Newswire_Queue_Manager();

        $wp_newswire_queue_manager->init();        

    }

    

    /**

     * Configuration setup.

     */

    public function config_setup() {

        if( ! defined( 'WP_NEWSWIRE_QUEUE_TIME_INTERVAL' ) ){

            $interval = wp_newswire_get_setting( 'queue_time_interval' );

            $unit = wp_newswire_get_setting( 'queue_time_interval_unit' );

            define( 'WP_NEWSWIRE_QUEUE_TIME_INTERVAL', wp_newswire_count_seconds( $interval, $unit) );

        }

        if( ! defined( 'WP_NEWSWIRE_QUEUE_CHUNKS' ) ){

            define( 'WP_NEWSWIRE_QUEUE_CHUNKS', wp_newswire_get_setting( 'queue_chunks' ) );

        }

        if( ! defined( 'WP_NEWSWIRE_YOUTUBE_DATA_API_KEY' ) ){

            define( 'WP_NEWSWIRE_YOUTUBE_DATA_API_KEY', wp_newswire_get_setting( 'youtube_data_api_key') );

        }

    }

    

    /**

     * Plugin setup.

     */

    public function setup() {

        $this->data_setup();

    }



    /**

     * Plugin activation.

     */

    public function plugin_activation() {

        WP_Newswire::setup_database(); // database

        WP_Newswire::default_settings();

        WP_Newswire_Queue_Manager::setup_schedule(); // queue update scheduler

    }

    

    /**

     * Plugin deactivation.

     */

    public function plugin_deactivation() {

        WP_Newswire_Queue_Manager::deschedule_cron_event(); // remove queue update scheduler

    }

    

# Libraries

    

    /**

     * Loads necessary plugin files.

     */

    public function library() {

        // Feed

        require_once WP_NEWSWIRE_LIB_DIR . 'class.wp-newswire-feed-item.php';

        require_once WP_NEWSWIRE_LIB_DIR . 'class.wp-newswire-feed-manager.php';

        require_once WP_NEWSWIRE_LIB_DIR . 'class.wp-newswire-feed-iterator.php';

        // Importers

        require_once WP_NEWSWIRE_LIB_DIR . 'class.wp-newswire-import-manager.php';

        require_once WP_NEWSWIRE_LIB_DIR . 'class.wp-newswire-rss-import-manager.php';

        require_once WP_NEWSWIRE_LIB_DIR . 'class.wp-newswire-video-import-manager.php';

        require_once WP_NEWSWIRE_LIB_DIR . 'class.wp-newswire-prwire-import-manager.php';

        // Queue

        require_once WP_NEWSWIRE_LIB_DIR . 'class.wp-newswire-queue-manager.php';

        // List Tables

        require_once WP_NEWSWIRE_LIB_DIR . 'class.wp-newswire-list-table.php';

        require_once WP_NEWSWIRE_LIB_DIR . 'class.wp-newswire-list-page-list-table.php';

        // Settings

        require_once WP_NEWSWIRE_LIB_DIR . 'class.wp-newswire-settings-manager.php';

        // Functions

        require_once WP_NEWSWIRE_LIB_DIR . 'functions.php';

    }

    

    /**

     * Prerequested library for downloading images.

     */

    public function image_sideload_library() {

        require_once( ABSPATH . 'wp-admin/includes/media.php' );

        require_once( ABSPATH . 'wp-admin/includes/file.php' );

        require_once( ABSPATH . 'wp-admin/includes/image.php' );

    }

    

# Database    

    

    /**

     * Sets up the database.

     * 

     * @global object $wpdb

     */

    public function setup_database() {

        global $wpdb;

        $table_name = WP_NEWSWIRE_TABLE_NAME;



        $sql = "CREATE TABLE $table_name (

            id int(11) NOT NULL AUTO_INCREMENT,

            hash VARCHAR(32) DEFAULT '' NOT NULL,

            type VARCHAR(20) DEFAULT '' NOT NULL,

            keywords VARCHAR(512) DEFAULT '' NOT NULL,

            posts int(11) NOT NULL,

            options mediumtext NOT NULL,

            time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,

            UNIQUE KEY id (id)

              );";



        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

        dbDelta( $sql );

    }

    

    public function default_settings() {

        $settings = WP_Newswire_Settings_Manager::retrieve_settings();

        if( $settings === false ){

            $default_settings = WP_Newswire::get_data( 'default_settings' );

            WP_Newswire_Settings_Manager::update_settings( $default_settings );

        }

    }

    

    

}