<?php



/**

 * @package WP_Newswire

 * @subpackage Importer

 */

class WP_Newswire_Video_Import_Manager extends WP_Newswire_Import_Manager{

    public $youtube;

    protected $skip_keyword_search = true;

            

    function __construct( $number = 0, $keywords = '' ) {

        $this->setup_feed();

        parent::__construct( $number, $keywords );

    }

    

    public function setup_feed() {

        if( ! class_exists( 'Google_Client' ) ){

            set_include_path( WP_NEWSWIRE_INC_DIR );

            require_once 'Google/Client.php';

            require_once 'Google/Service/YouTube.php';

        }

        

        $client = new Google_Client();

        $client->setDeveloperKey( WP_NEWSWIRE_YOUTUBE_DATA_API_KEY );

        $this->youtube = new Google_Service_YouTube( $client );

    }



    public function get_items() {

        try{

            $search_items = $this->youtube->search->listSearch('id,snippet', array(

                'q' => $this->keywords,

                'videoSyndicated' => 'true',

                'maxResults' => 25,

                'order' => 'date',

                'type' => 'video',

                'videoEmbeddable' => 'true'

            ));

        } 

        catch ( Google_ServiceException $e ) {

            $message = sprintf( __( 'A service error occurred: <code>%s</code>', 'wp_newswire' ), 

                    htmlspecialchars( $e->getMessage() ) );

            wp_newswire_add_message( $message, 'error' );

        } 

        catch ( Google_Exception $e ) {

            $message = sprintf( __( 'A client error occurred: <code>%s</code>', 'wp_newswire' ), 

                    htmlspecialchars( $e->getMessage() ) );

            wp_newswire_add_message( $message, 'error' );

        }

        

        if( empty( $search_items['items'] ) ){

            return array();

        } // no items found

        

        return $search_items['items'];

    }



    public function get_item_datetime( $item ) {

        $date = $item->getSnippet()->getPublishedAt();

        return ( new DateTime( $date ) );

    }



    public function get_item_keywords_search_area_content( $item ) {

        return false;

    }

    

    public function prepare_item( $item, $args ) {

        $video_ID = $item->getId()->getVideoId();

        $video_URL = 'http://www.youtube.com/watch?v=' . $video_ID;

        $content = "\n" . $video_URL . "\n";



        $snippet = $item->getSnippet();

        $prepared_item['title'] = $snippet->getTitle();

        $prepared_item['original_content'] = $content;

        $prepared_item['content'] = wp_newswire_feed_item_content_html(

                $content, $args['length'], $args['html_before'], $args['html_after'] );

        $prepared_item['date'] = new DateTime( $snippet->getPublishedAt() );

        $prepared_item['image'] = $this->get_highest_possible_image( $snippet->getThumbnails() );

        

        return $prepared_item;

    }

    

    /**

     * Tries to get the best image available in the video thumbnail versions.

     * 

     * @param object \Google_Service_YouTube_ThumbnailDetails $thumbnail_details

     * @return string URL to the image

     */

    public function get_highest_possible_image( $thumbnail_details ) {

        $image = $thumbnail_details->getMaxres();

        if( ! empty( $image ) ){

            return $image->getUrl();

        } // max resolution

        

        $image = $thumbnail_details->getHigh();

        if( ! empty( $image ) ){

            return $image->getUrl();

        } // high resolution

        

        $image = $thumbnail_details->getMedium();

        if( ! empty( $image ) ){

            return $image->getUrl();

        } // medium resolution

        

        $image = $thumbnail_details->getStandard();

        if( ! empty( $image ) ){

            return $image->getUrl();

        } // standard resolution

        

        return $thumbnail_details->getDefault()->getUrl(); // default

    }

    

}