<?php



/**

 * @package WP_Newswire

 * @subpackage Settings

 */

class WP_Newswire_Settings_Manager {

    const OPTION_NAME = 'wpnwr_settings';

    public $settings;

    

    function __construct( $settings = false ) {

        if ( $settings !== false ){

            $this->settings = $settings;

        }

    }

    

    public function init() {

        $this->set_settings();

        global $wp_newswire;

        $wp_newswire->config_setup();

    }

    

    protected function set_settings() {

        $settings = $this->retrieve_settings();

        $this->settings = ( ! empty( $settings ) ) ? $settings : array();        

    }

    

    public function retrieve_settings() {

        $settings = get_option( WP_Newswire_Settings_Manager::OPTION_NAME );

        return $settings;

    }

    

    public function update_settings( $new_settings ) {

        $updated = update_option( WP_Newswire_Settings_Manager::OPTION_NAME, $new_settings );

        if( ! $updated ){

            $old_settings = get_option( WP_Newswire_Settings_Manager::OPTION_NAME );

            if( $new_settings == $old_settings ){

                return true;

            } // nothing to update, no error occurred

        }

        

        return $updated;

    }

    

    public function validate() {

        $error_occurred = false;

        $settings = $this->settings;

        

        // time interval validation

        if( ! isset( $settings['queue_time_interval'] ) || $settings['queue_time_interval'] === '' ){

            wp_newswire_add_message( __('Please fill in <strong>Time Interval</strong> field.', 'wp_newswire'), 'error' );

            $error_occurred = true;

        }

        if( ! preg_match( '/^[0-9]*$/', $settings['queue_time_interval'] ) ){

            wp_newswire_add_message( __('Please add numeric value for <strong>Time Interval</strong> field.', 'wp_newswire'), 'error' );

            $error_occurred = true;

        }

        

        // items quantity

        if( ! isset( $settings['queue_chunks'] ) || $settings['queue_chunks'] === ''){

            wp_newswire_add_message( __('Please fill in <strong>Items Quantity</strong> field.', 'wp_newswire'), 'error' );

            $error_occurred = true;

        }

        if( ! preg_match( '/^[0-9]*$/', $settings['queue_chunks'] ) ){

            wp_newswire_add_message( __('Please add numeric value for <strong>Items Quantity</strong> field.', 'wp_newswire'), 'error' );

            $error_occurred = true;

        }

        

        // Test Youtube API key

        if( isset( $settings['youtube_data_api_key'] ) && $settings['youtube_data_api_key'] !== '' ){

            if( ! class_exists( 'Google_Client' ) ){

                set_include_path( WP_NEWSWIRE_INC_DIR );

                require_once 'Google/Client.php';

                require_once 'Google/Service/YouTube.php';

            }

            $client = new Google_Client();

            $client->setDeveloperKey( $settings['youtube_data_api_key'] );

            $youtube = new Google_Service_YouTube( $client );

            $message = __( 'Youtube Data API key did not validate. ', 'wp_newswire' );

            try{

                $search_items = $youtube->search->listSearch('id', array(

                    'q' => 'test search',

                    'maxResults' => 1,

                ));

            } // test search

            catch ( Google_ServiceException $e ) {

                $message .= sprintf( __( 'A service error occurred: <code>%s</code>', 'wp_newswire' ), 

                        htmlspecialchars( $e->getMessage() ) );

                wp_newswire_add_message( $message, 'error' );

                $error_occurred = true;

            } 

            catch ( Google_Exception $e ) {

                $message .= sprintf( __( 'A client error occurred: <code>%s</code>', 'wp_newswire' ), 

                        htmlspecialchars( $e->getMessage() ) );

                wp_newswire_add_message( $message, 'error' );

                $error_occurred = true;

            }

        }

        

        return ! $error_occurred;

    }

}