<?php

/**
 * @package WP_Newswire
 * @subpackage Importer
 */
class WP_Newswire_RSS_Import_Manager extends WP_Newswire_Import_Manager{
    public $rss;
    public $address = '';
    
    function __construct( $address, $number, $keywords = '' ) {
        $this->address = $address;
        $this->has_errors = ! $this->setup_rss_feed();
        
        parent::__construct( $number, $keywords );
    }
    
    /**
    * Connects to RSS feed and sets up RSS data.
    * 
    * @return boolean True on success, false on failure.
    */
    function setup_rss_feed (){
        if ( !class_exists('SimplePie') ){
            require_once( ABSPATH . WPINC . '/class-simplepie.php' );
        }
        $rss = new SimplePie();
        $rss->set_feed_url( $this->address );
        $rss->enable_cache( WP_NEWSWIRE_RSS_CACHE );
        $rss->enable_order_by_date(true);
        $rss->set_cache_location( WP_NEWSWIRE_RSS_CACHE_DIR );
        $rss->set_cache_duration(1800);
        $rss->init();
        $rss->handle_content_type();

        if( $rss->error() ){
            wp_newswire_add_message( 
                    __( 'The RSS feed could not be fetched.', 'wp_newswire' ),
                    'error' );
            return false;
        }

        $this->rss = $rss;

        return true;
   }
   
    public function get_items() {
        return $this->rss->get_items();
    }

    public function get_item_datetime( $item ) {		$date = $item->get_date();                return ( $date ? ( new DateTime( $date ) ) : 0 );

    }

    public function get_item_keywords_search_area_content( $item ) {
        return $item->get_title() . $item->get_content();
    }
    public function prepare_item( $item, $args ) {
        // source
        $source = $item->get_source();
        $source = ( $source ) ? $item->get_permalink() : $item->get_permalink();
        $content = $item->get_content();

        $prepared_item['title'] = $item->get_title();
        $prepared_item['original_content'] = $content;
        $prepared_item['content'] = wp_newswire_feed_item_content_html(
                $content, $args['length'], $args['html_before'], $args['html_after'], $source );
        $prepared_item['date'] = new DateTime( $item->get_date() );
        return $prepared_item;
    }
}