<?php

/**
 * @package WP_Newswire
 * @subpackage Importer
 */
class WP_Newswire_PR_Wire_Import_Manager extends WP_Newswire_Import_Manager{
    public $search_page_doc;
    protected $the = array(); // current data for iteration
    protected $skip_keyword_search = true;
            
    function __construct( $number = 0, $keywords = '' ) {
        parent::__construct( $number, $keywords );
        $this->search_page_doc = new DOMDocument();        
        $this->has_errors = ! $this->setup_feed();
    }
    
    protected function request( $url ) {
        $response = wp_remote_request( $url );
        if( is_a( $response, 'WP_Error' ) ){
            return false;
        }
        $html = wp_remote_retrieve_body($response);

        return $html;
    }
    
    public function setup_feed() {
        $max_results = 25;
        $page = 1;
        
        // keyword sanitization
	$keyword = str_replace( ' ', '+', $this->keywords );	
	$keyword = urlencode( $keyword );
        
        $search_url = "http://www.prweb.com/Search.aspx?Search-releases=$keyword&start=$page";
        $html = $this->request( $search_url );
        if( ! $html ){
            wp_newswire_add_message( 
                    __( 'cURL is disabled. Please contact your server provider.', 'wp_newswire' ), 'error' );
        } // HTML not retrieved
        
        if ( ! @$this->search_page_doc->loadHTML( $html ) ) {
            wp_newswire_add_message( __( 'Could not read search results.', 'wp_newswire' ), 'error' );
            return false;
        }
        return true;
    }
    
    public function get_items() {
        $xpath = new DOMXPath( $this->search_page_doc );
        $items_dom_els = $xpath->query( '//div[@id="release-list"]/div[@class="article-box-cont"]' );
		
        if( ! $items_dom_els->length ){
            return [];
        } // no items found   
        
        $counter = 0;
        $items = array();
        
        for( $i = 0; $i < $items_dom_els->length; $i ++ ){
            $item_dom_el = $items_dom_els->item( $i );
			
            $item_date_val = $item_dom_el->getElementsByTagName( 'span' )->item( 0 )->nodeValue;
            $item_date = new DateTime( $item_date_val );
			
            $items[] = array(
                'dom_el' => $item_dom_el,
                'date' => $item_date
            );
        } // convert to array and preserve date

        return $items;
    }

    public function get_item_datetime( $item ) {
        return $item['date'];
    }

    public function get_item_keywords_search_area_content( $item ) {
        return false;
    }
    
    protected function setup_the( $data_name, $data ) {
        $this->the[$data_name] = $data;
    }
    protected function get_the_item_url() {
        $item_url = $this->the['item_dom']->getElementsByTagName( 'a' )->item( 0 )->getAttribute( 'href' );
        
        return $item_url;
    }
    
    protected function get_the_item_title(){
        $title = $this->the['item_xpath']->query( '//h1[@class="article-title"]');
        if( $title->length ){
            $title = $title->item( 0 )->textContent;
            /* if ( function_exists( 'iconv' ) ) {
                $title = iconv( 'UTF-8', 'ISO-8859-1//IGNORE', $title );
            } */ // Use this if WP can't handle it in future releases
        }
        
        return $title;
    }
    
    protected function get_the_item_content(){
        $content_node_list = $this->the['item_xpath']->query( '//div[@class="article-text"]/p[@class="responsiveNews"]');
        if( $content_node_list->length > 1 ){
            for( $i = 1; $i < $content_node_list->length; $i ++ ){
                $paragraph_node = $content_node_list->item( $i );
                $content .= $this->the['item_doc']->saveHTML( $paragraph_node );
            }
            /* if ( function_exists( 'iconv' ) ) {
                $content = iconv( 'UTF-8', 'ISO-8859-1//IGNORE', $content );
            }*/ // Use this if WP can't handle it in future releases
            $content = $this->strip_tags( $content );
        }
        
        return $content;
    }
    
    protected function get_the_item_image() {
        $image = $this->the['item_xpath']->query( '//div[@class="news-image"]/img');
        if( $image->length < 1 ){
            return false;
        } // no image found
        $image = $image->item( 0 )->getAttribute( 'src' );
        
        return $image;
    }

    public function prepare_item( $item, $args ) {

		// Setup Dom
        $this->setup_the( 'item_dom', $item['dom_el'] );
        // URL
        $item_url = $this->get_the_item_url();
        
        // Try to load
        $item_full_html = $this->request( $item_url ); // HTML of the single item page
        $item_doc = new DOMDocument(); // Single item document
        if( ! $item_full_html || ! @$item_doc->loadHTML( $item_full_html ) ){
            wp_newswire_add_message( __( 'Could not read the item HTML.', 'wp_newswire' ), 'error' );
            return;
        } // couldn't read this item, give error message but continue
        
        // Setup current item
        $item_xpath = new DOMXPath( $item_doc );
        $this->setup_the( 'item_doc', $item_doc );
        $this->setup_the( 'item_xpath', $item_xpath );
        
        // Title
        $prepared_item['title'] = $this->get_the_item_title();
		
        // Content
        $prepared_item['original_content'] = $this->get_the_item_content();
        $prepared_item['content'] = wp_newswire_feed_item_content_html(
                $prepared_item['original_content'], 
                $args['length'], 
                $args['html_before'],
                $args['html_after'],
                $item_url );
		
        // Date
        $prepared_item['date'] =  $item['date'];
        
        $prepared_item['image'] = $this->get_the_item_image();

        return $prepared_item;
    }
    
    public function strip_tags( $content ) {
        global $wp_newswire;
        $allowed_tags_string = $wp_newswire->get_data( 'prwire_allowed_content_tag_string' );

        if( ! $allowed_tags_string ){
            return $content;
        }
        
        return strip_tags( $content, $allowed_tags_string );
    }
    
}